/*
 * Decompiled with CFR 0.152.
 */
package io.evitadb.store.dataType.serializer;

import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.Serializer;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import java.io.Serializable;
import java.util.Map;
import java.util.function.IntFunction;

public class MapSerializer<K extends Serializable, V extends Serializable>
extends Serializer<Map<K, V>> {
    public final IntFunction<Map<K, V>> setFactory;

    public void write(Kryo kryo, Output output, Map<K, V> object) {
        output.writeVarInt(object.size(), true);
        boolean classWritten = false;
        for (Map.Entry<K, V> entry : object.entrySet()) {
            if (!classWritten) {
                kryo.writeClass(output, ((Serializable)entry.getKey()).getClass());
                kryo.writeClass(output, ((Serializable)entry.getValue()).getClass());
                classWritten = true;
            }
            kryo.writeObject(output, entry.getKey());
            kryo.writeObject(output, entry.getValue());
        }
    }

    public Map<K, V> read(Kryo kryo, Input input, Class<? extends Map<K, V>> type) {
        int itemCount = input.readVarInt(true);
        Map<Serializable, Serializable> targetSet = this.setFactory.apply(itemCount);
        Class keyClass = null;
        Class valueClass = null;
        for (int i = 0; i < itemCount; ++i) {
            if (keyClass == null) {
                keyClass = kryo.readClass(input).getType();
                valueClass = kryo.readClass(input).getType();
            }
            targetSet.put((Serializable)kryo.readObject(input, keyClass), (Serializable)kryo.readObject(input, valueClass));
        }
        return targetSet;
    }

    public MapSerializer(IntFunction<Map<K, V>> setFactory) {
        this.setFactory = setFactory;
    }
}

