/*
 * Decompiled with CFR 0.152.
 */
package io.evitadb.store.dataType.serializer;

import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import com.esotericsoftware.kryo.serializers.ImmutableSerializer;
import io.evitadb.store.dataType.serializer.LocalDateSerializer;
import io.evitadb.store.dataType.serializer.LocalTimeSerializer;
import io.evitadb.store.dataType.serializer.ZoneOffsetSerializer;
import java.time.LocalDate;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import javax.annotation.Nonnull;

public class OffsetDateTimeSerializer
extends ImmutableSerializer<OffsetDateTime> {
    static void write(Output out, OffsetDateTime obj) {
        LocalDateSerializer.write(out, obj.toLocalDate());
        LocalTimeSerializer.write(out, obj.toLocalTime());
        ZoneOffsetSerializer.write(out, obj.getOffset());
    }

    @Nonnull
    static OffsetDateTime read(Input in) {
        LocalDate date = LocalDateSerializer.read(in);
        LocalTime time = LocalTimeSerializer.read(in);
        ZoneOffset offset = ZoneOffsetSerializer.read(in);
        return OffsetDateTime.of(date, time, offset);
    }

    public void write(Kryo kryo, Output out, OffsetDateTime obj) {
        OffsetDateTimeSerializer.write(out, obj);
    }

    public OffsetDateTime read(Kryo kryo, Input in, Class type) {
        return OffsetDateTimeSerializer.read(in);
    }
}

