/*
 * Decompiled with CFR 0.152.
 */
package io.evitadb.store.dataType.serializer;

import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.Serializer;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import io.evitadb.store.dataType.exception.StoredVersionNotSupportedException;
import io.evitadb.utils.Assert;
import java.io.ObjectStreamClass;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;

public class SerialVersionBasedSerializer<T>
extends Serializer<T> {
    private final Serializer<T> currentVersionSerializer;
    private final long currentSerializerUID;
    private Map<Long, Serializer<T>> backwardCompatibleSerializers;

    public SerialVersionBasedSerializer(Serializer<T> currentVersionSerializer, Class<T> targetClass) {
        this.currentSerializerUID = ObjectStreamClass.lookup(targetClass).getSerialVersionUID();
        this.currentVersionSerializer = currentVersionSerializer;
    }

    public void addBackwardCompatibleSerializer(long serialVersionUID, Serializer<T> backwardCompatibleSerializer) {
        Map serializerIndex = Optional.ofNullable(this.backwardCompatibleSerializers).orElseGet(() -> {
            this.backwardCompatibleSerializers = new HashMap<Long, Serializer<T>>(32);
            return this.backwardCompatibleSerializers;
        });
        serializerIndex.put(serialVersionUID, backwardCompatibleSerializer);
    }

    public final void write(Kryo kryo, Output output, T object) {
        output.writeLong(this.currentSerializerUID);
        this.currentVersionSerializer.write(kryo, output, object);
    }

    public T read(Kryo kryo, Input input, Class<? extends T> type) throws StoredVersionNotSupportedException {
        long serializedUID = input.readLong();
        if (serializedUID == this.currentSerializerUID) {
            return (T)this.currentVersionSerializer.read(kryo, input, type);
        }
        Serializer backwardCompatibleSerializer = Optional.ofNullable(this.backwardCompatibleSerializers).map(it -> (Serializer)it.get(serializedUID)).orElse(null);
        Assert.isTrue((backwardCompatibleSerializer != null ? 1 : 0) != 0, () -> new StoredVersionNotSupportedException(type, serializedUID, Optional.ofNullable(this.backwardCompatibleSerializers).map(Map::keySet).orElse(Collections.emptySet())));
        return (T)backwardCompatibleSerializer.read(kryo, input, type);
    }
}

