/*
 * Decompiled with CFR 0.152.
 */
package io.evitadb.store.dataType.serializer;

import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.Serializer;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import java.io.Serializable;

public class SerializableArraySerializer
extends Serializer<Serializable[]> {
    public void write(Kryo kryo, Output output, Serializable[] object) {
        output.writeVarInt(object.length, true);
        for (Serializable serializable : object) {
            if (serializable == null) {
                output.writeBoolean(false);
                continue;
            }
            output.writeBoolean(true);
            kryo.writeClassAndObject(output, (Object)serializable);
        }
    }

    public Serializable[] read(Kryo kryo, Input input, Class<? extends Serializable[]> type) {
        int arrayLength = input.readVarInt(true);
        Serializable[] serializables = new Serializable[arrayLength];
        for (int i = 0; i < arrayLength; ++i) {
            serializables[i] = input.readBoolean() ? (Serializable)kryo.readClassAndObject(input) : null;
        }
        return serializables;
    }
}

