/*
 * Decompiled with CFR 0.152.
 */
package io.evitadb.store.dataType.serializer;

import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.Serializer;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import java.io.Serializable;
import java.util.Set;
import java.util.function.IntFunction;

public class SetSerializer<T extends Serializable>
extends Serializer<Set<T>> {
    public final IntFunction<Set<T>> setFactory;

    public void write(Kryo kryo, Output output, Set<T> object) {
        output.writeVarInt(object.size(), true);
        boolean classWritten = false;
        for (Serializable itemInSet : object) {
            if (!classWritten) {
                kryo.writeClass(output, itemInSet.getClass());
                classWritten = true;
            }
            kryo.writeObject(output, (Object)itemInSet);
        }
    }

    public Set<T> read(Kryo kryo, Input input, Class<? extends Set<T>> type) {
        int itemCount = input.readVarInt(true);
        Set<T> targetSet = this.setFactory.apply(itemCount);
        Class itemClass = null;
        for (int i = 0; i < itemCount; ++i) {
            if (itemClass == null) {
                itemClass = kryo.readClass(input).getType();
            }
            targetSet.add((Serializable)kryo.readObject(input, itemClass));
        }
        return targetSet;
    }

    public SetSerializer(IntFunction<Set<T>> setFactory) {
        this.setFactory = setFactory;
    }
}

