/*
 * Decompiled with CFR 0.152.
 */
package io.evitadb.store.dataType.serializer;

import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import com.esotericsoftware.kryo.serializers.ImmutableSerializer;
import java.time.ZoneOffset;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class ZoneOffsetSerializer
extends ImmutableSerializer<ZoneOffset> {
    private static final Map<String, ZoneOffset> CACHE = new ConcurrentHashMap<String, ZoneOffset>();

    public void write(Kryo kryo, Output out, ZoneOffset obj) {
        ZoneOffsetSerializer.write(out, obj);
    }

    static void write(Output out, ZoneOffset obj) {
        out.writeString(obj.getId());
    }

    public ZoneOffset read(Kryo kryo, Input in, Class type) {
        return ZoneOffsetSerializer.read(in);
    }

    static ZoneOffset read(Input in) {
        String id = in.readString();
        return CACHE.computeIfAbsent(id, it -> {
            Map<String, ZoneOffset> map = CACHE;
            synchronized (map) {
                return ZoneOffset.of(id);
            }
        });
    }
}

