/*
 * Decompiled with CFR 0.152.
 */
package io.evitadb.store.dataType.serializer.data;

import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.Serializer;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import io.evitadb.dataType.data.DataItem;
import io.evitadb.dataType.data.DataItemMap;
import io.evitadb.utils.CollectionUtils;
import java.util.LinkedHashMap;
import java.util.Map;

public class DataItemMapSerializer
extends Serializer<DataItemMap> {
    public void write(Kryo kryo, Output output, DataItemMap dataItem) {
        output.writeVarInt(dataItem.getPropertyCount(), true);
        dataItem.forEach((propertyName, child, hasNext) -> {
            output.writeString(propertyName);
            kryo.writeClassAndObject(output, child);
        });
    }

    public DataItemMap read(Kryo kryo, Input input, Class<? extends DataItemMap> type) {
        int childrenCount = input.readVarInt(true);
        LinkedHashMap dataItems = CollectionUtils.createLinkedHashMap((int)childrenCount);
        for (int i = 0; i < childrenCount; ++i) {
            dataItems.put(input.readString(), (DataItem)kryo.readClassAndObject(input));
        }
        return new DataItemMap((Map)dataItems);
    }
}

