/*
 * Decompiled with CFR 0.152.
 */
package io.evitadb.store.dataType.serializer.trie;

import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.Serializer;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import io.evitadb.dataType.trie.TrieNode;
import io.evitadb.utils.Assert;
import java.io.Serializable;
import java.lang.reflect.Array;

public class TrieNodeSerializer<T extends Serializable>
extends Serializer<TrieNode<T>> {
    private static final ThreadLocal<Class<?>> ARRAY_TYPE = new ThreadLocal();

    public static void deserializeWithArrayType(Class<? extends Serializable> arrayType, Runnable runnable) {
        try {
            Assert.isPremiseValid((ARRAY_TYPE.get() == null ? 1 : 0) != 0, (String)"Should not ever happen!");
            ARRAY_TYPE.set(arrayType);
            runnable.run();
        }
        finally {
            ARRAY_TYPE.remove();
        }
    }

    public void write(Kryo kryo, Output output, TrieNode<T> trieNode) {
        int[] charIndex = trieNode.getCharIndex();
        output.writeVarInt(charIndex.length, true);
        output.writeInts(charIndex, 0, charIndex.length);
        String[] edgeLabels = trieNode.getEdgeLabels();
        output.writeVarInt(edgeLabels.length, true);
        for (String sb : edgeLabels) {
            output.writeString(sb);
        }
        Serializable[] values = trieNode.getValues();
        output.writeVarInt(values.length, true);
        for (Serializable value : values) {
            kryo.writeClassAndObject(output, (Object)value);
        }
        TrieNode[] children = trieNode.getChildren();
        output.writeVarInt(children.length, true);
        for (TrieNode child : children) {
            kryo.writeObject(output, (Object)child);
        }
    }

    public TrieNode<T> read(Kryo kryo, Input input, Class<? extends TrieNode<T>> type) {
        int charLength = input.readVarInt(true);
        int[] chars = input.readInts(charLength);
        int edgeLabelsLength = input.readVarInt(true);
        String[] edgeLabels = new String[edgeLabelsLength];
        for (int i = 0; i < edgeLabelsLength; ++i) {
            edgeLabels[i] = input.readString();
        }
        int valuesLength = input.readVarInt(true);
        Serializable[] values = (Serializable[])Array.newInstance(ARRAY_TYPE.get(), valuesLength);
        for (int i = 0; i < valuesLength; ++i) {
            values[i] = (Serializable)kryo.readClassAndObject(input);
        }
        int childrenLength = input.readVarInt(true);
        TrieNode[] children = new TrieNode[childrenLength];
        for (int i = 0; i < childrenLength; ++i) {
            children[i] = (TrieNode)kryo.readObject(input, TrieNode.class);
        }
        return TrieNode._internalBuild((int[])chars, (TrieNode[])children, (String[])edgeLabels, (Serializable[])values);
    }
}

