/*
 * Decompiled with CFR 0.152.
 */
package io.evitadb.store.dataType.serializer.trie;

import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.Serializer;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import io.evitadb.dataType.trie.Trie;
import io.evitadb.dataType.trie.TrieNode;
import io.evitadb.store.dataType.serializer.trie.TrieNodeSerializer;
import java.io.Serializable;
import java.util.concurrent.atomic.AtomicReference;

public class TrieSerializer<T extends Serializable>
extends Serializer<Trie<T>> {
    public void write(Kryo kryo, Output output, Trie<T> trie) {
        kryo.writeClass(output, trie.getType());
        kryo.writeObject(output, (Object)trie.getRoot());
    }

    public Trie<T> read(Kryo kryo, Input input, Class<? extends Trie<T>> type) {
        Class arrayType = kryo.readClass(input).getType();
        AtomicReference rootRef = new AtomicReference();
        TrieNodeSerializer.deserializeWithArrayType(arrayType, () -> {
            TrieNode rootNode = (TrieNode)kryo.readObject(input, TrieNode.class);
            rootRef.set(rootNode);
        });
        return Trie._internalBuild((Class)arrayType, (TrieNode)((TrieNode)rootRef.get()));
    }
}

