/*
 * Decompiled with CFR 0.152.
 */
package io.evitadb.store.service;

import com.esotericsoftware.kryo.io.ByteBufferInput;
import com.esotericsoftware.kryo.io.ByteBufferOutput;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import io.evitadb.store.exception.UnknownClassOnDeserializationException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.annotation.Nonnull;

public interface SerializationService<T> {
    @Nonnull
    public static Class<?> getClassTypeSafely(String className) {
        if (Character.isLowerCase(className.charAt(0))) {
            switch (className) {
                case "boolean": {
                    return Boolean.TYPE;
                }
                case "byte": {
                    return Byte.TYPE;
                }
                case "short": {
                    return Short.TYPE;
                }
                case "int": {
                    return Integer.TYPE;
                }
                case "long": {
                    return Long.TYPE;
                }
                case "char": {
                    return Character.TYPE;
                }
            }
        }
        try {
            return Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            throw new UnknownClassOnDeserializationException("Serialized class " + className + " not found by actual classloader!");
        }
    }

    default public void serialize(@Nonnull T theObject, @Nonnull OutputStream os) {
        try (ByteBufferOutput output = new ByteBufferOutput(os);){
            this.serialize(theObject, (Output)output);
        }
    }

    public void serialize(@Nonnull T var1, @Nonnull Output var2);

    default public T deserialize(@Nonnull InputStream is) {
        try (ByteBufferInput input = new ByteBufferInput(is);){
            T t = this.deserialize((Input)input);
            return t;
        }
    }

    public T deserialize(@Nonnull Input var1);
}

