/*
 * Decompiled with CFR 0.152.
 */
package io.exoquery.terpal.plugin.transform;

import io.exoquery.terpal.plugin.logging.CompileLogger;
import io.exoquery.terpal.plugin.transform.BuilderContext;
import io.exoquery.terpal.plugin.transform.TransformInterepolatorInvoke;
import io.exoquery.terpal.plugin.transform.TransformPrintSource;
import io.exoquery.terpal.plugin.transform.TransformerOrigin;
import java.nio.file.Path;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.backend.common.IrElementTransformerVoidWithContext;
import org.jetbrains.kotlin.backend.common.ScopeWithIr;
import org.jetbrains.kotlin.backend.common.extensions.IrPluginContext;
import org.jetbrains.kotlin.config.CompilerConfiguration;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationParent;
import org.jetbrains.kotlin.ir.declarations.IrSymbolOwner;
import org.jetbrains.kotlin.ir.expressions.IrCall;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.symbols.IrSymbol;
import org.jetbrains.kotlin.ir.types.IrSimpleType;
import org.jetbrains.kotlin.ir.types.IrType;
import org.jetbrains.kotlin.ir.util.AdditionalIrUtilsKt;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lio/exoquery/terpal/plugin/transform/VisitTransformExpressions;", "Lorg/jetbrains/kotlin/backend/common/IrElementTransformerVoidWithContext;", "context", "Lorg/jetbrains/kotlin/backend/common/extensions/IrPluginContext;", "config", "Lorg/jetbrains/kotlin/config/CompilerConfiguration;", "projectDir", "Ljava/nio/file/Path;", "(Lorg/jetbrains/kotlin/backend/common/extensions/IrPluginContext;Lorg/jetbrains/kotlin/config/CompilerConfiguration;Ljava/nio/file/Path;)V", "typeIsFqn", "", "type", "Lorg/jetbrains/kotlin/ir/types/IrType;", "fqn", "", "visitCall", "Lorg/jetbrains/kotlin/ir/expressions/IrExpression;", "expression", "Lorg/jetbrains/kotlin/ir/expressions/IrCall;", "terpal-plugin-kotlin"})
public final class VisitTransformExpressions
extends IrElementTransformerVoidWithContext {
    @NotNull
    private final IrPluginContext context;
    @NotNull
    private final CompilerConfiguration config;
    @NotNull
    private final Path projectDir;

    public VisitTransformExpressions(@NotNull IrPluginContext context, @NotNull CompilerConfiguration config, @NotNull Path projectDir) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        Intrinsics.checkNotNullParameter((Object)projectDir, (String)"projectDir");
        this.context = context;
        this.config = config;
        this.projectDir = projectDir;
    }

    private final boolean typeIsFqn(IrType type, String fqn) {
        if (!(type instanceof IrSimpleType)) {
            return false;
        }
        IrSymbolOwner owner = ((IrSimpleType)type).getClassifier().getOwner();
        return owner instanceof IrClass ? Intrinsics.areEqual((Object)AdditionalIrUtilsKt.getKotlinFqName((IrDeclarationParent)((IrDeclarationParent)owner)).asString(), (Object)fqn) : false;
    }

    @NotNull
    public IrExpression visitCall(@NotNull IrCall expression) {
        Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
        ScopeWithIr scopeWithIr = this.getCurrentScope();
        Intrinsics.checkNotNull((Object)scopeWithIr);
        IrSymbol scopeOwner = scopeWithIr.getScope().getScopeOwnerSymbol();
        TransformerOrigin transformerCtx = new TransformerOrigin(this.context, this.config, this.getCurrentFile(), (IrExpression)expression);
        CompileLogger compileLogger = transformerCtx.getLogger();
        BuilderContext builderContext = transformerCtx.makeBuilderContext((IrExpression)expression, scopeOwner);
        TransformPrintSource transformPrint = new TransformPrintSource(builderContext);
        TransformInterepolatorInvoke transformInterpolations = new TransformInterepolatorInvoke(builderContext);
        IrExpression out = transformPrint.matches(expression) ? (IrExpression)transformPrint.transform(expression) : (transformInterpolations.matches(expression) ? transformInterpolations.transform(expression, this) : super.visitCall(expression));
        return out;
    }
}

