/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.tooling.archetype.generator;

import io.fabric8.tooling.archetype.generator.SimpleNamespaceContext;
import io.fabric8.utils.IOHelpers;
import io.fabric8.utils.Strings;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class ArchetypeHelper {
    private static String archetypeDescriptorUri = "http://maven.apache.org/plugins/maven-archetype-plugin/archetype-descriptor/1.0.0";
    private static String requiredPropertyXPath = "/ad:archetype-descriptor/ad:requiredProperties/ad:requiredProperty";
    private File archetypeFile;
    private File outputDir;
    private String groupId;
    private String artifactId;
    private String version;
    private String name;
    private String description;
    private String packageName = "";
    private Boolean verbose = Boolean.FALSE;
    private Boolean createDefaultDirectories = Boolean.TRUE;
    private Map<String, String> overrideProperties = new HashMap<String, String>();
    private String zipEntryPrefix = "archetype-resources/";
    private List<String> binarySuffixes = Arrays.asList(".png", ".ico", ".gif", ".jpg", ".jpeg", ".bmp");
    protected String webInfResources = "src/main/webapp/WEB-INF/resources";
    protected Pattern sourcePathRegexPattern = Pattern.compile("(src/(main|test)/(java)/)(.*)");

    public ArchetypeHelper(File archetypeFile, File outputDir, String groupId, String artifactId, String version, String name, String description) {
        this.archetypeFile = archetypeFile;
        this.outputDir = outputDir;
        this.groupId = groupId;
        this.artifactId = artifactId;
        this.version = version;
        this.name = name;
        this.description = description;
    }

    private void info(String s) {
        System.out.println(s);
    }

    private void debug(String s) {
        if (this.verbose.booleanValue()) {
            System.out.println(s);
        }
    }

    public void setPackageName(String packageName) {
        this.packageName = packageName;
    }

    public void setOverrideProperties(Map<String, String> overrideProperties) {
        this.overrideProperties = overrideProperties;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int execute() throws IOException {
        Map<String, String> replaceProperties;
        String packageDir;
        block22: {
            this.outputDir.mkdirs();
            if (this.packageName == null || this.packageName.length() == 0) {
                this.packageName = this.groupId + "." + this.artifactId;
            }
            packageDir = this.packageName.replace('.', '/');
            this.debug("Creating archetype using Maven groupId: " + this.groupId + ", artifactId: " + this.artifactId + ", version: " + this.version + " in directory: " + this.outputDir);
            replaceProperties = this.parseProperties();
            replaceProperties.putAll(this.overrideProperties);
            this.debug("Using replace properties: " + replaceProperties);
            ZipFile zip = null;
            try {
                zip = new ZipFile(this.archetypeFile);
                Enumeration<? extends ZipEntry> entries = zip.entries();
                while (entries.hasMoreElements()) {
                    String dirName;
                    Object fullName;
                    ZipEntry entry = entries.nextElement();
                    if (entry.isDirectory() || (fullName = entry.getName()) == null || !((String)fullName).startsWith(this.zipEntryPrefix)) continue;
                    String string = this.replaceFileProperties(((String)fullName).substring(this.zipEntryPrefix.length()), replaceProperties);
                    this.debug("Processing resource: " + string);
                    int idx = string.lastIndexOf(47);
                    Matcher matcher = this.sourcePathRegexPattern.matcher(string);
                    if (this.packageName.length() > 0 && idx > 0 && matcher.matches()) {
                        String prefix = matcher.group(1);
                        dirName = prefix + packageDir + "/" + string.substring(prefix.length());
                    } else {
                        dirName = this.packageName.length() > 0 && string.startsWith(this.webInfResources) ? "src/main/webapp/WEB-INF/" + packageDir + "/resources" + string.substring(this.webInfResources.length()) : string;
                    }
                    File file = new File(this.outputDir, dirName);
                    file.getParentFile().mkdirs();
                    FileOutputStream out = null;
                    try {
                        out = new FileOutputStream(file);
                        boolean isBinary = false;
                        for (String suffix : this.binarySuffixes) {
                            if (!string.endsWith(suffix)) continue;
                            isBinary = true;
                            break;
                        }
                        if (isBinary) {
                            IOHelpers.copy((InputStream)zip.getInputStream(entry), (OutputStream)out);
                        } else {
                            ByteArrayOutputStream bos = new ByteArrayOutputStream();
                            IOHelpers.copy((InputStream)zip.getInputStream(entry), (OutputStream)bos);
                            String text = new String(bos.toByteArray(), "UTF-8");
                            out.write(this.transformContents(text, replaceProperties).getBytes());
                        }
                        if (out == null) continue;
                    }
                    catch (Throwable throwable) {
                        if (out != null) {
                            IOHelpers.close((Closeable[])new Closeable[]{out});
                        }
                        throw throwable;
                    }
                    IOHelpers.close((Closeable[])new Closeable[]{out});
                }
                if (zip == null) break block22;
            }
            catch (Exception e) {
                try {
                    throw new IOException(e.getMessage(), e);
                }
                catch (Throwable throwable) {
                    if (zip != null) {
                        IOHelpers.close((ZipFile[])new ZipFile[]{zip});
                    }
                    throw throwable;
                }
            }
            IOHelpers.close((ZipFile[])new ZipFile[]{zip});
        }
        if (!replaceProperties.isEmpty()) {
            File pom = new File(this.outputDir, "pom.xml");
            String text = IOHelpers.readFully((Reader)new FileReader(pom));
            for (Map.Entry entry : replaceProperties.entrySet()) {
                text = this.replaceVariable(text, (String)entry.getKey(), (String)entry.getValue());
            }
            if (Strings.isNotBlank((String)this.name)) {
                text = text.replaceFirst("<name>(.*)</name>", "<name>" + this.name + "</name>");
            }
            if (Strings.isNotBlank((String)this.description)) {
                text = text.replaceFirst("<description>(.*)</description>", "<description>" + this.description + "</description>");
            }
            IOHelpers.writeTo((File)pom, (String)text);
        }
        if (this.createDefaultDirectories.booleanValue()) {
            File srcDir = new File(this.outputDir, "src");
            File mainDir = new File(srcDir, "main");
            File testDir = new File(srcDir, "test");
            String string = "java";
            for (File dir : new File[]{mainDir, testDir}) {
                for (String name : new String[]{string + "/" + packageDir, "resources"}) {
                    new File(dir, name).mkdirs();
                }
            }
        }
        return 0;
    }

    public Map<String, String> parseProperties() throws IOException {
        HashMap<String, String> replaceProperties;
        block18: {
            replaceProperties = new HashMap<String, String>();
            try (ZipFile zip = null;){
                zip = new ZipFile(this.archetypeFile);
                ZipEntry entry = zip.getEntry("META-INF/maven/archetype-metadata.xml");
                if (entry == null) break block18;
                try (InputStream inputStream = zip.getInputStream(entry);){
                    this.parseReplaceProperties(inputStream, replaceProperties);
                }
            }
        }
        return replaceProperties;
    }

    protected void parseReplaceProperties(InputStream zip, Map<String, String> replaceProperties) throws IOException, ParserConfigurationException, SAXException, XPathExpressionException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        IOHelpers.copy((InputStream)zip, (OutputStream)bos);
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        dbf.setNamespaceAware(true);
        DocumentBuilder db = dbf.newDocumentBuilder();
        InputSource inputSource = new InputSource(new ByteArrayInputStream(bos.toByteArray()));
        Document document = db.parse(inputSource);
        XPath xpath = XPathFactory.newInstance().newXPath();
        SimpleNamespaceContext nsContext = new SimpleNamespaceContext();
        nsContext.registerMapping("ad", archetypeDescriptorUri);
        xpath.setNamespaceContext(nsContext);
        NodeList properties = (NodeList)xpath.evaluate(requiredPropertyXPath, document, XPathConstants.NODESET);
        for (int p = 0; p < properties.getLength(); ++p) {
            Element requiredProperty = (Element)properties.item(p);
            String key = requiredProperty.getAttribute("key");
            NodeList children = requiredProperty.getElementsByTagNameNS(archetypeDescriptorUri, "defaultValue");
            String value = "";
            if (children.getLength() == 1 && children.item(0).hasChildNodes()) {
                value = children.item(0).getTextContent();
            } else if ("name".equals(key) && value.isEmpty()) {
                value = "HelloWorld";
            }
            replaceProperties.put(key, value);
        }
    }

    protected String transformContents(String fileContents, Map<String, String> replaceProperties) {
        String answer = this.removeInvalidHeaderCommentsAndProcessVelocityMacros(fileContents);
        answer = this.replaceVariable(answer, "package", this.packageName);
        answer = this.replaceVariable(answer, "packageName", this.packageName);
        answer = this.replaceAllVariable(answer, "groupId", this.groupId);
        answer = this.replaceAllVariable(answer, "artifactId", this.artifactId);
        answer = this.replaceAllVariable(answer, "version", this.version);
        for (Map.Entry<String, String> e : replaceProperties.entrySet()) {
            answer = this.replaceVariable(answer, e.getKey(), e.getValue());
        }
        return answer;
    }

    protected String removeInvalidHeaderCommentsAndProcessVelocityMacros(String text) {
        String[] lines;
        String answer = "";
        for (String line : lines = text.split("\r?\n")) {
            String l = line.trim();
            if (l.startsWith("##") || l.startsWith("#set(")) continue;
            if (line.contains("${D}")) {
                line = line.replaceAll("\\$\\{D\\}", "\\$");
            }
            answer = answer.concat(line);
            answer = answer.concat(System.lineSeparator());
        }
        return answer;
    }

    protected String replaceFileProperties(String fileName, Map<String, String> replaceProperties) {
        String answer = fileName;
        for (Map.Entry<String, String> e : replaceProperties.entrySet()) {
            answer = answer.replace("__" + e.getKey() + "__", e.getValue());
        }
        return answer;
    }

    protected String replaceVariable(String text, String name, String value) {
        if (value.contains("}")) {
            this.debug("Ignoring unknown value '" + value + "'");
            return text;
        }
        return text.replaceAll(Pattern.quote("${" + name + "}"), value);
    }

    protected String replaceAllVariable(String text, String name, String value) {
        String answer = text.replaceAll(Pattern.quote("${" + name + "}"), value);
        answer = answer.replaceAll(Pattern.quote("$" + name), value);
        return answer;
    }
}

