/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.model.ComponentCondition;
import io.fabric8.kubernetes.api.model.ComponentConditionBuilder;
import io.fabric8.kubernetes.api.model.ComponentConditionFluentImpl;
import io.fabric8.kubernetes.api.model.ComponentStatus;
import io.fabric8.kubernetes.api.model.ComponentStatusFluent;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;
import io.fabric8.kubernetes.api.model.ObjectMetaFluentImpl;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ComponentStatusFluentImpl<T extends ComponentStatusFluent<T>>
extends BaseFluent<T>
implements ComponentStatusFluent<T> {
    String apiVersion;
    List<VisitableBuilder<ComponentCondition, ?>> conditions = new ArrayList();
    String kind;
    VisitableBuilder<ObjectMeta, ?> metadata;
    Map<String, Object> additionalProperties = new HashMap<String, Object>();

    public ComponentStatusFluentImpl() {
    }

    public ComponentStatusFluentImpl(ComponentStatus instance) {
        this.withApiVersion(instance.getApiVersion());
        this.withConditions(instance.getConditions());
        this.withKind(instance.getKind());
        this.withMetadata(instance.getMetadata());
    }

    @Override
    public String getApiVersion() {
        return this.apiVersion;
    }

    @Override
    public T withApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
        return (T)this;
    }

    @Override
    public T addToConditions(ComponentCondition ... items) {
        for (ComponentCondition item : items) {
            ComponentConditionBuilder builder = new ComponentConditionBuilder(item);
            this._visitables.add(builder);
            this.conditions.add(builder);
        }
        return (T)this;
    }

    @Override
    public T removeFromConditions(ComponentCondition ... items) {
        for (ComponentCondition item : items) {
            ComponentConditionBuilder builder = new ComponentConditionBuilder(item);
            this._visitables.remove(builder);
            this.conditions.remove(builder);
        }
        return (T)this;
    }

    @Override
    public List<ComponentCondition> getConditions() {
        return this.build(this.conditions);
    }

    @Override
    public T withConditions(List<ComponentCondition> conditions) {
        this.conditions.clear();
        if (conditions != null) {
            for (ComponentCondition item : conditions) {
                this.addToConditions(item);
            }
        }
        return (T)this;
    }

    @Override
    public T withConditions(ComponentCondition ... conditions) {
        this.conditions.clear();
        if (conditions != null) {
            for (ComponentCondition item : conditions) {
                this.addToConditions(item);
            }
        }
        return (T)this;
    }

    @Override
    public ComponentStatusFluent.ConditionsNested<T> addNewCondition() {
        return new ConditionsNestedImpl();
    }

    @Override
    public ComponentStatusFluent.ConditionsNested<T> addNewConditionLike(ComponentCondition item) {
        return new ConditionsNestedImpl(item);
    }

    @Override
    public T addNewCondition(String error, String message, String status, String type) {
        return this.addToConditions(new ComponentCondition(error, message, status, type));
    }

    @Override
    public String getKind() {
        return this.kind;
    }

    @Override
    public T withKind(String kind) {
        this.kind = kind;
        return (T)this;
    }

    @Override
    public ObjectMeta getMetadata() {
        return this.metadata != null ? (ObjectMeta)this.metadata.build() : null;
    }

    @Override
    public T withMetadata(ObjectMeta metadata) {
        if (metadata != null) {
            this.metadata = new ObjectMetaBuilder(metadata);
            this._visitables.add(this.metadata);
        }
        return (T)this;
    }

    @Override
    public ComponentStatusFluent.MetadataNested<T> withNewMetadata() {
        return new MetadataNestedImpl();
    }

    @Override
    public ComponentStatusFluent.MetadataNested<T> withNewMetadataLike(ObjectMeta item) {
        return new MetadataNestedImpl(item);
    }

    @Override
    public ComponentStatusFluent.MetadataNested<T> editMetadata() {
        return this.withNewMetadataLike(this.getMetadata());
    }

    @Override
    public T addToAdditionalProperties(String key, Object value) {
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (T)this;
    }

    @Override
    public T addToAdditionalProperties(Map<String, Object> map) {
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (T)this;
    }

    @Override
    public T removeFromAdditionalProperties(String key) {
        if (key != null) {
            this.additionalProperties.remove(key);
        }
        return (T)this;
    }

    @Override
    public T removeFromAdditionalProperties(Map<String, Object> map) {
        if (map != null) {
            for (String key : map.keySet()) {
                this.additionalProperties.remove(key);
            }
        }
        return (T)this;
    }

    @Override
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @Override
    public T withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties.clear();
        if (additionalProperties != null) {
            this.additionalProperties.putAll(additionalProperties);
        }
        return (T)this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ComponentStatusFluentImpl that = (ComponentStatusFluentImpl)o;
        if (this.apiVersion != null ? !this.apiVersion.equals(that.apiVersion) : that.apiVersion != null) {
            return false;
        }
        if (this.conditions != null ? !this.conditions.equals(that.conditions) : that.conditions != null) {
            return false;
        }
        if (this.kind != null ? !this.kind.equals(that.kind) : that.kind != null) {
            return false;
        }
        if (this.metadata != null ? !this.metadata.equals(that.metadata) : that.metadata != null) {
            return false;
        }
        return !(this.additionalProperties != null ? !this.additionalProperties.equals(that.additionalProperties) : that.additionalProperties != null);
    }

    public class MetadataNestedImpl<N>
    extends ObjectMetaFluentImpl<ComponentStatusFluent.MetadataNested<N>>
    implements ComponentStatusFluent.MetadataNested<N> {
        private final ObjectMetaBuilder builder;

        MetadataNestedImpl(ObjectMeta item) {
            this.builder = new ObjectMetaBuilder(this, item);
        }

        MetadataNestedImpl() {
            this.builder = new ObjectMetaBuilder(this);
        }

        @Override
        public N and() {
            return (N)ComponentStatusFluentImpl.this.withMetadata(this.builder.build());
        }

        @Override
        public N endMetadata() {
            return this.and();
        }
    }

    public class ConditionsNestedImpl<N>
    extends ComponentConditionFluentImpl<ComponentStatusFluent.ConditionsNested<N>>
    implements ComponentStatusFluent.ConditionsNested<N> {
        private final ComponentConditionBuilder builder;

        ConditionsNestedImpl() {
            this.builder = new ComponentConditionBuilder(this);
        }

        ConditionsNestedImpl(ComponentCondition item) {
            this.builder = new ComponentConditionBuilder(this, item);
        }

        @Override
        public N endCondition() {
            return this.and();
        }

        @Override
        public N and() {
            return (N)ComponentStatusFluentImpl.this.addToConditions(this.builder.build());
        }
    }
}

