/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.model.FCVolumeSource;
import io.fabric8.kubernetes.api.model.FCVolumeSourceFluent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class FCVolumeSourceFluentImpl<T extends FCVolumeSourceFluent<T>>
extends BaseFluent<T>
implements FCVolumeSourceFluent<T> {
    String fsType;
    Integer lun;
    Boolean readOnly;
    List<String> targetWWNs = new ArrayList<String>();
    Map<String, Object> additionalProperties = new HashMap<String, Object>();

    public FCVolumeSourceFluentImpl() {
    }

    public FCVolumeSourceFluentImpl(FCVolumeSource instance) {
        this.withFsType(instance.getFsType());
        this.withLun(instance.getLun());
        this.withReadOnly(instance.getReadOnly());
        this.withTargetWWNs(instance.getTargetWWNs());
    }

    @Override
    public String getFsType() {
        return this.fsType;
    }

    @Override
    public T withFsType(String fsType) {
        this.fsType = fsType;
        return (T)this;
    }

    @Override
    public Integer getLun() {
        return this.lun;
    }

    @Override
    public T withLun(Integer lun) {
        this.lun = lun;
        return (T)this;
    }

    @Override
    public Boolean isReadOnly() {
        return this.readOnly;
    }

    @Override
    public T withReadOnly(Boolean readOnly) {
        this.readOnly = readOnly;
        return (T)this;
    }

    @Override
    public T addToTargetWWNs(String ... items) {
        for (String item : items) {
            this.targetWWNs.add(item);
        }
        return (T)this;
    }

    @Override
    public T removeFromTargetWWNs(String ... items) {
        for (String item : items) {
            this.targetWWNs.remove(item);
        }
        return (T)this;
    }

    @Override
    public List<String> getTargetWWNs() {
        return this.targetWWNs;
    }

    @Override
    public T withTargetWWNs(List<String> targetWWNs) {
        this.targetWWNs.clear();
        if (targetWWNs != null) {
            for (String item : targetWWNs) {
                this.addToTargetWWNs(item);
            }
        }
        return (T)this;
    }

    @Override
    public T withTargetWWNs(String ... targetWWNs) {
        this.targetWWNs.clear();
        if (targetWWNs != null) {
            for (String item : targetWWNs) {
                this.addToTargetWWNs(item);
            }
        }
        return (T)this;
    }

    @Override
    public T addToAdditionalProperties(String key, Object value) {
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (T)this;
    }

    @Override
    public T addToAdditionalProperties(Map<String, Object> map) {
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (T)this;
    }

    @Override
    public T removeFromAdditionalProperties(String key) {
        if (key != null) {
            this.additionalProperties.remove(key);
        }
        return (T)this;
    }

    @Override
    public T removeFromAdditionalProperties(Map<String, Object> map) {
        if (map != null) {
            for (String key : map.keySet()) {
                this.additionalProperties.remove(key);
            }
        }
        return (T)this;
    }

    @Override
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @Override
    public T withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties.clear();
        if (additionalProperties != null) {
            this.additionalProperties.putAll(additionalProperties);
        }
        return (T)this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FCVolumeSourceFluentImpl that = (FCVolumeSourceFluentImpl)o;
        if (this.fsType != null ? !this.fsType.equals(that.fsType) : that.fsType != null) {
            return false;
        }
        if (this.lun != null ? !this.lun.equals(that.lun) : that.lun != null) {
            return false;
        }
        if (this.readOnly != null ? !this.readOnly.equals(that.readOnly) : that.readOnly != null) {
            return false;
        }
        if (this.targetWWNs != null ? !this.targetWWNs.equals(that.targetWWNs) : that.targetWWNs != null) {
            return false;
        }
        return !(this.additionalProperties != null ? !this.additionalProperties.equals(that.additionalProperties) : that.additionalProperties != null);
    }
}

