/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.model.EditableIDRange;
import io.fabric8.kubernetes.api.model.IDRange;
import io.fabric8.kubernetes.api.model.IDRangeFluent;
import io.fabric8.kubernetes.api.model.IDRangeFluentImpl;
import java.util.Set;
import javax.validation.ConstraintViolation;
import javax.validation.Validation;
import javax.validation.ValidationException;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;

public class IDRangeBuilder
extends IDRangeFluentImpl<IDRangeBuilder>
implements VisitableBuilder<IDRange, IDRangeBuilder> {
    IDRangeFluent<?> fluent;

    public IDRangeBuilder() {
        this(new IDRange());
    }

    public IDRangeBuilder(IDRangeFluent<?> fluent) {
        this(fluent, new IDRange());
    }

    public IDRangeBuilder(IDRangeFluent<?> fluent, IDRange instance) {
        this.fluent = fluent;
        fluent.withMax(instance.getMax());
        fluent.withMin(instance.getMin());
    }

    public IDRangeBuilder(IDRange instance) {
        this.fluent = this;
        this.withMax(instance.getMax());
        this.withMin(instance.getMin());
    }

    @Override
    public EditableIDRange build() {
        EditableIDRange buildable = new EditableIDRange(this.fluent.getMax(), this.fluent.getMin());
        this.validate(buildable);
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        IDRangeBuilder that = (IDRangeBuilder)o;
        return !(this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this);
    }

    private <T> void validate(T item) {
        try {
            ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
            Validator validator = factory.getValidator();
            Set violations = validator.validate(item, new Class[0]);
            if (!violations.isEmpty()) {
                StringBuilder sb = new StringBuilder();
                sb.append("Constraint Violations:\n");
                for (ConstraintViolation violation : violations) {
                    sb.append("\t").append(violation.getRootBeanClass().getSimpleName()).append(" ").append(violation.getPropertyPath()).append(":").append(violation.getMessage()).append("\n");
                }
                throw new IllegalStateException(sb.toString());
            }
        }
        catch (ValidationException validationException) {
            // empty catch block
        }
    }
}

