/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.builder.Predicate;
import io.fabric8.kubernetes.api.model.ServicePort;
import io.fabric8.kubernetes.api.model.ServicePortBuilder;
import io.fabric8.kubernetes.api.model.ServicePortFluentImpl;
import io.fabric8.kubernetes.api.model.ServiceSpec;
import io.fabric8.kubernetes.api.model.ServiceSpecFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class ServiceSpecFluentImpl<A extends ServiceSpecFluent<A>>
extends BaseFluent<A>
implements ServiceSpecFluent<A> {
    private String clusterIP;
    private List<String> externalIPs = new ArrayList<String>();
    private String externalName;
    private String externalTrafficPolicy;
    private Integer healthCheckNodePort;
    private String loadBalancerIP;
    private List<String> loadBalancerSourceRanges = new ArrayList<String>();
    private List<ServicePortBuilder> ports = new ArrayList<ServicePortBuilder>();
    private Map<String, String> selector = new LinkedHashMap<String, String>();
    private String sessionAffinity;
    private String type;

    public ServiceSpecFluentImpl() {
    }

    public ServiceSpecFluentImpl(ServiceSpec instance) {
        this.withClusterIP(instance.getClusterIP());
        this.withExternalIPs(instance.getExternalIPs());
        this.withExternalName(instance.getExternalName());
        this.withExternalTrafficPolicy(instance.getExternalTrafficPolicy());
        this.withHealthCheckNodePort(instance.getHealthCheckNodePort());
        this.withLoadBalancerIP(instance.getLoadBalancerIP());
        this.withLoadBalancerSourceRanges(instance.getLoadBalancerSourceRanges());
        this.withPorts(instance.getPorts());
        this.withSelector(instance.getSelector());
        this.withSessionAffinity(instance.getSessionAffinity());
        this.withType(instance.getType());
    }

    @Override
    public String getClusterIP() {
        return this.clusterIP;
    }

    @Override
    public A withClusterIP(String clusterIP) {
        this.clusterIP = clusterIP;
        return (A)this;
    }

    @Override
    public Boolean hasClusterIP() {
        return this.clusterIP != null;
    }

    @Override
    public A addToExternalIPs(int index, String item) {
        this.externalIPs.add(index, item);
        return (A)this;
    }

    @Override
    public A setToExternalIPs(int index, String item) {
        this.externalIPs.set(index, item);
        return (A)this;
    }

    @Override
    public A addToExternalIPs(String ... items) {
        for (String item : items) {
            this.externalIPs.add(item);
        }
        return (A)this;
    }

    @Override
    public A addAllToExternalIPs(Collection<String> items) {
        for (String item : items) {
            this.externalIPs.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromExternalIPs(String ... items) {
        for (String item : items) {
            this.externalIPs.remove(item);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromExternalIPs(Collection<String> items) {
        for (String item : items) {
            this.externalIPs.remove(item);
        }
        return (A)this;
    }

    @Override
    public List<String> getExternalIPs() {
        return this.externalIPs;
    }

    @Override
    public String getExternalIP(int index) {
        return this.externalIPs.get(index);
    }

    @Override
    public String getFirstExternalIP() {
        return this.externalIPs.get(0);
    }

    @Override
    public String getLastExternalIP() {
        return this.externalIPs.get(this.externalIPs.size() - 1);
    }

    @Override
    public String getMatchingExternalIP(Predicate<String> predicate) {
        for (String item : this.externalIPs) {
            if (!predicate.apply(item).booleanValue()) continue;
            return item;
        }
        return null;
    }

    @Override
    public A withExternalIPs(List<String> externalIPs) {
        this.externalIPs.clear();
        if (externalIPs != null) {
            for (String item : externalIPs) {
                this.addToExternalIPs(item);
            }
        }
        return (A)this;
    }

    @Override
    public A withExternalIPs(String ... externalIPs) {
        this.externalIPs.clear();
        if (externalIPs != null) {
            for (String item : externalIPs) {
                this.addToExternalIPs(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasExternalIPs() {
        return this.externalIPs != null && !this.externalIPs.isEmpty();
    }

    @Override
    public String getExternalName() {
        return this.externalName;
    }

    @Override
    public A withExternalName(String externalName) {
        this.externalName = externalName;
        return (A)this;
    }

    @Override
    public Boolean hasExternalName() {
        return this.externalName != null;
    }

    @Override
    public String getExternalTrafficPolicy() {
        return this.externalTrafficPolicy;
    }

    @Override
    public A withExternalTrafficPolicy(String externalTrafficPolicy) {
        this.externalTrafficPolicy = externalTrafficPolicy;
        return (A)this;
    }

    @Override
    public Boolean hasExternalTrafficPolicy() {
        return this.externalTrafficPolicy != null;
    }

    @Override
    public Integer getHealthCheckNodePort() {
        return this.healthCheckNodePort;
    }

    @Override
    public A withHealthCheckNodePort(Integer healthCheckNodePort) {
        this.healthCheckNodePort = healthCheckNodePort;
        return (A)this;
    }

    @Override
    public Boolean hasHealthCheckNodePort() {
        return this.healthCheckNodePort != null;
    }

    @Override
    public String getLoadBalancerIP() {
        return this.loadBalancerIP;
    }

    @Override
    public A withLoadBalancerIP(String loadBalancerIP) {
        this.loadBalancerIP = loadBalancerIP;
        return (A)this;
    }

    @Override
    public Boolean hasLoadBalancerIP() {
        return this.loadBalancerIP != null;
    }

    @Override
    public A addToLoadBalancerSourceRanges(int index, String item) {
        this.loadBalancerSourceRanges.add(index, item);
        return (A)this;
    }

    @Override
    public A setToLoadBalancerSourceRanges(int index, String item) {
        this.loadBalancerSourceRanges.set(index, item);
        return (A)this;
    }

    @Override
    public A addToLoadBalancerSourceRanges(String ... items) {
        for (String item : items) {
            this.loadBalancerSourceRanges.add(item);
        }
        return (A)this;
    }

    @Override
    public A addAllToLoadBalancerSourceRanges(Collection<String> items) {
        for (String item : items) {
            this.loadBalancerSourceRanges.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromLoadBalancerSourceRanges(String ... items) {
        for (String item : items) {
            this.loadBalancerSourceRanges.remove(item);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromLoadBalancerSourceRanges(Collection<String> items) {
        for (String item : items) {
            this.loadBalancerSourceRanges.remove(item);
        }
        return (A)this;
    }

    @Override
    public List<String> getLoadBalancerSourceRanges() {
        return this.loadBalancerSourceRanges;
    }

    @Override
    public String getLoadBalancerSourceRange(int index) {
        return this.loadBalancerSourceRanges.get(index);
    }

    @Override
    public String getFirstLoadBalancerSourceRange() {
        return this.loadBalancerSourceRanges.get(0);
    }

    @Override
    public String getLastLoadBalancerSourceRange() {
        return this.loadBalancerSourceRanges.get(this.loadBalancerSourceRanges.size() - 1);
    }

    @Override
    public String getMatchingLoadBalancerSourceRange(Predicate<String> predicate) {
        for (String item : this.loadBalancerSourceRanges) {
            if (!predicate.apply(item).booleanValue()) continue;
            return item;
        }
        return null;
    }

    @Override
    public A withLoadBalancerSourceRanges(List<String> loadBalancerSourceRanges) {
        this.loadBalancerSourceRanges.clear();
        if (loadBalancerSourceRanges != null) {
            for (String item : loadBalancerSourceRanges) {
                this.addToLoadBalancerSourceRanges(item);
            }
        }
        return (A)this;
    }

    @Override
    public A withLoadBalancerSourceRanges(String ... loadBalancerSourceRanges) {
        this.loadBalancerSourceRanges.clear();
        if (loadBalancerSourceRanges != null) {
            for (String item : loadBalancerSourceRanges) {
                this.addToLoadBalancerSourceRanges(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasLoadBalancerSourceRanges() {
        return this.loadBalancerSourceRanges != null && !this.loadBalancerSourceRanges.isEmpty();
    }

    @Override
    public A addToPorts(int index, ServicePort item) {
        ServicePortBuilder builder = new ServicePortBuilder(item);
        this._visitables.add(index >= 0 ? index : this._visitables.size(), builder);
        this.ports.add(index >= 0 ? index : this.ports.size(), builder);
        return (A)this;
    }

    @Override
    public A setToPorts(int index, ServicePort item) {
        ServicePortBuilder builder = new ServicePortBuilder(item);
        if (index < 0 || index >= this._visitables.size()) {
            this._visitables.add(builder);
        } else {
            this._visitables.set(index, builder);
        }
        if (index < 0 || index >= this.ports.size()) {
            this.ports.add(builder);
        } else {
            this.ports.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToPorts(ServicePort ... items) {
        for (ServicePort item : items) {
            ServicePortBuilder builder = new ServicePortBuilder(item);
            this._visitables.add(builder);
            this.ports.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToPorts(Collection<ServicePort> items) {
        for (ServicePort item : items) {
            ServicePortBuilder builder = new ServicePortBuilder(item);
            this._visitables.add(builder);
            this.ports.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromPorts(ServicePort ... items) {
        for (ServicePort item : items) {
            ServicePortBuilder builder = new ServicePortBuilder(item);
            this._visitables.remove(builder);
            this.ports.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromPorts(Collection<ServicePort> items) {
        for (ServicePort item : items) {
            ServicePortBuilder builder = new ServicePortBuilder(item);
            this._visitables.remove(builder);
            this.ports.remove(builder);
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<ServicePort> getPorts() {
        return ServiceSpecFluentImpl.build(this.ports);
    }

    @Override
    public List<ServicePort> buildPorts() {
        return ServiceSpecFluentImpl.build(this.ports);
    }

    @Override
    public ServicePort buildPort(int index) {
        return this.ports.get(index).build();
    }

    @Override
    public ServicePort buildFirstPort() {
        return this.ports.get(0).build();
    }

    @Override
    public ServicePort buildLastPort() {
        return this.ports.get(this.ports.size() - 1).build();
    }

    @Override
    public ServicePort buildMatchingPort(Predicate<ServicePortBuilder> predicate) {
        for (ServicePortBuilder item : this.ports) {
            if (!predicate.apply(item).booleanValue()) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public A withPorts(List<ServicePort> ports) {
        this._visitables.removeAll(this.ports);
        this.ports.clear();
        if (ports != null) {
            for (ServicePort item : ports) {
                this.addToPorts(item);
            }
        }
        return (A)this;
    }

    @Override
    public A withPorts(ServicePort ... ports) {
        this.ports.clear();
        if (ports != null) {
            for (ServicePort item : ports) {
                this.addToPorts(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasPorts() {
        return this.ports != null && !this.ports.isEmpty();
    }

    @Override
    public ServiceSpecFluent.PortsNested<A> addNewPort() {
        return new PortsNestedImpl();
    }

    @Override
    public ServiceSpecFluent.PortsNested<A> addNewPortLike(ServicePort item) {
        return new PortsNestedImpl(-1, item);
    }

    @Override
    public ServiceSpecFluent.PortsNested<A> setNewPortLike(int index, ServicePort item) {
        return new PortsNestedImpl(index, item);
    }

    @Override
    public ServiceSpecFluent.PortsNested<A> editPort(int index) {
        if (this.ports.size() <= index) {
            throw new RuntimeException("Can't edit ports. Index exceeds size.");
        }
        return this.setNewPortLike(index, this.buildPort(index));
    }

    @Override
    public ServiceSpecFluent.PortsNested<A> editFirstPort() {
        if (this.ports.size() == 0) {
            throw new RuntimeException("Can't edit first ports. The list is empty.");
        }
        return this.setNewPortLike(0, this.buildPort(0));
    }

    @Override
    public ServiceSpecFluent.PortsNested<A> editLastPort() {
        int index = this.ports.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last ports. The list is empty.");
        }
        return this.setNewPortLike(index, this.buildPort(index));
    }

    @Override
    public ServiceSpecFluent.PortsNested<A> editMatchingPort(Predicate<ServicePortBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.ports.size(); ++i) {
            if (!predicate.apply(this.ports.get(i)).booleanValue()) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching ports. No match found.");
        }
        return this.setNewPortLike(index, this.buildPort(index));
    }

    @Override
    public A addToSelector(String key, String value) {
        if (key != null && value != null) {
            this.selector.put(key, value);
        }
        return (A)this;
    }

    @Override
    public A addToSelector(Map<String, String> map) {
        if (map != null) {
            this.selector.putAll(map);
        }
        return (A)this;
    }

    @Override
    public A removeFromSelector(String key) {
        if (key != null) {
            this.selector.remove(key);
        }
        return (A)this;
    }

    @Override
    public A removeFromSelector(Map<String, String> map) {
        if (map != null) {
            for (String key : map.keySet()) {
                this.selector.remove(key);
            }
        }
        return (A)this;
    }

    @Override
    public Map<String, String> getSelector() {
        return this.selector;
    }

    @Override
    public A withSelector(Map<String, String> selector) {
        this.selector.clear();
        if (selector != null) {
            this.selector.putAll(selector);
        }
        return (A)this;
    }

    @Override
    public Boolean hasSelector() {
        return this.selector != null;
    }

    @Override
    public String getSessionAffinity() {
        return this.sessionAffinity;
    }

    @Override
    public A withSessionAffinity(String sessionAffinity) {
        this.sessionAffinity = sessionAffinity;
        return (A)this;
    }

    @Override
    public Boolean hasSessionAffinity() {
        return this.sessionAffinity != null;
    }

    @Override
    public String getType() {
        return this.type;
    }

    @Override
    public A withType(String type) {
        this.type = type;
        return (A)this;
    }

    @Override
    public Boolean hasType() {
        return this.type != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ServiceSpecFluentImpl that = (ServiceSpecFluentImpl)o;
        if (this.clusterIP != null ? !this.clusterIP.equals(that.clusterIP) : that.clusterIP != null) {
            return false;
        }
        if (this.externalIPs != null ? !this.externalIPs.equals(that.externalIPs) : that.externalIPs != null) {
            return false;
        }
        if (this.externalName != null ? !this.externalName.equals(that.externalName) : that.externalName != null) {
            return false;
        }
        if (this.externalTrafficPolicy != null ? !this.externalTrafficPolicy.equals(that.externalTrafficPolicy) : that.externalTrafficPolicy != null) {
            return false;
        }
        if (this.healthCheckNodePort != null ? !this.healthCheckNodePort.equals(that.healthCheckNodePort) : that.healthCheckNodePort != null) {
            return false;
        }
        if (this.loadBalancerIP != null ? !this.loadBalancerIP.equals(that.loadBalancerIP) : that.loadBalancerIP != null) {
            return false;
        }
        if (this.loadBalancerSourceRanges != null ? !this.loadBalancerSourceRanges.equals(that.loadBalancerSourceRanges) : that.loadBalancerSourceRanges != null) {
            return false;
        }
        if (this.ports != null ? !this.ports.equals(that.ports) : that.ports != null) {
            return false;
        }
        if (this.selector != null ? !this.selector.equals(that.selector) : that.selector != null) {
            return false;
        }
        if (this.sessionAffinity != null ? !this.sessionAffinity.equals(that.sessionAffinity) : that.sessionAffinity != null) {
            return false;
        }
        return !(this.type != null ? !this.type.equals(that.type) : that.type != null);
    }

    public class PortsNestedImpl<N>
    extends ServicePortFluentImpl<ServiceSpecFluent.PortsNested<N>>
    implements ServiceSpecFluent.PortsNested<N>,
    Nested<N> {
        private final ServicePortBuilder builder;
        private final int index;

        PortsNestedImpl(int index, ServicePort item) {
            this.index = index;
            this.builder = new ServicePortBuilder(this, item);
        }

        PortsNestedImpl() {
            this.index = -1;
            this.builder = new ServicePortBuilder(this);
        }

        @Override
        public N and() {
            return (N)ServiceSpecFluentImpl.this.setToPorts(this.index, this.builder.build());
        }

        @Override
        public N endPort() {
            return this.and();
        }
    }
}

