/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.builder.Predicate;
import io.fabric8.kubernetes.api.model.EnvVar;
import io.fabric8.kubernetes.api.model.EnvVarBuilder;
import io.fabric8.kubernetes.api.model.EnvVarFluentImpl;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;
import io.fabric8.kubernetes.api.model.ObjectMetaFluentImpl;
import io.fabric8.kubernetes.api.model.ObjectReference;
import io.fabric8.kubernetes.api.model.ObjectReferenceBuilder;
import io.fabric8.kubernetes.api.model.ObjectReferenceFluentImpl;
import io.fabric8.openshift.api.model.BinaryBuildSource;
import io.fabric8.openshift.api.model.BinaryBuildSourceBuilder;
import io.fabric8.openshift.api.model.BinaryBuildSourceFluentImpl;
import io.fabric8.openshift.api.model.BuildRequest;
import io.fabric8.openshift.api.model.BuildRequestFluent;
import io.fabric8.openshift.api.model.BuildTriggerCause;
import io.fabric8.openshift.api.model.BuildTriggerCauseBuilder;
import io.fabric8.openshift.api.model.BuildTriggerCauseFluentImpl;
import io.fabric8.openshift.api.model.DockerStrategyOptions;
import io.fabric8.openshift.api.model.DockerStrategyOptionsBuilder;
import io.fabric8.openshift.api.model.DockerStrategyOptionsFluentImpl;
import io.fabric8.openshift.api.model.SourceRevision;
import io.fabric8.openshift.api.model.SourceRevisionBuilder;
import io.fabric8.openshift.api.model.SourceRevisionFluentImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class BuildRequestFluentImpl<A extends BuildRequestFluent<A>>
extends BaseFluent<A>
implements BuildRequestFluent<A> {
    private String apiVersion;
    private BinaryBuildSourceBuilder binary;
    private DockerStrategyOptionsBuilder dockerStrategyOptions;
    private List<EnvVarBuilder> env = new ArrayList<EnvVarBuilder>();
    private ObjectReferenceBuilder from;
    private String kind;
    private Long lastVersion;
    private ObjectMetaBuilder metadata;
    private SourceRevisionBuilder revision;
    private List<BuildTriggerCauseBuilder> triggeredBy = new ArrayList<BuildTriggerCauseBuilder>();
    private ObjectReferenceBuilder triggeredByImage;

    public BuildRequestFluentImpl() {
    }

    public BuildRequestFluentImpl(BuildRequest instance) {
        this.withApiVersion(instance.getApiVersion());
        this.withBinary(instance.getBinary());
        this.withDockerStrategyOptions(instance.getDockerStrategyOptions());
        this.withEnv(instance.getEnv());
        this.withFrom(instance.getFrom());
        this.withKind(instance.getKind());
        this.withLastVersion(instance.getLastVersion());
        this.withMetadata(instance.getMetadata());
        this.withRevision(instance.getRevision());
        this.withTriggeredBy(instance.getTriggeredBy());
        this.withTriggeredByImage(instance.getTriggeredByImage());
    }

    @Override
    public String getApiVersion() {
        return this.apiVersion;
    }

    @Override
    public A withApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
        return (A)this;
    }

    @Override
    public Boolean hasApiVersion() {
        return this.apiVersion != null;
    }

    @Override
    @Deprecated
    public BinaryBuildSource getBinary() {
        return this.binary != null ? this.binary.build() : null;
    }

    @Override
    public BinaryBuildSource buildBinary() {
        return this.binary != null ? this.binary.build() : null;
    }

    @Override
    public A withBinary(BinaryBuildSource binary) {
        this._visitables.remove(this.binary);
        if (binary != null) {
            this.binary = new BinaryBuildSourceBuilder(binary);
            this._visitables.add(this.binary);
        }
        return (A)this;
    }

    @Override
    public Boolean hasBinary() {
        return this.binary != null;
    }

    @Override
    public BuildRequestFluent.BinaryNested<A> withNewBinary() {
        return new BinaryNestedImpl();
    }

    @Override
    public BuildRequestFluent.BinaryNested<A> withNewBinaryLike(BinaryBuildSource item) {
        return new BinaryNestedImpl(item);
    }

    @Override
    public BuildRequestFluent.BinaryNested<A> editBinary() {
        return this.withNewBinaryLike(this.getBinary());
    }

    @Override
    public BuildRequestFluent.BinaryNested<A> editOrNewBinary() {
        return this.withNewBinaryLike(this.getBinary() != null ? this.getBinary() : new BinaryBuildSourceBuilder().build());
    }

    @Override
    public BuildRequestFluent.BinaryNested<A> editOrNewBinaryLike(BinaryBuildSource item) {
        return this.withNewBinaryLike(this.getBinary() != null ? this.getBinary() : item);
    }

    @Override
    public A withNewBinary(String asFile) {
        return this.withBinary(new BinaryBuildSource(asFile));
    }

    @Override
    @Deprecated
    public DockerStrategyOptions getDockerStrategyOptions() {
        return this.dockerStrategyOptions != null ? this.dockerStrategyOptions.build() : null;
    }

    @Override
    public DockerStrategyOptions buildDockerStrategyOptions() {
        return this.dockerStrategyOptions != null ? this.dockerStrategyOptions.build() : null;
    }

    @Override
    public A withDockerStrategyOptions(DockerStrategyOptions dockerStrategyOptions) {
        this._visitables.remove(this.dockerStrategyOptions);
        if (dockerStrategyOptions != null) {
            this.dockerStrategyOptions = new DockerStrategyOptionsBuilder(dockerStrategyOptions);
            this._visitables.add(this.dockerStrategyOptions);
        }
        return (A)this;
    }

    @Override
    public Boolean hasDockerStrategyOptions() {
        return this.dockerStrategyOptions != null;
    }

    @Override
    public BuildRequestFluent.DockerStrategyOptionsNested<A> withNewDockerStrategyOptions() {
        return new DockerStrategyOptionsNestedImpl();
    }

    @Override
    public BuildRequestFluent.DockerStrategyOptionsNested<A> withNewDockerStrategyOptionsLike(DockerStrategyOptions item) {
        return new DockerStrategyOptionsNestedImpl(item);
    }

    @Override
    public BuildRequestFluent.DockerStrategyOptionsNested<A> editDockerStrategyOptions() {
        return this.withNewDockerStrategyOptionsLike(this.getDockerStrategyOptions());
    }

    @Override
    public BuildRequestFluent.DockerStrategyOptionsNested<A> editOrNewDockerStrategyOptions() {
        return this.withNewDockerStrategyOptionsLike(this.getDockerStrategyOptions() != null ? this.getDockerStrategyOptions() : new DockerStrategyOptionsBuilder().build());
    }

    @Override
    public BuildRequestFluent.DockerStrategyOptionsNested<A> editOrNewDockerStrategyOptionsLike(DockerStrategyOptions item) {
        return this.withNewDockerStrategyOptionsLike(this.getDockerStrategyOptions() != null ? this.getDockerStrategyOptions() : item);
    }

    @Override
    public A addToEnv(int index, EnvVar item) {
        EnvVarBuilder builder = new EnvVarBuilder(item);
        this._visitables.add(index >= 0 ? index : this._visitables.size(), builder);
        this.env.add(index >= 0 ? index : this.env.size(), builder);
        return (A)this;
    }

    @Override
    public A setToEnv(int index, EnvVar item) {
        EnvVarBuilder builder = new EnvVarBuilder(item);
        if (index < 0 || index >= this._visitables.size()) {
            this._visitables.add(builder);
        } else {
            this._visitables.set(index, builder);
        }
        if (index < 0 || index >= this.env.size()) {
            this.env.add(builder);
        } else {
            this.env.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToEnv(EnvVar ... items) {
        for (EnvVar item : items) {
            EnvVarBuilder builder = new EnvVarBuilder(item);
            this._visitables.add(builder);
            this.env.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToEnv(Collection<EnvVar> items) {
        for (EnvVar item : items) {
            EnvVarBuilder builder = new EnvVarBuilder(item);
            this._visitables.add(builder);
            this.env.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromEnv(EnvVar ... items) {
        for (EnvVar item : items) {
            EnvVarBuilder builder = new EnvVarBuilder(item);
            this._visitables.remove(builder);
            this.env.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromEnv(Collection<EnvVar> items) {
        for (EnvVar item : items) {
            EnvVarBuilder builder = new EnvVarBuilder(item);
            this._visitables.remove(builder);
            this.env.remove(builder);
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<EnvVar> getEnv() {
        return BuildRequestFluentImpl.build(this.env);
    }

    @Override
    public List<EnvVar> buildEnv() {
        return BuildRequestFluentImpl.build(this.env);
    }

    @Override
    public EnvVar buildEnv(int index) {
        return this.env.get(index).build();
    }

    @Override
    public EnvVar buildFirstEnv() {
        return this.env.get(0).build();
    }

    @Override
    public EnvVar buildLastEnv() {
        return this.env.get(this.env.size() - 1).build();
    }

    @Override
    public EnvVar buildMatchingEnv(Predicate<EnvVarBuilder> predicate) {
        for (EnvVarBuilder item : this.env) {
            if (!predicate.apply(item).booleanValue()) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public A withEnv(List<EnvVar> env) {
        this._visitables.removeAll(this.env);
        this.env.clear();
        if (env != null) {
            for (EnvVar item : env) {
                this.addToEnv(item);
            }
        }
        return (A)this;
    }

    @Override
    public A withEnv(EnvVar ... env) {
        this.env.clear();
        if (env != null) {
            for (EnvVar item : env) {
                this.addToEnv(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasEnv() {
        return this.env != null && !this.env.isEmpty();
    }

    @Override
    public BuildRequestFluent.EnvNested<A> addNewEnv() {
        return new EnvNestedImpl();
    }

    @Override
    public BuildRequestFluent.EnvNested<A> addNewEnvLike(EnvVar item) {
        return new EnvNestedImpl(-1, item);
    }

    @Override
    public BuildRequestFluent.EnvNested<A> setNewEnvLike(int index, EnvVar item) {
        return new EnvNestedImpl(index, item);
    }

    @Override
    public BuildRequestFluent.EnvNested<A> editEnv(int index) {
        if (this.env.size() <= index) {
            throw new RuntimeException("Can't edit env. Index exceeds size.");
        }
        return this.setNewEnvLike(index, this.buildEnv(index));
    }

    @Override
    public BuildRequestFluent.EnvNested<A> editFirstEnv() {
        if (this.env.size() == 0) {
            throw new RuntimeException("Can't edit first env. The list is empty.");
        }
        return this.setNewEnvLike(0, this.buildEnv(0));
    }

    @Override
    public BuildRequestFluent.EnvNested<A> editLastEnv() {
        int index = this.env.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last env. The list is empty.");
        }
        return this.setNewEnvLike(index, this.buildEnv(index));
    }

    @Override
    public BuildRequestFluent.EnvNested<A> editMatchingEnv(Predicate<EnvVarBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.env.size(); ++i) {
            if (!predicate.apply(this.env.get(i)).booleanValue()) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching env. No match found.");
        }
        return this.setNewEnvLike(index, this.buildEnv(index));
    }

    @Override
    @Deprecated
    public ObjectReference getFrom() {
        return this.from != null ? this.from.build() : null;
    }

    @Override
    public ObjectReference buildFrom() {
        return this.from != null ? this.from.build() : null;
    }

    @Override
    public A withFrom(ObjectReference from) {
        this._visitables.remove(this.from);
        if (from != null) {
            this.from = new ObjectReferenceBuilder(from);
            this._visitables.add(this.from);
        }
        return (A)this;
    }

    @Override
    public Boolean hasFrom() {
        return this.from != null;
    }

    @Override
    public BuildRequestFluent.FromNested<A> withNewFrom() {
        return new FromNestedImpl();
    }

    @Override
    public BuildRequestFluent.FromNested<A> withNewFromLike(ObjectReference item) {
        return new FromNestedImpl(item);
    }

    @Override
    public BuildRequestFluent.FromNested<A> editFrom() {
        return this.withNewFromLike(this.getFrom());
    }

    @Override
    public BuildRequestFluent.FromNested<A> editOrNewFrom() {
        return this.withNewFromLike(this.getFrom() != null ? this.getFrom() : new ObjectReferenceBuilder().build());
    }

    @Override
    public BuildRequestFluent.FromNested<A> editOrNewFromLike(ObjectReference item) {
        return this.withNewFromLike(this.getFrom() != null ? this.getFrom() : item);
    }

    @Override
    public String getKind() {
        return this.kind;
    }

    @Override
    public A withKind(String kind) {
        this.kind = kind;
        return (A)this;
    }

    @Override
    public Boolean hasKind() {
        return this.kind != null;
    }

    @Override
    public Long getLastVersion() {
        return this.lastVersion;
    }

    @Override
    public A withLastVersion(Long lastVersion) {
        this.lastVersion = lastVersion;
        return (A)this;
    }

    @Override
    public Boolean hasLastVersion() {
        return this.lastVersion != null;
    }

    @Override
    @Deprecated
    public ObjectMeta getMetadata() {
        return this.metadata != null ? this.metadata.build() : null;
    }

    @Override
    public ObjectMeta buildMetadata() {
        return this.metadata != null ? this.metadata.build() : null;
    }

    @Override
    public A withMetadata(ObjectMeta metadata) {
        this._visitables.remove(this.metadata);
        if (metadata != null) {
            this.metadata = new ObjectMetaBuilder(metadata);
            this._visitables.add(this.metadata);
        }
        return (A)this;
    }

    @Override
    public Boolean hasMetadata() {
        return this.metadata != null;
    }

    @Override
    public BuildRequestFluent.MetadataNested<A> withNewMetadata() {
        return new MetadataNestedImpl();
    }

    @Override
    public BuildRequestFluent.MetadataNested<A> withNewMetadataLike(ObjectMeta item) {
        return new MetadataNestedImpl(item);
    }

    @Override
    public BuildRequestFluent.MetadataNested<A> editMetadata() {
        return this.withNewMetadataLike(this.getMetadata());
    }

    @Override
    public BuildRequestFluent.MetadataNested<A> editOrNewMetadata() {
        return this.withNewMetadataLike(this.getMetadata() != null ? this.getMetadata() : new ObjectMetaBuilder().build());
    }

    @Override
    public BuildRequestFluent.MetadataNested<A> editOrNewMetadataLike(ObjectMeta item) {
        return this.withNewMetadataLike(this.getMetadata() != null ? this.getMetadata() : item);
    }

    @Override
    @Deprecated
    public SourceRevision getRevision() {
        return this.revision != null ? this.revision.build() : null;
    }

    @Override
    public SourceRevision buildRevision() {
        return this.revision != null ? this.revision.build() : null;
    }

    @Override
    public A withRevision(SourceRevision revision) {
        this._visitables.remove(this.revision);
        if (revision != null) {
            this.revision = new SourceRevisionBuilder(revision);
            this._visitables.add(this.revision);
        }
        return (A)this;
    }

    @Override
    public Boolean hasRevision() {
        return this.revision != null;
    }

    @Override
    public BuildRequestFluent.RevisionNested<A> withNewRevision() {
        return new RevisionNestedImpl();
    }

    @Override
    public BuildRequestFluent.RevisionNested<A> withNewRevisionLike(SourceRevision item) {
        return new RevisionNestedImpl(item);
    }

    @Override
    public BuildRequestFluent.RevisionNested<A> editRevision() {
        return this.withNewRevisionLike(this.getRevision());
    }

    @Override
    public BuildRequestFluent.RevisionNested<A> editOrNewRevision() {
        return this.withNewRevisionLike(this.getRevision() != null ? this.getRevision() : new SourceRevisionBuilder().build());
    }

    @Override
    public BuildRequestFluent.RevisionNested<A> editOrNewRevisionLike(SourceRevision item) {
        return this.withNewRevisionLike(this.getRevision() != null ? this.getRevision() : item);
    }

    @Override
    public A addToTriggeredBy(int index, BuildTriggerCause item) {
        BuildTriggerCauseBuilder builder = new BuildTriggerCauseBuilder(item);
        this._visitables.add(index >= 0 ? index : this._visitables.size(), builder);
        this.triggeredBy.add(index >= 0 ? index : this.triggeredBy.size(), builder);
        return (A)this;
    }

    @Override
    public A setToTriggeredBy(int index, BuildTriggerCause item) {
        BuildTriggerCauseBuilder builder = new BuildTriggerCauseBuilder(item);
        if (index < 0 || index >= this._visitables.size()) {
            this._visitables.add(builder);
        } else {
            this._visitables.set(index, builder);
        }
        if (index < 0 || index >= this.triggeredBy.size()) {
            this.triggeredBy.add(builder);
        } else {
            this.triggeredBy.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToTriggeredBy(BuildTriggerCause ... items) {
        for (BuildTriggerCause item : items) {
            BuildTriggerCauseBuilder builder = new BuildTriggerCauseBuilder(item);
            this._visitables.add(builder);
            this.triggeredBy.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToTriggeredBy(Collection<BuildTriggerCause> items) {
        for (BuildTriggerCause item : items) {
            BuildTriggerCauseBuilder builder = new BuildTriggerCauseBuilder(item);
            this._visitables.add(builder);
            this.triggeredBy.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromTriggeredBy(BuildTriggerCause ... items) {
        for (BuildTriggerCause item : items) {
            BuildTriggerCauseBuilder builder = new BuildTriggerCauseBuilder(item);
            this._visitables.remove(builder);
            this.triggeredBy.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromTriggeredBy(Collection<BuildTriggerCause> items) {
        for (BuildTriggerCause item : items) {
            BuildTriggerCauseBuilder builder = new BuildTriggerCauseBuilder(item);
            this._visitables.remove(builder);
            this.triggeredBy.remove(builder);
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<BuildTriggerCause> getTriggeredBy() {
        return BuildRequestFluentImpl.build(this.triggeredBy);
    }

    @Override
    public List<BuildTriggerCause> buildTriggeredBy() {
        return BuildRequestFluentImpl.build(this.triggeredBy);
    }

    @Override
    public BuildTriggerCause buildTriggeredBy(int index) {
        return this.triggeredBy.get(index).build();
    }

    @Override
    public BuildTriggerCause buildFirstTriggeredBy() {
        return this.triggeredBy.get(0).build();
    }

    @Override
    public BuildTriggerCause buildLastTriggeredBy() {
        return this.triggeredBy.get(this.triggeredBy.size() - 1).build();
    }

    @Override
    public BuildTriggerCause buildMatchingTriggeredBy(Predicate<BuildTriggerCauseBuilder> predicate) {
        for (BuildTriggerCauseBuilder item : this.triggeredBy) {
            if (!predicate.apply(item).booleanValue()) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public A withTriggeredBy(List<BuildTriggerCause> triggeredBy) {
        this._visitables.removeAll(this.triggeredBy);
        this.triggeredBy.clear();
        if (triggeredBy != null) {
            for (BuildTriggerCause item : triggeredBy) {
                this.addToTriggeredBy(item);
            }
        }
        return (A)this;
    }

    @Override
    public A withTriggeredBy(BuildTriggerCause ... triggeredBy) {
        this.triggeredBy.clear();
        if (triggeredBy != null) {
            for (BuildTriggerCause item : triggeredBy) {
                this.addToTriggeredBy(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasTriggeredBy() {
        return this.triggeredBy != null && !this.triggeredBy.isEmpty();
    }

    @Override
    public BuildRequestFluent.TriggeredByNested<A> addNewTriggeredBy() {
        return new TriggeredByNestedImpl();
    }

    @Override
    public BuildRequestFluent.TriggeredByNested<A> addNewTriggeredByLike(BuildTriggerCause item) {
        return new TriggeredByNestedImpl(-1, item);
    }

    @Override
    public BuildRequestFluent.TriggeredByNested<A> setNewTriggeredByLike(int index, BuildTriggerCause item) {
        return new TriggeredByNestedImpl(index, item);
    }

    @Override
    public BuildRequestFluent.TriggeredByNested<A> editTriggeredBy(int index) {
        if (this.triggeredBy.size() <= index) {
            throw new RuntimeException("Can't edit triggeredBy. Index exceeds size.");
        }
        return this.setNewTriggeredByLike(index, this.buildTriggeredBy(index));
    }

    @Override
    public BuildRequestFluent.TriggeredByNested<A> editFirstTriggeredBy() {
        if (this.triggeredBy.size() == 0) {
            throw new RuntimeException("Can't edit first triggeredBy. The list is empty.");
        }
        return this.setNewTriggeredByLike(0, this.buildTriggeredBy(0));
    }

    @Override
    public BuildRequestFluent.TriggeredByNested<A> editLastTriggeredBy() {
        int index = this.triggeredBy.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last triggeredBy. The list is empty.");
        }
        return this.setNewTriggeredByLike(index, this.buildTriggeredBy(index));
    }

    @Override
    public BuildRequestFluent.TriggeredByNested<A> editMatchingTriggeredBy(Predicate<BuildTriggerCauseBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.triggeredBy.size(); ++i) {
            if (!predicate.apply(this.triggeredBy.get(i)).booleanValue()) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching triggeredBy. No match found.");
        }
        return this.setNewTriggeredByLike(index, this.buildTriggeredBy(index));
    }

    @Override
    @Deprecated
    public ObjectReference getTriggeredByImage() {
        return this.triggeredByImage != null ? this.triggeredByImage.build() : null;
    }

    @Override
    public ObjectReference buildTriggeredByImage() {
        return this.triggeredByImage != null ? this.triggeredByImage.build() : null;
    }

    @Override
    public A withTriggeredByImage(ObjectReference triggeredByImage) {
        this._visitables.remove(this.triggeredByImage);
        if (triggeredByImage != null) {
            this.triggeredByImage = new ObjectReferenceBuilder(triggeredByImage);
            this._visitables.add(this.triggeredByImage);
        }
        return (A)this;
    }

    @Override
    public Boolean hasTriggeredByImage() {
        return this.triggeredByImage != null;
    }

    @Override
    public BuildRequestFluent.TriggeredByImageNested<A> withNewTriggeredByImage() {
        return new TriggeredByImageNestedImpl();
    }

    @Override
    public BuildRequestFluent.TriggeredByImageNested<A> withNewTriggeredByImageLike(ObjectReference item) {
        return new TriggeredByImageNestedImpl(item);
    }

    @Override
    public BuildRequestFluent.TriggeredByImageNested<A> editTriggeredByImage() {
        return this.withNewTriggeredByImageLike(this.getTriggeredByImage());
    }

    @Override
    public BuildRequestFluent.TriggeredByImageNested<A> editOrNewTriggeredByImage() {
        return this.withNewTriggeredByImageLike(this.getTriggeredByImage() != null ? this.getTriggeredByImage() : new ObjectReferenceBuilder().build());
    }

    @Override
    public BuildRequestFluent.TriggeredByImageNested<A> editOrNewTriggeredByImageLike(ObjectReference item) {
        return this.withNewTriggeredByImageLike(this.getTriggeredByImage() != null ? this.getTriggeredByImage() : item);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        BuildRequestFluentImpl that = (BuildRequestFluentImpl)o;
        if (this.apiVersion != null ? !this.apiVersion.equals(that.apiVersion) : that.apiVersion != null) {
            return false;
        }
        if (this.binary != null ? !this.binary.equals(that.binary) : that.binary != null) {
            return false;
        }
        if (this.dockerStrategyOptions != null ? !this.dockerStrategyOptions.equals(that.dockerStrategyOptions) : that.dockerStrategyOptions != null) {
            return false;
        }
        if (this.env != null ? !this.env.equals(that.env) : that.env != null) {
            return false;
        }
        if (this.from != null ? !this.from.equals(that.from) : that.from != null) {
            return false;
        }
        if (this.kind != null ? !this.kind.equals(that.kind) : that.kind != null) {
            return false;
        }
        if (this.lastVersion != null ? !this.lastVersion.equals(that.lastVersion) : that.lastVersion != null) {
            return false;
        }
        if (this.metadata != null ? !this.metadata.equals(that.metadata) : that.metadata != null) {
            return false;
        }
        if (this.revision != null ? !this.revision.equals(that.revision) : that.revision != null) {
            return false;
        }
        if (this.triggeredBy != null ? !this.triggeredBy.equals(that.triggeredBy) : that.triggeredBy != null) {
            return false;
        }
        return !(this.triggeredByImage != null ? !this.triggeredByImage.equals(that.triggeredByImage) : that.triggeredByImage != null);
    }

    public class TriggeredByImageNestedImpl<N>
    extends ObjectReferenceFluentImpl<BuildRequestFluent.TriggeredByImageNested<N>>
    implements BuildRequestFluent.TriggeredByImageNested<N>,
    Nested<N> {
        private final ObjectReferenceBuilder builder;

        TriggeredByImageNestedImpl(ObjectReference item) {
            this.builder = new ObjectReferenceBuilder(this, item);
        }

        TriggeredByImageNestedImpl() {
            this.builder = new ObjectReferenceBuilder(this);
        }

        @Override
        public N and() {
            return (N)BuildRequestFluentImpl.this.withTriggeredByImage(this.builder.build());
        }

        @Override
        public N endTriggeredByImage() {
            return this.and();
        }
    }

    public class TriggeredByNestedImpl<N>
    extends BuildTriggerCauseFluentImpl<BuildRequestFluent.TriggeredByNested<N>>
    implements BuildRequestFluent.TriggeredByNested<N>,
    Nested<N> {
        private final BuildTriggerCauseBuilder builder;
        private final int index;

        TriggeredByNestedImpl(int index, BuildTriggerCause item) {
            this.index = index;
            this.builder = new BuildTriggerCauseBuilder(this, item);
        }

        TriggeredByNestedImpl() {
            this.index = -1;
            this.builder = new BuildTriggerCauseBuilder(this);
        }

        @Override
        public N and() {
            return (N)BuildRequestFluentImpl.this.setToTriggeredBy(this.index, this.builder.build());
        }

        @Override
        public N endTriggeredBy() {
            return this.and();
        }
    }

    public class RevisionNestedImpl<N>
    extends SourceRevisionFluentImpl<BuildRequestFluent.RevisionNested<N>>
    implements BuildRequestFluent.RevisionNested<N>,
    Nested<N> {
        private final SourceRevisionBuilder builder;

        RevisionNestedImpl(SourceRevision item) {
            this.builder = new SourceRevisionBuilder(this, item);
        }

        RevisionNestedImpl() {
            this.builder = new SourceRevisionBuilder(this);
        }

        @Override
        public N and() {
            return (N)BuildRequestFluentImpl.this.withRevision(this.builder.build());
        }

        @Override
        public N endRevision() {
            return this.and();
        }
    }

    public class MetadataNestedImpl<N>
    extends ObjectMetaFluentImpl<BuildRequestFluent.MetadataNested<N>>
    implements BuildRequestFluent.MetadataNested<N>,
    Nested<N> {
        private final ObjectMetaBuilder builder;

        MetadataNestedImpl(ObjectMeta item) {
            this.builder = new ObjectMetaBuilder(this, item);
        }

        MetadataNestedImpl() {
            this.builder = new ObjectMetaBuilder(this);
        }

        @Override
        public N and() {
            return (N)BuildRequestFluentImpl.this.withMetadata(this.builder.build());
        }

        @Override
        public N endMetadata() {
            return this.and();
        }
    }

    public class FromNestedImpl<N>
    extends ObjectReferenceFluentImpl<BuildRequestFluent.FromNested<N>>
    implements BuildRequestFluent.FromNested<N>,
    Nested<N> {
        private final ObjectReferenceBuilder builder;

        FromNestedImpl(ObjectReference item) {
            this.builder = new ObjectReferenceBuilder(this, item);
        }

        FromNestedImpl() {
            this.builder = new ObjectReferenceBuilder(this);
        }

        @Override
        public N and() {
            return (N)BuildRequestFluentImpl.this.withFrom(this.builder.build());
        }

        @Override
        public N endFrom() {
            return this.and();
        }
    }

    public class EnvNestedImpl<N>
    extends EnvVarFluentImpl<BuildRequestFluent.EnvNested<N>>
    implements BuildRequestFluent.EnvNested<N>,
    Nested<N> {
        private final EnvVarBuilder builder;
        private final int index;

        EnvNestedImpl(int index, EnvVar item) {
            this.index = index;
            this.builder = new EnvVarBuilder(this, item);
        }

        EnvNestedImpl() {
            this.index = -1;
            this.builder = new EnvVarBuilder(this);
        }

        @Override
        public N and() {
            return (N)BuildRequestFluentImpl.this.setToEnv(this.index, this.builder.build());
        }

        @Override
        public N endEnv() {
            return this.and();
        }
    }

    public class DockerStrategyOptionsNestedImpl<N>
    extends DockerStrategyOptionsFluentImpl<BuildRequestFluent.DockerStrategyOptionsNested<N>>
    implements BuildRequestFluent.DockerStrategyOptionsNested<N>,
    Nested<N> {
        private final DockerStrategyOptionsBuilder builder;

        DockerStrategyOptionsNestedImpl(DockerStrategyOptions item) {
            this.builder = new DockerStrategyOptionsBuilder(this, item);
        }

        DockerStrategyOptionsNestedImpl() {
            this.builder = new DockerStrategyOptionsBuilder(this);
        }

        @Override
        public N and() {
            return (N)BuildRequestFluentImpl.this.withDockerStrategyOptions(this.builder.build());
        }

        @Override
        public N endDockerStrategyOptions() {
            return this.and();
        }
    }

    public class BinaryNestedImpl<N>
    extends BinaryBuildSourceFluentImpl<BuildRequestFluent.BinaryNested<N>>
    implements BuildRequestFluent.BinaryNested<N>,
    Nested<N> {
        private final BinaryBuildSourceBuilder builder;

        BinaryNestedImpl(BinaryBuildSource item) {
            this.builder = new BinaryBuildSourceBuilder(this, item);
        }

        BinaryNestedImpl() {
            this.builder = new BinaryBuildSourceBuilder(this);
        }

        @Override
        public N and() {
            return (N)BuildRequestFluentImpl.this.withBinary(this.builder.build());
        }

        @Override
        public N endBinary() {
            return this.and();
        }
    }
}

