/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.ValidationUtils;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.openshift.api.model.ImageSource;
import io.fabric8.openshift.api.model.ImageSourceFluent;
import io.fabric8.openshift.api.model.ImageSourceFluentImpl;

public class ImageSourceBuilder
extends ImageSourceFluentImpl<ImageSourceBuilder>
implements VisitableBuilder<ImageSource, ImageSourceBuilder> {
    ImageSourceFluent<?> fluent;
    Boolean validationEnabled;

    public ImageSourceBuilder() {
        this(true);
    }

    public ImageSourceBuilder(Boolean validationEnabled) {
        this(new ImageSource(), validationEnabled);
    }

    public ImageSourceBuilder(ImageSourceFluent<?> fluent) {
        this(fluent, (Boolean)true);
    }

    public ImageSourceBuilder(ImageSourceFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new ImageSource(), validationEnabled);
    }

    public ImageSourceBuilder(ImageSourceFluent<?> fluent, ImageSource instance) {
        this(fluent, instance, true);
    }

    public ImageSourceBuilder(ImageSourceFluent<?> fluent, ImageSource instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withFrom(instance.getFrom());
        fluent.withPaths(instance.getPaths());
        fluent.withPullSecret(instance.getPullSecret());
        this.validationEnabled = validationEnabled;
    }

    public ImageSourceBuilder(ImageSource instance) {
        this(instance, (Boolean)true);
    }

    public ImageSourceBuilder(ImageSource instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withFrom(instance.getFrom());
        this.withPaths(instance.getPaths());
        this.withPullSecret(instance.getPullSecret());
        this.validationEnabled = validationEnabled;
    }

    @Override
    public ImageSource build() {
        ImageSource buildable = new ImageSource(this.fluent.getFrom(), this.fluent.getPaths(), this.fluent.getPullSecret());
        ValidationUtils.validate(buildable);
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ImageSourceBuilder that = (ImageSourceBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }
}

