/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.api.jmx;

import io.fabric8.api.Container;
import io.fabric8.api.FabricException;
import io.fabric8.api.FabricService;
import io.fabric8.api.HasId;
import io.fabric8.api.Ids;
import io.fabric8.api.Profile;
import io.fabric8.api.Version;
import java.beans.PropertyDescriptor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.beanutils.PropertyUtils;

public class BeanUtils {
    private BeanUtils() {
    }

    public static List<String> getFields(Class clazz) {
        ArrayList<String> answer = new ArrayList<String>();
        try {
            for (PropertyDescriptor desc : PropertyUtils.getPropertyDescriptors((Class)clazz)) {
                if (desc.getReadMethod() == null) continue;
                answer.add(desc.getName());
            }
        }
        catch (Exception e) {
            throw new FabricException("Failed to get property descriptors for " + clazz.toString(), (Throwable)e);
        }
        if (clazz.getSimpleName().equals("Container")) {
            answer.add("parentId");
            answer.add("versionId");
            answer.add("profileIds");
            answer.add("childrenIds");
            answer.remove("fabricService");
        } else if (clazz.getSimpleName().equals("Profile")) {
            answer.add("id");
            answer.add("parentIds");
            answer.add("childIds");
            answer.add("containerCount");
            answer.add("containers");
            answer.add("fileConfigurations");
        } else if (clazz.getSimpleName().equals("Version")) {
            answer.add("id");
            answer.add("defaultVersion");
        }
        return answer;
    }

    public static void setValue(Object instance, String property, Object value) {
        try {
            org.apache.commons.beanutils.BeanUtils.setProperty((Object)instance, (String)property, (Object)value);
        }
        catch (Throwable t) {
            throw new RuntimeException("Failed to set property " + property + " on " + instance.getClass().getName(), t);
        }
    }

    public static Object getValue(Object instance, String property) {
        try {
            return org.apache.commons.beanutils.BeanUtils.getProperty((Object)instance, (String)property);
        }
        catch (Throwable t) {
            throw new RuntimeException("Failed to set property " + property + " on " + instance.getClass().getName(), t);
        }
    }

    public static Map<String, Object> convertProfileToMap(FabricService service, Profile profile, List<String> fields) {
        HashMap<String, Object> answer = new HashMap<String, Object>();
        for (String field : fields) {
            if (field.equalsIgnoreCase("configurations") || field.equalsIgnoreCase("fileConfigurations")) {
                answer.put(field, BeanUtils.fetchConfigurations(profile));
                continue;
            }
            if (field.equalsIgnoreCase("childIds")) {
                answer.put(field, BeanUtils.fetchChildIds(service, profile));
                continue;
            }
            if (field.equalsIgnoreCase("containers") || field.equalsIgnoreCase("associatedContainers")) {
                answer.put(field, BeanUtils.fetchContainers(service, profile));
                continue;
            }
            if (field.equalsIgnoreCase("containerCount")) {
                answer.put(field, BeanUtils.fetchContainerCount(profile));
                continue;
            }
            if (field.equalsIgnoreCase("parentIds") || field.equalsIgnoreCase("parents")) {
                answer.put(field, Ids.getIds((HasId[])profile.getParents()));
                continue;
            }
            if (field.equalsIgnoreCase("class") || field.equalsIgnoreCase("string") || field.equalsIgnoreCase("abstractProfile")) continue;
            BeanUtils.addProperty(profile, field, answer);
        }
        return answer;
    }

    private static void addProperty(Object obj, String field, Map<String, Object> map) {
        try {
            Object prop = PropertyUtils.getProperty((Object)obj, (String)field);
            map.put(field, prop);
        }
        catch (Exception e) {
            throw new FabricException("Failed to initialize DTO", (Throwable)e);
        }
    }

    public static Map<String, Object> convertContainerToMap(FabricService service, Container container, List<String> fields) {
        HashMap<String, Object> answer = new HashMap<String, Object>();
        for (String field : fields) {
            if (field.equalsIgnoreCase("profiles") || field.equalsIgnoreCase("profileIds")) {
                answer.put(field, Ids.getIds((HasId[])container.getProfiles()));
                continue;
            }
            if (field.equalsIgnoreCase("childrenIds") || field.equalsIgnoreCase("children")) {
                answer.put(field, Ids.getIds((HasId[])container.getChildren()));
                continue;
            }
            if (field.equalsIgnoreCase("parent") || field.equalsIgnoreCase("parentId")) {
                answer.put(field, Ids.getId((HasId)container.getParent()));
                continue;
            }
            if (field.equalsIgnoreCase("version") || field.equalsIgnoreCase("versionId")) {
                answer.put(field, Ids.getId((HasId)container.getVersion()));
                continue;
            }
            if (field.equalsIgnoreCase("overlayProfile")) {
                answer.put(field, BeanUtils.convertProfileToMap(service, container.getOverlayProfile(), BeanUtils.getFields(Profile.class)));
                continue;
            }
            BeanUtils.addProperty(container, field, answer);
        }
        return answer;
    }

    public static Map<String, Object> convertVersionToMap(FabricService service, Version version, List<String> fields) {
        HashMap<String, Object> answer = new HashMap<String, Object>();
        for (String field : fields) {
            if (field.equalsIgnoreCase("profiles") || field.equalsIgnoreCase("profileIds")) {
                answer.put(field, Ids.getIds((HasId[])version.getProfiles()));
                continue;
            }
            if (field.equalsIgnoreCase("defaultVersion")) {
                answer.put(field, service.getDefaultVersion().equals(version));
                continue;
            }
            if (field.equalsIgnoreCase("class") || field.equalsIgnoreCase("string")) continue;
            BeanUtils.addProperty(version, field, answer);
        }
        return answer;
    }

    public static List<String> fetchChildIds(FabricService service, Profile self) {
        ArrayList<String> ids = new ArrayList<String>();
        block0: for (Profile p : service.getVersion(self.getVersion()).getProfiles()) {
            for (Profile parent : p.getParents()) {
                if (!parent.getId().equals(self.getId())) continue;
                ids.add(p.getId());
                continue block0;
            }
        }
        return ids;
    }

    public static List<String> fetchContainers(FabricService service, Profile self) {
        ArrayList<String> answer = new ArrayList<String>();
        for (Container c : self.getAssociatedContainers()) {
            answer.add(c.getId());
        }
        return answer;
    }

    public static int fetchContainerCount(Profile self) {
        return self.getAssociatedContainers().length;
    }

    public static List<String> fetchConfigurations(Profile self) {
        ArrayList<String> answer = new ArrayList<String>();
        answer.addAll(self.getFileConfigurations().keySet());
        return answer;
    }

    public static List<String> collapseToList(List<Map<String, Object>> objs, String field) {
        ArrayList<String> answer = new ArrayList<String>();
        for (Map<String, Object> o : objs) {
            answer.add(o.get(field).toString());
        }
        return answer;
    }
}

