/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.internal;

import io.fabric8.api.Container;
import io.fabric8.api.CreateContainerMetadata;
import io.fabric8.api.DataStore;
import io.fabric8.api.FabricException;
import io.fabric8.api.FabricService;
import io.fabric8.api.ModuleStatus;
import io.fabric8.api.Profile;
import io.fabric8.api.Version;
import io.fabric8.api.data.BundleInfo;
import io.fabric8.api.data.ServiceInfo;
import io.fabric8.common.util.Strings;
import io.fabric8.internal.BundleInfoComparator;
import io.fabric8.internal.JmxBundleInfo;
import io.fabric8.internal.JmxServiceInfo;
import io.fabric8.internal.ProfileImpl;
import io.fabric8.internal.ProfileOverlayImpl;
import io.fabric8.internal.ServiceInfoComparator;
import io.fabric8.service.ContainerTemplate;
import io.fabric8.zookeeper.ZkDefs;
import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.TabularData;
import org.osgi.jmx.framework.BundleStateMBean;
import org.osgi.jmx.framework.ServiceStateMBean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ContainerImpl
implements Container {
    private static final String ENSEMBLE_PROFILE_PATTERN = "fabric-ensemble-[0-9]*-[0-9]*";
    protected transient Logger logger = LoggerFactory.getLogger(this.getClass());
    private final Container parent;
    private final String id;
    private final FabricService fabricService;
    private CreateContainerMetadata<?> metadata;

    public ContainerImpl(Container parent, String id, FabricService fabricService) {
        this.parent = parent;
        this.id = id;
        this.fabricService = fabricService;
    }

    public FabricService getFabricService() {
        return this.fabricService;
    }

    public Container getParent() {
        return this.parent;
    }

    public String getId() {
        return this.id;
    }

    public boolean isAlive() {
        return this.fabricService.getDataStore().isContainerAlive(this.id);
    }

    public void setAlive(boolean flag) {
        this.fabricService.getDataStore().setContainerAlive(this.id, flag);
    }

    public boolean isRoot() {
        return this.parent == null;
    }

    public boolean isEnsembleServer() {
        try {
            List containers = this.fabricService.getDataStore().getEnsembleContainers();
            for (String container : containers) {
                if (!this.id.equals(container)) continue;
                return true;
            }
            return false;
        }
        catch (Exception e) {
            throw FabricException.launderThrowable((Throwable)e);
        }
    }

    public boolean isProvisioningComplete() {
        String result = this.getProvisionResult();
        return "success".equals(result) || "error".equals(result);
    }

    public boolean isProvisioningPending() {
        return this.isManaged() && !this.isProvisioningComplete();
    }

    public String getProvisionStatus() {
        String provisioned = this.getProvisionResult();
        String provisionException = this.getProvisionException();
        String result = "not provisioned";
        if (provisioned != null && (result = provisioned).equals("error") && provisionException != null) {
            result = result + " - " + provisionException.split(System.getProperty("line.separator"))[0];
        }
        return result;
    }

    public String getSshUrl() {
        return this.getMandatorySubstitutedAttribute(DataStore.ContainerAttribute.SshUrl);
    }

    public String getJmxUrl() {
        return this.getMandatorySubstitutedAttribute(DataStore.ContainerAttribute.JmxUrl);
    }

    public String getJolokiaUrl() {
        return this.getMandatorySubstitutedAttribute(DataStore.ContainerAttribute.JolokiaUrl);
    }

    public void setJolokiaUrl(String location) {
        this.setAttribute(DataStore.ContainerAttribute.JolokiaUrl, location);
    }

    public String getHttpUrl() {
        return this.getMandatorySubstitutedAttribute(DataStore.ContainerAttribute.HttpUrl);
    }

    public boolean isManaged() {
        Map agentConfig = this.getOverlayProfile().getConfiguration("io.fabric8.agent");
        if (agentConfig != null) {
            String disabled = (String)this.getOverlayProfile().getConfiguration("io.fabric8.agent").get("disabled");
            return !"true".equals(disabled);
        }
        return true;
    }

    public Version getVersion() {
        String versionId = this.fabricService.getDataStore().getContainerVersion(this.id);
        if (versionId == null) {
            return null;
        }
        return this.fabricService.getVersion(versionId);
    }

    public void setVersion(Version version) {
        if (version.compareTo((Object)this.getVersion()) != 0) {
            if (this.requiresUpgrade(version) && this.isManaged()) {
                String status = version.compareTo((Object)this.getVersion()) > 0 ? "upgrading" : "downgrading";
                this.fabricService.getDataStore().setContainerAttribute(this.id, DataStore.ContainerAttribute.ProvisionStatus, status);
            }
            this.fabricService.getDataStore().setContainerVersion(this.id, version.getId());
        }
    }

    public Long getProcessId() {
        String pid = this.fabricService.getDataStore().getContainerAttribute(this.id, DataStore.ContainerAttribute.ProcessId, null, false, false);
        if (pid == null) {
            return null;
        }
        return Long.valueOf(pid);
    }

    public Profile[] getProfiles() {
        Version version = this.getVersion();
        List profileIds = this.fabricService.getDataStore().getContainerProfiles(this.id);
        ArrayList<Profile> profiles = new ArrayList<Profile>();
        for (String profileId : profileIds) {
            profiles.add(version.getProfile(profileId));
        }
        if (profiles.isEmpty()) {
            profiles.add(version.getProfile("default"));
        }
        return profiles.toArray(new Profile[profiles.size()]);
    }

    public void setProfiles(Profile[] profiles) {
        String versionId = this.fabricService.getDataStore().getContainerVersion(this.id);
        List currentProfileIds = this.fabricService.getDataStore().getContainerProfiles(this.id);
        ArrayList<String> profileIds = new ArrayList<String>();
        if (profiles != null) {
            for (Profile profile : profiles) {
                if (!versionId.equals(profile.getVersion())) {
                    throw new IllegalArgumentException("Version mismatch setting profile " + profile.getId() + " with version " + profile.getVersion() + " expected version " + versionId);
                }
                if (profile.isAbstract()) {
                    throw new IllegalArgumentException("The profile " + profile.getId() + " is abstract and can not " + "be associated to containers");
                }
                if (profile.getId().matches(ENSEMBLE_PROFILE_PATTERN) && !currentProfileIds.contains(profile.getId())) {
                    throw new IllegalArgumentException("The profile " + profile.getId() + " is not assignable.");
                }
                profileIds.add(profile.getId());
            }
        }
        if (profileIds.isEmpty()) {
            profileIds.add("default");
        }
        this.fabricService.getDataStore().setContainerProfiles(this.id, profileIds);
    }

    public void addProfiles(Profile ... profiles) {
        List<Profile> addedProfiles = Arrays.asList(profiles);
        LinkedList<Profile> updatedProfileList = new LinkedList<Profile>();
        for (Profile p : this.getProfiles()) {
            updatedProfileList.add(p);
        }
        for (Profile addedProfile : addedProfiles) {
            if (!addedProfile.exists()) {
                throw new IllegalArgumentException("Profile " + addedProfile.getId() + " doesn't exist.");
            }
            if (updatedProfileList.contains(addedProfile)) continue;
            updatedProfileList.add(addedProfile);
        }
        this.setProfiles(updatedProfileList.toArray(new Profile[updatedProfileList.size()]));
    }

    public void removeProfiles(Profile ... profiles) {
        List<Profile> removedProfiles = Arrays.asList(profiles);
        LinkedList<ProfileImpl> updatedProfileList = new LinkedList<ProfileImpl>();
        for (String p : this.fabricService.getDataStore().getContainerProfiles(this.id)) {
            ProfileImpl profile = this.getVersion().hasProfile(p) ? this.getVersion().getProfile(p) : new ProfileImpl(p, this.getVersion().getId(), this.fabricService);
            if (removedProfiles.contains(profile)) continue;
            updatedProfileList.add(profile);
        }
        this.setProfiles(updatedProfileList.toArray(new Profile[updatedProfileList.size()]));
    }

    public Profile getOverlayProfile() {
        return new ProfileOverlayImpl(new ContainerProfile(), this.fabricService.getEnvironment(), true, this.fabricService);
    }

    public String getLocation() {
        return this.getOptionalAttribute(DataStore.ContainerAttribute.Location, "");
    }

    public void setLocation(String location) {
        this.setAttribute(DataStore.ContainerAttribute.Location, location);
    }

    public String getGeoLocation() {
        return this.getOptionalAttribute(DataStore.ContainerAttribute.GeoLocation, "");
    }

    public void setGeoLocation(String location) {
        this.setAttribute(DataStore.ContainerAttribute.GeoLocation, location);
    }

    public String getResolver() {
        return this.getMandatorySubstitutedAttribute(DataStore.ContainerAttribute.Resolver);
    }

    public void setResolver(String resolver) {
        List<String> validResolverList = Arrays.asList(ZkDefs.VALID_RESOLVERS);
        if (!validResolverList.contains(resolver)) {
            throw new FabricException("Resolver " + resolver + " is not valid.");
        }
        this.setAttribute(DataStore.ContainerAttribute.Resolver, resolver);
    }

    public String getIp() {
        return this.getMandatorySubstitutedAttribute(DataStore.ContainerAttribute.Ip);
    }

    public String getLocalIp() {
        return this.getNullableSubstitutedAttribute(DataStore.ContainerAttribute.LocalIp);
    }

    public void setLocalIp(String localIp) {
        this.setAttribute(DataStore.ContainerAttribute.LocalIp, localIp);
    }

    public String getLocalHostname() {
        return this.getNullableSubstitutedAttribute(DataStore.ContainerAttribute.LocalHostName);
    }

    public void setLocalHostname(String localHostname) {
        this.setAttribute(DataStore.ContainerAttribute.LocalHostName, localHostname);
    }

    public String getPublicIp() {
        return this.getNullableSubstitutedAttribute(DataStore.ContainerAttribute.PublicIp);
    }

    public void setPublicIp(String publicIp) {
        this.setAttribute(DataStore.ContainerAttribute.PublicIp, publicIp);
    }

    public String getPublicHostname() {
        return this.getNullableSubstitutedAttribute(DataStore.ContainerAttribute.PublicHostName);
    }

    public void setPublicHostname(String publicHostname) {
        this.setAttribute(DataStore.ContainerAttribute.PublicHostName, publicHostname);
    }

    public String getManualIp() {
        return this.getNullableSubstitutedAttribute(DataStore.ContainerAttribute.ManualIp);
    }

    public void setManualIp(String manualIp) {
        this.setAttribute(DataStore.ContainerAttribute.ManualIp, manualIp);
    }

    public int getMinimumPort() {
        int minimumPort = 0;
        try {
            minimumPort = Integer.parseInt(this.getOptionalAttribute(DataStore.ContainerAttribute.PortMin, "0"));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return minimumPort;
    }

    public void setMinimumPort(int port) {
        this.setAttribute(DataStore.ContainerAttribute.PortMin, String.valueOf(port));
    }

    public int getMaximumPort() {
        int maximumPort = 0;
        try {
            maximumPort = Integer.parseInt(this.getOptionalAttribute(DataStore.ContainerAttribute.PortMax, "0"));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return maximumPort;
    }

    public void setMaximumPort(int port) {
        this.setAttribute(DataStore.ContainerAttribute.PortMax, String.valueOf(port));
    }

    public BundleInfo[] getBundles(ContainerTemplate containerTemplate) {
        try {
            return containerTemplate.execute(new ContainerTemplate.BundleStateCallback<BundleInfo[]>(){

                @Override
                public BundleInfo[] doWithBundleState(BundleStateMBean bundleState) throws Exception {
                    TabularData bundles = bundleState.listBundles();
                    BundleInfo[] info = new BundleInfo[bundles.size()];
                    int i = 0;
                    for (Object data : bundles.values().toArray()) {
                        info[i++] = new JmxBundleInfo((CompositeData)data);
                    }
                    Arrays.sort(info, new BundleInfoComparator());
                    return info;
                }
            });
        }
        catch (Exception e) {
            this.logger.warn("Error while retrieving bundles. This exception will be ignored.", (Throwable)e);
            return new BundleInfo[0];
        }
    }

    public ServiceInfo[] getServices(ContainerTemplate containerTemplate) {
        try {
            return containerTemplate.execute(new ContainerTemplate.ServiceStateCallback<ServiceInfo[]>(){

                @Override
                public ServiceInfo[] doWithServiceState(ServiceStateMBean serviceState) throws Exception {
                    TabularData services = serviceState.listServices();
                    ServiceInfo[] info = new ServiceInfo[services.size()];
                    int i = 0;
                    for (Object data : services.values().toArray()) {
                        CompositeData svc = (CompositeData)data;
                        info[i++] = new JmxServiceInfo(svc, serviceState.getProperties(((Long)svc.get("Identifier")).longValue()));
                    }
                    Arrays.sort(info, new ServiceInfoComparator());
                    return info;
                }
            });
        }
        catch (Exception e) {
            this.logger.warn("Error while retrieving services. This exception will be ignored.", (Throwable)e);
            return new ServiceInfo[0];
        }
    }

    public List<String> getJmxDomains() {
        String str = this.getOptionalAttribute(DataStore.ContainerAttribute.Domains, null);
        return str != null ? Arrays.asList(str.split("\n")) : Collections.emptyList();
    }

    public void setJmxDomains(List<String> jmxDomains) {
        String text = Strings.join(jmxDomains, (String)"\n");
        this.setAttribute(DataStore.ContainerAttribute.Domains, text);
    }

    public void start() {
        this.start(false);
    }

    public void start(boolean force) {
        this.fabricService.startContainer((Container)this, force);
    }

    public void stop() {
        this.stop(false);
    }

    public void stop(boolean force) {
        this.fabricService.stopContainer((Container)this, force);
    }

    public void destroy() {
        this.destroy(false);
    }

    public void destroy(boolean force) {
        if (this.hasAliveChildren()) {
            throw new IllegalStateException("Container " + this.id + " has one or more child containers alive and cannot be destroyed.");
        }
        this.fabricService.destroyContainer((Container)this, force);
    }

    public Container[] getChildren() {
        ArrayList<Container> children = new ArrayList<Container>();
        for (Container container : this.fabricService.getContainers()) {
            if (container.getParent() == null || !this.getId().equals(container.getParent().getId())) continue;
            children.add(container);
        }
        return children.toArray(new Container[children.size()]);
    }

    public String getType() {
        String answer = null;
        if (this.metadata != null) {
            answer = this.metadata.getContainerType();
        }
        if (Strings.isNullOrBlank(answer)) {
            answer = "karaf";
        }
        return answer;
    }

    public void setType(String type) {
        if (this.metadata != null) {
            this.metadata.setContainerType(type);
        }
    }

    public String getProvisionResult() {
        String status = this.getOptionalAttribute(DataStore.ContainerAttribute.ProvisionStatus, "");
        if (status.equals("success")) {
            return this.getExtenderStatus();
        }
        return status;
    }

    public void setProvisionResult(String result) {
        this.setAttribute(DataStore.ContainerAttribute.ProvisionStatus, result);
    }

    public String getProvisionException() {
        return this.getOptionalAttribute(DataStore.ContainerAttribute.ProvisionException, null);
    }

    public void setProvisionException(String exception) {
        this.setAttribute(DataStore.ContainerAttribute.ProvisionException, exception);
    }

    public List<String> getProvisionList() {
        String str = this.getOptionalAttribute(DataStore.ContainerAttribute.ProvisionList, null);
        return str != null ? Arrays.asList(str.split("\n")) : null;
    }

    public void setProvisionList(List<String> bundles) {
        StringBuilder str = new StringBuilder();
        for (String b : bundles) {
            if (str.length() > 0) {
                str.append("\n");
            }
            str.append(b);
        }
        this.setAttribute(DataStore.ContainerAttribute.ProvisionList, str.toString());
    }

    public Properties getProvisionChecksums() {
        String str = this.getOptionalAttribute(DataStore.ContainerAttribute.ProvisionChecksums, null);
        Properties answer = new Properties();
        if (str != null) {
            try {
                answer.load(new StringReader(str));
            }
            catch (IOException e) {
                this.logger.warn("Failed to convert provisionChecksums: " + str + " to a Properties object. " + e, (Throwable)e);
            }
        }
        return answer;
    }

    public void setProvisionChecksums(Properties checksums) {
        StringWriter writer = new StringWriter();
        try {
            checksums.store(writer, "provision checksums");
            this.setAttribute(DataStore.ContainerAttribute.ProvisionChecksums, writer.toString());
        }
        catch (IOException e) {
            this.logger.warn("Failed to convert provisionChecksums: " + checksums + " to a string. " + e, (Throwable)e);
        }
    }

    public CreateContainerMetadata<?> getMetadata() {
        if (this.metadata == null) {
            this.metadata = this.getMetadata(this.getClass().getClassLoader());
            if (this.metadata == null) {
                for (Class type : this.fabricService.getSupportedCreateContainerMetadataTypes()) {
                    this.metadata = this.getMetadata(type.getClassLoader());
                    if (this.metadata == null) continue;
                    break;
                }
            }
        }
        return this.metadata;
    }

    private CreateContainerMetadata<?> getMetadata(ClassLoader classLoader) {
        try {
            return this.fabricService.getDataStore().getContainerMetadata(this.id, classLoader);
        }
        catch (Exception e) {
            this.logger.debug("Error while retrieving metadata. This exception will be ignored.", (Throwable)e);
            return null;
        }
    }

    private boolean requiresUpgrade(Version version) {
        boolean requiresUpgrade = false;
        if (version.compareTo((Object)this.getVersion()) == 0) {
            return false;
        }
        for (Profile oldProfile : this.getProfiles()) {
            Profile newProfile = version.getProfile(oldProfile.getId());
            if (newProfile == null || oldProfile.agentConfigurationEquals(newProfile)) continue;
            requiresUpgrade = true;
        }
        return requiresUpgrade;
    }

    public boolean hasAliveChildren() {
        for (Container child : this.getChildren()) {
            if (!child.isAlive()) continue;
            return true;
        }
        return false;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ContainerImpl container = (ContainerImpl)o;
        return !(this.id != null ? !this.id.equals(container.id) : container.id != null);
    }

    public int hashCode() {
        return this.id != null ? this.id.hashCode() : 0;
    }

    public String toString() {
        return "Container[id=" + this.id + (this.parent != null ? ", parent=" + this.parent.getId() : "") + ']';
    }

    public boolean isAliveAndOK() {
        String status = this.getProvisionStatus();
        return this.isAlive() && !Strings.isNotBlank((String)this.getProvisionException()) && (status == null || status.length() == 0 || status.toLowerCase().startsWith("success"));
    }

    public Map<String, String> getProvisionStatusMap() {
        HashMap<String, String> answer = new HashMap<String, String>();
        answer.put(DataStore.ContainerAttribute.ProvisionStatus.name(), this.getProvisionStatus());
        answer.put(DataStore.ContainerAttribute.BlueprintStatus.name(), this.getBlueprintStatus().name());
        answer.put(DataStore.ContainerAttribute.SpringStatus.name(), this.getSpringStatus().name());
        return answer;
    }

    private String getOptionalAttribute(DataStore.ContainerAttribute attribute, String def) {
        return this.fabricService.getDataStore().getContainerAttribute(this.id, attribute, def, false, false);
    }

    private String getNullableSubstitutedAttribute(DataStore.ContainerAttribute attribute) {
        return this.fabricService.getDataStore().getContainerAttribute(this.id, attribute, null, false, true);
    }

    private String getMandatorySubstitutedAttribute(DataStore.ContainerAttribute attribute) {
        return this.fabricService.getDataStore().getContainerAttribute(this.id, attribute, null, true, true);
    }

    private void setAttribute(DataStore.ContainerAttribute attribute, String value) {
        this.fabricService.getDataStore().setContainerAttribute(this.id, attribute, value);
    }

    private String getExtenderStatus() {
        ModuleStatus blueprintStatus = this.getBlueprintStatus();
        ModuleStatus springStatus = this.getSpringStatus();
        if (blueprintStatus != ModuleStatus.STARTED) {
            return blueprintStatus.name().toLowerCase();
        }
        if (springStatus != ModuleStatus.STARTED) {
            return springStatus.name().toLowerCase();
        }
        return "success";
    }

    private ModuleStatus getSpringStatus() {
        return Enum.valueOf(ModuleStatus.class, this.getOptionalAttribute(DataStore.ContainerAttribute.SpringStatus, ModuleStatus.STARTED.name()));
    }

    private ModuleStatus getBlueprintStatus() {
        return Enum.valueOf(ModuleStatus.class, this.getOptionalAttribute(DataStore.ContainerAttribute.BlueprintStatus, ModuleStatus.STARTED.name()));
    }

    private class ContainerProfile
    extends ProfileImpl {
        private ContainerProfile() {
            super("#container-" + ContainerImpl.this.id, ContainerImpl.this.getVersion().getId(), ContainerImpl.this.fabricService);
        }

        @Override
        public Profile[] getParents() {
            Version v = ContainerImpl.this.fabricService.getVersion(this.getVersion());
            ArrayList<Profile> parents = new ArrayList<Profile>();
            for (String p : ContainerImpl.this.fabricService.getDataStore().getContainerProfiles(ContainerImpl.this.id)) {
                try {
                    parents.add(v.getProfile(p));
                }
                catch (Exception e) {}
            }
            return parents.toArray(new Profile[parents.size()]);
        }

        @Override
        public Map<String, String> getAttributes() {
            return Collections.emptyMap();
        }

        @Override
        public void setAttribute(String key, String value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Container[] getAssociatedContainers() {
            return new Container[]{ContainerImpl.this};
        }

        @Override
        public Map<String, byte[]> getFileConfigurations() {
            return Collections.emptyMap();
        }

        @Override
        public void setFileConfigurations(Map<String, byte[]> configurations) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Map<String, Map<String, String>> getConfigurations() {
            return Collections.emptyMap();
        }

        @Override
        public void setConfigurations(Map<String, Map<String, String>> configurations) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void delete() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getProfileHash() {
            StringBuilder sb = new StringBuilder();
            Version v = ContainerImpl.this.fabricService.getVersion(this.getVersion());
            boolean first = true;
            for (String p : ContainerImpl.this.fabricService.getDataStore().getContainerProfiles(ContainerImpl.this.id)) {
                try {
                    if (!first) {
                        sb.append("-");
                    } else {
                        first = false;
                    }
                    sb.append(v.getProfile(p));
                }
                catch (Exception e) {}
            }
            return sb.toString();
        }
    }
}

