/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.service;

import io.fabric8.api.FabricException;
import io.fabric8.service.JmxTemplateSupport;
import java.io.IOException;
import javax.management.remote.JMXConnector;

public abstract class NonCachingJmxTemplate
extends JmxTemplateSupport {
    /*
     * Loose catch block
     */
    @Override
    public <T> T execute(JmxTemplateSupport.JmxConnectorCallback<T> callback) {
        ClassLoader original = Thread.currentThread().getContextClassLoader();
        try {
            T t;
            Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
            JMXConnector connector = this.createConnector();
            if (connector == null) {
                throw new IllegalStateException("JMX connector can not be created");
            }
            try {
                t = callback.doWithJmxConnector(connector);
            }
            catch (Exception e) {
                throw FabricException.launderThrowable((Throwable)e);
            }
            finally {
                try {
                    connector.close();
                }
                catch (IOException e) {}
            }
            return t;
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            Thread.currentThread().setContextClassLoader(original);
        }
    }

    protected abstract JMXConnector createConnector();
}

