/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.service.child;

import io.fabric8.api.CreateContainerBasicOptions;
import io.fabric8.api.FabricService;
import io.fabric8.api.Profiles;
import io.fabric8.common.util.Strings;
import io.fabric8.utils.PasswordEncoder;
import java.util.Map;
import java.util.Set;

public class ChildContainers {
    public static boolean isJavaContainer(FabricService fabricService, CreateContainerBasicOptions options) {
        Map javaContainerConfig = Profiles.getOverlayConfiguration((FabricService)fabricService, (Iterable)options.getProfiles(), (String)options.getVersion(), (String)"io.fabric8.container.java");
        return !javaContainerConfig.isEmpty();
    }

    public static boolean isProcessContainer(FabricService fabricService, CreateContainerBasicOptions options) {
        String versionId;
        Set profileIds = options.getProfiles();
        Map processConfig = Profiles.getOverlayConfiguration((FabricService)fabricService, (Iterable)profileIds, (String)(versionId = options.getVersion()), (String)"io.fabric8.container.process");
        return processConfig != null && processConfig.size() > 0;
    }

    public static Map<String, String> getEnvironmentVariables(FabricService service, CreateContainerBasicOptions options) {
        String localIp;
        Set profileIds = options.getProfiles();
        String versionId = options.getVersion();
        String zookeeperUrl = service.getZookeeperUrl();
        String zookeeperPassword = service.getZookeeperPassword();
        if (zookeeperPassword != null) {
            zookeeperPassword = PasswordEncoder.encode(zookeeperPassword);
        }
        if (!Strings.isNullOrBlank((String)(localIp = service.getCurrentContainer().getLocalIp()))) {
            int idx = zookeeperUrl.lastIndexOf(58);
            if (idx > 0) {
                localIp = localIp + zookeeperUrl.substring(idx);
            }
            zookeeperUrl = localIp;
        }
        Map envVarsOverlay = Profiles.getOverlayConfiguration((FabricService)service, (Iterable)profileIds, (String)versionId, (String)"io.fabric8.environment");
        String containerName = options.getName();
        envVarsOverlay.put("FABRIC8_KARAF_NAME", containerName);
        envVarsOverlay.put("FABRIC8_CONTAINER_NAME", containerName);
        if (!options.isEnsembleServer()) {
            if (envVarsOverlay.get("FABRIC8_ZOOKEEPER_URL") == null) {
                envVarsOverlay.put("FABRIC8_ZOOKEEPER_URL", zookeeperUrl);
            }
            if (envVarsOverlay.get("FABRIC8_ZOOKEEPER_PASSWORD") == null) {
                envVarsOverlay.put("FABRIC8_ZOOKEEPER_PASSWORD", zookeeperPassword);
            }
            if (envVarsOverlay.get("FABRIC8_ZOOKEEPER_PASSWORD_ENCODE") == null) {
                String zkPasswordEncode = System.getProperty("zookeeper.password.encode", "true");
                envVarsOverlay.put("FABRIC8_ZOOKEEPER_PASSWORD_ENCODE", zkPasswordEncode);
            }
        }
        return envVarsOverlay;
    }
}

