/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.authz.support;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import javax.naming.directory.SearchControls;
import org.apache.directory.server.core.authn.AuthenticationInterceptor;
import org.apache.directory.server.core.authz.AciAuthorizationInterceptor;
import org.apache.directory.server.core.authz.DefaultAuthorizationInterceptor;
import org.apache.directory.server.core.authz.support.ACITupleFilter;
import org.apache.directory.server.core.authz.support.OperationScope;
import org.apache.directory.server.core.event.EventInterceptor;
import org.apache.directory.server.core.interceptor.context.OperationContext;
import org.apache.directory.server.core.interceptor.context.SearchOperationContext;
import org.apache.directory.server.core.normalization.NormalizationInterceptor;
import org.apache.directory.server.core.operational.OperationalAttributeInterceptor;
import org.apache.directory.server.core.schema.SchemaInterceptor;
import org.apache.directory.server.core.subtree.SubentryInterceptor;
import org.apache.directory.shared.ldap.aci.ACITuple;
import org.apache.directory.shared.ldap.aci.MicroOperation;
import org.apache.directory.shared.ldap.aci.ProtectedItem;
import org.apache.directory.shared.ldap.constants.AuthenticationLevel;
import org.apache.directory.shared.ldap.cursor.Cursor;
import org.apache.directory.shared.ldap.entry.ServerEntry;
import org.apache.directory.shared.ldap.entry.Value;
import org.apache.directory.shared.ldap.filter.ExprNode;
import org.apache.directory.shared.ldap.filter.PresenceNode;
import org.apache.directory.shared.ldap.message.AliasDerefMode;
import org.apache.directory.shared.ldap.name.DN;
import org.apache.directory.shared.ldap.schema.SchemaManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MaxImmSubFilter
implements ACITupleFilter {
    private final ExprNode childrenFilter = new PresenceNode("objectClass");
    private final SearchControls childrenSearchControls = new SearchControls();
    public static final Collection<String> SEARCH_BYPASS;

    public MaxImmSubFilter() {
        this.childrenSearchControls.setSearchScope(1);
    }

    @Override
    public Collection<ACITuple> filter(SchemaManager schemaManager, Collection<ACITuple> tuples, OperationScope scope, OperationContext opContext, Collection<DN> userGroupNames, DN userName, ServerEntry userEntry, AuthenticationLevel authenticationLevel, DN entryName, String attrId, Value<?> attrValue, ServerEntry entry, Collection<MicroOperation> microOperations, ServerEntry entryView) throws Exception {
        if (entryName.size() == 0) {
            return tuples;
        }
        if (tuples.size() == 0) {
            return tuples;
        }
        if (scope != OperationScope.ENTRY) {
            return tuples;
        }
        int immSubCount = -1;
        Iterator<ACITuple> i = tuples.iterator();
        block0: while (i.hasNext()) {
            ACITuple tuple = i.next();
            if (!tuple.isGrant()) continue;
            for (ProtectedItem item : tuple.getProtectedItems()) {
                ProtectedItem.MaxImmSub mis;
                if (!(item instanceof ProtectedItem.MaxImmSub)) continue;
                if (immSubCount < 0) {
                    immSubCount = this.getImmSubCount(schemaManager, opContext, entryName);
                }
                if (immSubCount < (mis = (ProtectedItem.MaxImmSub)item).getValue()) continue;
                i.remove();
                continue block0;
            }
        }
        return tuples;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getImmSubCount(SchemaManager schemaManager, OperationContext opContext, DN entryName) throws Exception {
        int cnt = 0;
        Cursor results = null;
        try {
            SearchOperationContext searchContext = new SearchOperationContext(opContext.getSession(), entryName.getPrefix(1), this.childrenFilter, this.childrenSearchControls);
            searchContext.setByPassed(SEARCH_BYPASS);
            searchContext.setAliasDerefMode(AliasDerefMode.DEREF_ALWAYS);
            results = opContext.getSession().getDirectoryService().getOperationManager().search(searchContext);
            while (results.next()) {
                results.get();
                ++cnt;
            }
        }
        finally {
            if (results != null) {
                results.close();
            }
        }
        return cnt;
    }

    static {
        HashSet<String> c = new HashSet<String>();
        c.add(NormalizationInterceptor.class.getName());
        c.add(AuthenticationInterceptor.class.getName());
        c.add(AciAuthorizationInterceptor.class.getName());
        c.add(DefaultAuthorizationInterceptor.class.getName());
        c.add(OperationalAttributeInterceptor.class.getName());
        c.add(SchemaInterceptor.class.getName());
        c.add(SubentryInterceptor.class.getName());
        c.add(EventInterceptor.class.getName());
        SEARCH_BYPASS = Collections.unmodifiableCollection(c);
    }
}

