/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.schema;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.naming.NamingException;
import javax.naming.directory.SearchControls;
import org.apache.directory.server.core.entry.ClonedServerEntry;
import org.apache.directory.server.core.filtering.EntryFilteringCursor;
import org.apache.directory.server.core.interceptor.context.LookupOperationContext;
import org.apache.directory.server.core.interceptor.context.ModifyOperationContext;
import org.apache.directory.server.core.interceptor.context.SearchOperationContext;
import org.apache.directory.server.core.partition.Partition;
import org.apache.directory.server.core.schema.SchemaPartitionDao;
import org.apache.directory.server.i18n.I18n;
import org.apache.directory.shared.ldap.cursor.Cursor;
import org.apache.directory.shared.ldap.entry.DefaultServerAttribute;
import org.apache.directory.shared.ldap.entry.EntryAttribute;
import org.apache.directory.shared.ldap.entry.Modification;
import org.apache.directory.shared.ldap.entry.ModificationOperation;
import org.apache.directory.shared.ldap.entry.ServerEntry;
import org.apache.directory.shared.ldap.entry.ServerModification;
import org.apache.directory.shared.ldap.entry.StringValue;
import org.apache.directory.shared.ldap.filter.AndNode;
import org.apache.directory.shared.ldap.filter.EqualityNode;
import org.apache.directory.shared.ldap.filter.OrNode;
import org.apache.directory.shared.ldap.filter.PresenceNode;
import org.apache.directory.shared.ldap.filter.SearchScope;
import org.apache.directory.shared.ldap.message.AliasDerefMode;
import org.apache.directory.shared.ldap.name.DN;
import org.apache.directory.shared.ldap.name.RDN;
import org.apache.directory.shared.ldap.schema.AttributeType;
import org.apache.directory.shared.ldap.schema.AttributeTypeOptions;
import org.apache.directory.shared.ldap.schema.MatchingRule;
import org.apache.directory.shared.ldap.schema.ObjectClass;
import org.apache.directory.shared.ldap.schema.SchemaManager;
import org.apache.directory.shared.ldap.schema.loader.ldif.SchemaEntityFactory;
import org.apache.directory.shared.ldap.schema.registries.Schema;
import org.apache.directory.shared.ldap.schema.syntaxCheckers.NumericOidSyntaxChecker;
import org.apache.directory.shared.ldap.util.DateUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SchemaPartitionDaoImpl
implements SchemaPartitionDao {
    private final Logger LOG = LoggerFactory.getLogger(this.getClass());
    private static final NumericOidSyntaxChecker NUMERIC_OID_CHECKER = new NumericOidSyntaxChecker();
    private static final String[] SCHEMA_ATTRIBUTES = new String[]{"2.5.18.3", "m-dependencies", "2.5.4.0", "2.5.4.3", "m-disabled"};
    private final Partition partition;
    private final SchemaEntityFactory factory;
    private final SchemaManager schemaManager;
    private final String M_NAME_OID;
    private final String CN_OID;
    private final String M_OID_OID;
    private final String OBJECTCLASS_OID;
    private final String M_SYNTAX_OID;
    private final String M_ORDERING_OID;
    private final String M_SUBSTRING_OID;
    private final String M_EQUALITY_OID;
    private final String M_SUP_ATTRIBUTE_TYPE_OID;
    private final String M_MUST_OID;
    private final String M_MAY_OID;
    private final String M_AUX_OID;
    private final String M_OC_OID;
    private final String M_SUP_OBJECT_CLASS_OID;
    private final String M_DEPENDENCIES_OID;
    private final Set<AttributeTypeOptions> schemaAttributesToReturn = new HashSet<AttributeTypeOptions>();
    private final AttributeType disabledAttributeType;

    public SchemaPartitionDaoImpl(Partition partition, SchemaManager schemaManager) throws Exception {
        this.partition = partition;
        this.factory = new SchemaEntityFactory();
        this.schemaManager = schemaManager;
        this.M_NAME_OID = schemaManager.getAttributeTypeRegistry().getOidByName("m-name");
        this.CN_OID = schemaManager.getAttributeTypeRegistry().getOidByName("cn");
        this.disabledAttributeType = schemaManager.lookupAttributeTypeRegistry("m-disabled");
        this.M_OID_OID = schemaManager.getAttributeTypeRegistry().getOidByName("m-oid");
        this.OBJECTCLASS_OID = schemaManager.getAttributeTypeRegistry().getOidByName("objectClass");
        this.M_SYNTAX_OID = schemaManager.getAttributeTypeRegistry().getOidByName("m-syntax");
        this.M_ORDERING_OID = schemaManager.getAttributeTypeRegistry().getOidByName("m-ordering");
        this.M_EQUALITY_OID = schemaManager.getAttributeTypeRegistry().getOidByName("m-equality");
        this.M_SUBSTRING_OID = schemaManager.getAttributeTypeRegistry().getOidByName("m-substr");
        this.M_SUP_ATTRIBUTE_TYPE_OID = schemaManager.getAttributeTypeRegistry().getOidByName("m-supAttributeType");
        this.M_MUST_OID = schemaManager.getAttributeTypeRegistry().getOidByName("m-must");
        this.M_MAY_OID = schemaManager.getAttributeTypeRegistry().getOidByName("m-may");
        this.M_AUX_OID = schemaManager.getAttributeTypeRegistry().getOidByName("m-aux");
        this.M_OC_OID = schemaManager.getAttributeTypeRegistry().getOidByName("m-oc");
        this.M_SUP_OBJECT_CLASS_OID = schemaManager.getAttributeTypeRegistry().getOidByName("m-supObjectClass");
        this.M_DEPENDENCIES_OID = schemaManager.getAttributeTypeRegistry().getOidByName("m-dependencies");
        for (String attrId : SCHEMA_ATTRIBUTES) {
            AttributeTypeOptions ato = new AttributeTypeOptions(schemaManager.lookupAttributeTypeRegistry(attrId));
            this.schemaAttributesToReturn.add(ato);
        }
    }

    @Override
    public Map<String, Schema> getSchemas() throws Exception {
        HashMap<String, Schema> schemas = new HashMap<String, Schema>();
        EntryFilteringCursor list = this.listSchemas();
        while (list.next()) {
            ServerEntry sr = (ServerEntry)list.get();
            Schema schema = this.factory.getSchema(sr);
            schemas.put(schema.getSchemaName(), schema);
        }
        return schemas;
    }

    @Override
    public Set<String> getSchemaNames() throws Exception {
        HashSet<String> schemaNames = new HashSet<String>();
        EntryFilteringCursor list = this.listSchemas();
        while (list.next()) {
            ServerEntry sr = (ServerEntry)list.get();
            schemaNames.add(sr.get("cn").getString());
        }
        return schemaNames;
    }

    private EntryFilteringCursor listSchemas() throws Exception {
        DN base = new DN("ou=schema");
        base.normalize(this.schemaManager.getNormalizerMapping());
        EqualityNode<String> filter = new EqualityNode<String>(this.schemaManager.getAttributeTypeRegistry().getOidByName("objectClass"), new StringValue("metaSchema"));
        SearchOperationContext searchContext = new SearchOperationContext(null);
        searchContext.setDn(base);
        searchContext.setScope(SearchScope.ONELEVEL);
        searchContext.setReturningAttributes(this.schemaAttributesToReturn);
        searchContext.setFilter(filter);
        return this.partition.search(searchContext);
    }

    @Override
    public Schema getSchema(String schemaName) throws Exception {
        DN dn = new DN("cn=" + schemaName + ",ou=schema");
        dn.normalize(this.schemaManager.getNormalizerMapping());
        return this.factory.getSchema(this.partition.lookup(new LookupOperationContext(null, dn)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean hasMatchingRule(String oid) throws Exception {
        AndNode filter = new AndNode();
        filter.addNode(new EqualityNode<String>(this.OBJECTCLASS_OID, new StringValue("metaMatchingRule")));
        if (NUMERIC_OID_CHECKER.isValidSyntax(oid)) {
            filter.addNode(new EqualityNode<String>(this.M_OID_OID, new StringValue(oid)));
        } else {
            filter.addNode(new EqualityNode<String>(this.M_NAME_OID, new StringValue(oid.toLowerCase())));
        }
        SearchControls searchControls = new SearchControls();
        searchControls.setSearchScope(2);
        Cursor cursor = null;
        try {
            SearchOperationContext searchOperationContext = new SearchOperationContext(null, this.partition.getSuffixDn(), filter, searchControls);
            searchOperationContext.setAliasDerefMode(AliasDerefMode.DEREF_ALWAYS);
            cursor = this.partition.search(searchOperationContext);
            if (!cursor.next()) {
                boolean bl = false;
                return bl;
            }
            if (cursor.next()) {
                throw new NamingException(I18n.err(I18n.ERR_430, oid));
            }
            boolean bl = true;
            return bl;
        }
        finally {
            if (cursor != null) {
                cursor.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean hasAttributeType(String oid) throws Exception {
        AndNode filter = new AndNode();
        filter.addNode(new EqualityNode<String>(this.OBJECTCLASS_OID, new StringValue("metaAttributeType")));
        if (NUMERIC_OID_CHECKER.isValidSyntax(oid)) {
            filter.addNode(new EqualityNode<String>(this.M_OID_OID, new StringValue(oid)));
        } else {
            filter.addNode(new EqualityNode<String>(this.M_NAME_OID, new StringValue(oid.toLowerCase())));
        }
        SearchControls searchControls = new SearchControls();
        searchControls.setSearchScope(2);
        Cursor cursor = null;
        try {
            SearchOperationContext searchOperationContext = new SearchOperationContext(null, this.partition.getSuffixDn(), filter, searchControls);
            searchOperationContext.setAliasDerefMode(AliasDerefMode.DEREF_ALWAYS);
            cursor = this.partition.search(searchOperationContext);
            if (!cursor.next()) {
                boolean bl = false;
                return bl;
            }
            if (cursor.next()) {
                throw new NamingException(I18n.err(I18n.ERR_431, oid));
            }
            boolean bl = true;
            return bl;
        }
        finally {
            if (cursor != null) {
                cursor.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean hasObjectClass(String oid) throws Exception {
        AndNode filter = new AndNode();
        filter.addNode(new EqualityNode<String>(this.OBJECTCLASS_OID, new StringValue("metaObjectClass")));
        if (NUMERIC_OID_CHECKER.isValidSyntax(oid)) {
            filter.addNode(new EqualityNode<String>(this.M_OID_OID, new StringValue(oid)));
        } else {
            filter.addNode(new EqualityNode<String>(this.M_NAME_OID, new StringValue(oid.toLowerCase())));
        }
        SearchControls searchControls = new SearchControls();
        searchControls.setSearchScope(2);
        Cursor cursor = null;
        try {
            SearchOperationContext searchOperationContext = new SearchOperationContext(null, this.partition.getSuffixDn(), filter, searchControls);
            searchOperationContext.setAliasDerefMode(AliasDerefMode.DEREF_ALWAYS);
            cursor = this.partition.search(searchOperationContext);
            if (!cursor.next()) {
                boolean bl = false;
                return bl;
            }
            if (cursor.next()) {
                throw new NamingException(I18n.err(I18n.ERR_431, oid));
            }
            boolean bl = true;
            return bl;
        }
        finally {
            if (cursor != null) {
                cursor.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean hasSyntax(String oid) throws Exception {
        AndNode filter = new AndNode();
        filter.addNode(new EqualityNode<String>(this.OBJECTCLASS_OID, new StringValue("metaSyntax")));
        if (NUMERIC_OID_CHECKER.isValidSyntax(oid)) {
            filter.addNode(new EqualityNode<String>(this.M_OID_OID, new StringValue(oid)));
        } else {
            filter.addNode(new EqualityNode<String>(this.M_NAME_OID, new StringValue(oid.toLowerCase())));
        }
        SearchControls searchControls = new SearchControls();
        searchControls.setSearchScope(2);
        Cursor cursor = null;
        try {
            SearchOperationContext searchOperationContext = new SearchOperationContext(null, this.partition.getSuffixDn(), filter, searchControls);
            searchOperationContext.setAliasDerefMode(AliasDerefMode.DEREF_ALWAYS);
            cursor = this.partition.search(searchOperationContext);
            if (!cursor.next()) {
                boolean bl = false;
                return bl;
            }
            if (cursor.next()) {
                throw new NamingException(I18n.err(I18n.ERR_432, oid));
            }
            boolean bl = true;
            return bl;
        }
        finally {
            if (cursor != null) {
                cursor.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean hasSyntaxChecker(String oid) throws Exception {
        AndNode filter = new AndNode();
        filter.addNode(new EqualityNode<String>(this.OBJECTCLASS_OID, new StringValue("metaSyntaxChecker")));
        if (NUMERIC_OID_CHECKER.isValidSyntax(oid)) {
            filter.addNode(new EqualityNode<String>(this.M_OID_OID, new StringValue(oid)));
        } else {
            filter.addNode(new EqualityNode<String>(this.M_NAME_OID, new StringValue(oid.toLowerCase())));
        }
        SearchControls searchControls = new SearchControls();
        searchControls.setSearchScope(2);
        Cursor cursor = null;
        try {
            SearchOperationContext searchOperationContext = new SearchOperationContext(null, this.partition.getSuffixDn(), filter, searchControls);
            searchOperationContext.setAliasDerefMode(AliasDerefMode.DEREF_ALWAYS);
            cursor = this.partition.search(searchOperationContext);
            if (!cursor.next()) {
                boolean bl = false;
                return bl;
            }
            if (cursor.next()) {
                throw new NamingException(I18n.err(I18n.ERR_433, oid));
            }
            boolean bl = true;
            return bl;
        }
        finally {
            if (cursor != null) {
                cursor.close();
            }
        }
    }

    @Override
    public String findSchema(String entityName) throws Exception {
        DN dn = this.findDn(entityName);
        if (dn == null) {
            return null;
        }
        RDN rdn = dn.getRdn(1);
        if (!rdn.getNormType().equalsIgnoreCase(this.CN_OID)) {
            throw new NamingException(I18n.err(I18n.ERR_434, dn.getNormName(), this.CN_OID, rdn.getNormType()));
        }
        return rdn.getNormValue();
    }

    @Override
    public DN findDn(String entityName) throws Exception {
        ServerEntry sr = this.find(entityName);
        DN dn = sr.getDn();
        dn.normalize(this.schemaManager.getNormalizerMapping());
        return dn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ServerEntry find(String entityName) throws Exception {
        OrNode filter = new OrNode();
        EqualityNode<String> nameAVA = new EqualityNode<String>(this.M_NAME_OID, new StringValue(entityName.toLowerCase()));
        EqualityNode<String> oidAVA = new EqualityNode<String>(this.M_OID_OID, new StringValue(entityName.toLowerCase()));
        filter.addNode(nameAVA);
        filter.addNode(oidAVA);
        SearchControls searchControls = new SearchControls();
        searchControls.setSearchScope(2);
        Cursor cursor = null;
        try {
            SearchOperationContext searchOperationContext = new SearchOperationContext(null, this.partition.getSuffixDn(), filter, searchControls);
            searchOperationContext.setAliasDerefMode(AliasDerefMode.DEREF_ALWAYS);
            cursor = this.partition.search(searchOperationContext);
            if (!cursor.next()) {
                ServerEntry serverEntry = null;
                return serverEntry;
            }
            ServerEntry sr = (ServerEntry)cursor.get();
            if (cursor.next()) {
                throw new NamingException(I18n.err(I18n.ERR_435, entityName));
            }
            ServerEntry serverEntry = sr;
            return serverEntry;
        }
        finally {
            if (cursor != null) {
                cursor.close();
            }
        }
    }

    @Override
    public void enableSchema(String schemaName) throws Exception {
        DN dn = new DN("cn=" + schemaName + ",ou=schema");
        dn.normalize(this.schemaManager.getNormalizerMapping());
        ClonedServerEntry entry = this.partition.lookup(new LookupOperationContext(null, dn));
        EntryAttribute disabledAttr = entry.get(this.disabledAttributeType);
        ArrayList<Modification> mods = new ArrayList<Modification>(3);
        if (disabledAttr == null) {
            this.LOG.warn("Does not make sense: you're trying to enable {} schema which is already enabled", (Object)schemaName);
            return;
        }
        boolean isDisabled = disabledAttr.contains("TRUE");
        if (!isDisabled) {
            this.LOG.warn("Does not make sense: you're trying to enable {} schema which is already enabled", (Object)schemaName);
            return;
        }
        mods.add(new ServerModification(ModificationOperation.REMOVE_ATTRIBUTE, new DefaultServerAttribute("m-disabled", this.schemaManager.lookupAttributeTypeRegistry("m-disabled"))));
        mods.add(new ServerModification(ModificationOperation.ADD_ATTRIBUTE, new DefaultServerAttribute("modifiersName", this.schemaManager.lookupAttributeTypeRegistry("modifiersName"), "uid=admin,ou=system")));
        mods.add(new ServerModification(ModificationOperation.ADD_ATTRIBUTE, new DefaultServerAttribute("modifyTimestamp", this.schemaManager.lookupAttributeTypeRegistry("modifyTimestamp"), DateUtils.getGeneralizedTime())));
        this.partition.modify(new ModifyOperationContext(null, dn, mods));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<ServerEntry> listSyntaxDependents(String numericOid) throws Exception {
        HashSet<ServerEntry> set = new HashSet<ServerEntry>();
        AndNode filter = new AndNode();
        OrNode or = new OrNode();
        or.addNode(new EqualityNode<String>(this.OBJECTCLASS_OID, new StringValue("metaMatchingRule".toLowerCase())));
        or.addNode(new EqualityNode<String>(this.OBJECTCLASS_OID, new StringValue("metaAttributeType".toLowerCase())));
        filter.addNode(or);
        filter.addNode(new EqualityNode<String>(this.M_SYNTAX_OID, new StringValue(numericOid.toLowerCase())));
        SearchControls searchControls = new SearchControls();
        searchControls.setSearchScope(2);
        Cursor cursor = null;
        try {
            SearchOperationContext searchOperationContext = new SearchOperationContext(null, this.partition.getSuffixDn(), filter, searchControls);
            searchOperationContext.setAliasDerefMode(AliasDerefMode.DEREF_ALWAYS);
            cursor = this.partition.search(searchOperationContext);
            while (cursor.next()) {
                set.add((ServerEntry)cursor.get());
            }
        }
        finally {
            if (cursor != null) {
                cursor.close();
            }
        }
        return set;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<ServerEntry> listMatchingRuleDependents(MatchingRule mr) throws Exception {
        HashSet<ServerEntry> set = new HashSet<ServerEntry>();
        AndNode filter = new AndNode();
        filter.addNode(new EqualityNode<String>(this.OBJECTCLASS_OID, new StringValue("metaAttributeType".toLowerCase())));
        OrNode or = new OrNode();
        or.addNode(new EqualityNode<String>(this.M_ORDERING_OID, new StringValue(mr.getOid())));
        or.addNode(new EqualityNode<String>(this.M_SUBSTRING_OID, new StringValue(mr.getOid())));
        or.addNode(new EqualityNode<String>(this.M_EQUALITY_OID, new StringValue(mr.getOid())));
        filter.addNode(or);
        List<String> names = mr.getNames();
        if (names != null && names.size() > 0) {
            for (String name : names) {
                or.addNode(new EqualityNode<String>(this.M_ORDERING_OID, new StringValue(name.toLowerCase())));
                or.addNode(new EqualityNode<String>(this.M_SUBSTRING_OID, new StringValue(name.toLowerCase())));
                or.addNode(new EqualityNode<String>(this.M_EQUALITY_OID, new StringValue(name.toLowerCase())));
            }
        }
        SearchControls searchControls = new SearchControls();
        searchControls.setSearchScope(2);
        Cursor cursor = null;
        try {
            SearchOperationContext searchOperationContext = new SearchOperationContext(null, this.partition.getSuffixDn(), filter, searchControls);
            searchOperationContext.setAliasDerefMode(AliasDerefMode.DEREF_ALWAYS);
            cursor = this.partition.search(searchOperationContext);
            while (cursor.next()) {
                set.add((ServerEntry)cursor.get());
            }
        }
        finally {
            if (cursor != null) {
                cursor.close();
            }
        }
        return set;
    }

    @Override
    public EntryFilteringCursor listAllNames() throws Exception {
        SearchControls searchControls = new SearchControls();
        searchControls.setSearchScope(2);
        AndNode filter = new AndNode();
        filter.addNode(new PresenceNode(this.M_OID_OID));
        filter.addNode(new PresenceNode(this.M_NAME_OID));
        SearchOperationContext searchOperationContext = new SearchOperationContext(null, this.partition.getSuffixDn(), filter, searchControls);
        searchOperationContext.setAliasDerefMode(AliasDerefMode.DEREF_ALWAYS);
        return this.partition.search(searchOperationContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<ServerEntry> listAttributeTypeDependents(AttributeType at) throws Exception {
        HashSet<ServerEntry> set = new HashSet<ServerEntry>();
        AndNode filter = new AndNode();
        OrNode or = new OrNode();
        or.addNode(new EqualityNode<String>(this.OBJECTCLASS_OID, new StringValue("metaAttributeType".toLowerCase())));
        or.addNode(new EqualityNode<String>(this.OBJECTCLASS_OID, new StringValue("metaObjectClass".toLowerCase())));
        filter.addNode(or);
        or = new OrNode();
        or.addNode(new EqualityNode<String>(this.M_MAY_OID, new StringValue(at.getOid())));
        or.addNode(new EqualityNode<String>(this.M_MUST_OID, new StringValue(at.getOid())));
        or.addNode(new EqualityNode<String>(this.M_SUP_ATTRIBUTE_TYPE_OID, new StringValue(at.getOid())));
        filter.addNode(or);
        SearchControls searchControls = new SearchControls();
        searchControls.setSearchScope(2);
        Cursor cursor = null;
        try {
            SearchOperationContext searchOperationContext = new SearchOperationContext(null, this.partition.getSuffixDn(), filter, searchControls);
            searchOperationContext.setAliasDerefMode(AliasDerefMode.DEREF_ALWAYS);
            cursor = this.partition.search(searchOperationContext);
            while (cursor.next()) {
                set.add((ServerEntry)cursor.get());
            }
        }
        finally {
            if (cursor != null) {
                cursor.close();
            }
        }
        return set;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<ServerEntry> listSchemaDependents(String schemaName) throws Exception {
        HashSet<ServerEntry> set = new HashSet<ServerEntry>();
        AndNode filter = new AndNode();
        filter.addNode(new EqualityNode<String>(this.OBJECTCLASS_OID, new StringValue("metaSchema".toLowerCase())));
        filter.addNode(new EqualityNode<String>(this.M_DEPENDENCIES_OID, new StringValue(schemaName.toLowerCase())));
        SearchControls searchControls = new SearchControls();
        searchControls.setSearchScope(1);
        Cursor cursor = null;
        try {
            SearchOperationContext searchOperationContext = new SearchOperationContext(null, this.partition.getSuffixDn(), filter, searchControls);
            searchOperationContext.setAliasDerefMode(AliasDerefMode.DEREF_ALWAYS);
            cursor = this.partition.search(searchOperationContext);
            while (cursor.next()) {
                set.add((ServerEntry)cursor.get());
            }
        }
        finally {
            if (cursor != null) {
                cursor.close();
            }
        }
        return set;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<ServerEntry> listEnabledSchemaDependents(String schemaName) throws Exception {
        HashSet<ServerEntry> set = new HashSet<ServerEntry>();
        AndNode filter = new AndNode();
        filter.addNode(new EqualityNode<String>(this.OBJECTCLASS_OID, new StringValue("metaSchema".toLowerCase())));
        filter.addNode(new EqualityNode<String>(this.M_DEPENDENCIES_OID, new StringValue(schemaName.toLowerCase())));
        SearchControls searchControls = new SearchControls();
        searchControls.setSearchScope(1);
        Cursor cursor = null;
        try {
            SearchOperationContext searchOperationContext = new SearchOperationContext(null, this.partition.getSuffixDn(), filter, searchControls);
            searchOperationContext.setAliasDerefMode(AliasDerefMode.DEREF_ALWAYS);
            cursor = this.partition.search(searchOperationContext);
            while (cursor.next()) {
                ServerEntry sr = (ServerEntry)cursor.get();
                EntryAttribute disabled = sr.get(this.disabledAttributeType);
                if (disabled == null) {
                    set.add(sr);
                    continue;
                }
                if (!disabled.get().equals("FALSE")) continue;
                set.add(sr);
            }
        }
        finally {
            if (cursor != null) {
                cursor.close();
            }
        }
        return set;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<ServerEntry> listObjectClassDependents(ObjectClass oc) throws Exception {
        HashSet<ServerEntry> set = new HashSet<ServerEntry>();
        AndNode filter = new AndNode();
        OrNode or = new OrNode();
        or.addNode(new EqualityNode<String>(this.OBJECTCLASS_OID, new StringValue("metaNameForm".toLowerCase())));
        or.addNode(new EqualityNode<String>(this.OBJECTCLASS_OID, new StringValue("metaObjectClass".toLowerCase())));
        or.addNode(new EqualityNode<String>(this.OBJECTCLASS_OID, new StringValue("metaDITContentRule".toLowerCase())));
        filter.addNode(or);
        or = new OrNode();
        or.addNode(new EqualityNode<String>(this.M_AUX_OID, new StringValue(oc.getOid())));
        or.addNode(new EqualityNode<String>(this.M_OC_OID, new StringValue(oc.getOid())));
        or.addNode(new EqualityNode<String>(this.M_SUP_OBJECT_CLASS_OID, new StringValue(oc.getOid())));
        filter.addNode(or);
        SearchControls searchControls = new SearchControls();
        searchControls.setSearchScope(2);
        Cursor cursor = null;
        try {
            SearchOperationContext searchOperationContext = new SearchOperationContext(null, this.partition.getSuffixDn(), filter, searchControls);
            searchOperationContext.setAliasDerefMode(AliasDerefMode.DEREF_ALWAYS);
            cursor = this.partition.search(searchOperationContext);
            while (cursor.next()) {
                set.add((ServerEntry)cursor.get());
            }
        }
        finally {
            if (cursor != null) {
                cursor.close();
            }
        }
        return set;
    }
}

