/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.dns.protocol;

import org.apache.directory.server.dns.io.decoder.DnsMessageDecoder;
import org.apache.directory.server.i18n.I18n;
import org.apache.mina.core.buffer.IoBuffer;
import org.apache.mina.core.session.IoSession;
import org.apache.mina.filter.codec.CumulativeProtocolDecoder;
import org.apache.mina.filter.codec.ProtocolDecoderOutput;

public class DnsTcpDecoder
extends CumulativeProtocolDecoder {
    private DnsMessageDecoder decoder = new DnsMessageDecoder();
    private int maxObjectSize = 16384;

    public int getMaxObjectSize() {
        return this.maxObjectSize;
    }

    public void setMaxObjectSize(int maxObjectSize) {
        if (maxObjectSize <= 0) {
            throw new IllegalArgumentException(I18n.err(I18n.ERR_634, maxObjectSize));
        }
        this.maxObjectSize = maxObjectSize;
    }

    protected boolean doDecode(IoSession session, IoBuffer in, ProtocolDecoderOutput out) throws Exception {
        if (!in.prefixedDataAvailable(2, this.maxObjectSize)) {
            return false;
        }
        in.getShort();
        out.write((Object)this.decoder.decode(in));
        return true;
    }
}

