/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.ldap.handlers.ssl;

import java.security.KeyStore;
import java.security.SecureRandom;
import java.security.Security;
import javax.naming.NamingException;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import org.apache.directory.server.i18n.I18n;
import org.apache.directory.server.ldap.handlers.ssl.ServerX509TrustManager;
import org.apache.directory.shared.ldap.util.StringTools;
import org.apache.mina.core.filterchain.DefaultIoFilterChainBuilder;
import org.apache.mina.core.filterchain.IoFilter;
import org.apache.mina.core.filterchain.IoFilterChainBuilder;
import org.apache.mina.filter.ssl.SslFilter;

public class LdapsInitializer {
    public static IoFilterChainBuilder init(KeyStore ks, String certificatePassord) throws NamingException {
        SSLContext sslCtx;
        try {
            String algorithm = Security.getProperty("ssl.KeyManagerFactory.algorithm");
            if (algorithm == null) {
                algorithm = KeyManagerFactory.getDefaultAlgorithm();
            }
            KeyManagerFactory kmf = KeyManagerFactory.getInstance(algorithm);
            if (StringTools.isEmpty(certificatePassord)) {
                kmf.init(ks, null);
            } else {
                kmf.init(ks, certificatePassord.toCharArray());
            }
            sslCtx = SSLContext.getInstance("TLS");
            sslCtx.init(kmf.getKeyManagers(), new TrustManager[]{new ServerX509TrustManager()}, new SecureRandom());
        }
        catch (Exception e) {
            throw (NamingException)new NamingException(I18n.err(I18n.ERR_683, new Object[0])).initCause(e);
        }
        DefaultIoFilterChainBuilder chain = new DefaultIoFilterChainBuilder();
        chain.addLast("sslFilter", (IoFilter)new SslFilter(sslCtx));
        return chain;
    }
}

