/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.codec.controls.replication.syncDoneValue;

import org.apache.directory.shared.asn1.ber.IAsn1Container;
import org.apache.directory.shared.asn1.ber.grammar.AbstractGrammar;
import org.apache.directory.shared.asn1.ber.grammar.GrammarAction;
import org.apache.directory.shared.asn1.ber.grammar.GrammarTransition;
import org.apache.directory.shared.asn1.ber.grammar.IGrammar;
import org.apache.directory.shared.asn1.ber.tlv.Value;
import org.apache.directory.shared.asn1.codec.DecoderException;
import org.apache.directory.shared.asn1.util.BooleanDecoder;
import org.apache.directory.shared.asn1.util.BooleanDecoderException;
import org.apache.directory.shared.i18n.I18n;
import org.apache.directory.shared.ldap.codec.controls.replication.syncDoneValue.SyncDoneValueControlContainer;
import org.apache.directory.shared.ldap.codec.controls.replication.syncDoneValue.SyncDoneValueControlStatesEnum;
import org.apache.directory.shared.ldap.util.StringTools;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SyncDoneValueControlGrammar
extends AbstractGrammar {
    private static final Logger LOG = LoggerFactory.getLogger(SyncDoneValueControlGrammar.class);
    private static final boolean IS_DEBUG = LOG.isDebugEnabled();
    private static final SyncDoneValueControlGrammar INSTANCE = new SyncDoneValueControlGrammar();

    private SyncDoneValueControlGrammar() {
        this.name = SyncDoneValueControlGrammar.class.getName();
        this.statesEnum = SyncDoneValueControlStatesEnum.getInstance();
        this.transitions = new GrammarTransition[4][256];
        this.transitions[0][48] = new GrammarTransition(0, 1, 48, new GrammarAction("Initiaization"){

            public void action(IAsn1Container container) throws DecoderException {
                SyncDoneValueControlContainer syncDoneValueContainer = (SyncDoneValueControlContainer)container;
                syncDoneValueContainer.grammarEndAllowed(true);
            }
        });
        this.transitions[1][4] = new GrammarTransition(1, 2, 4, new GrammarAction("Set SyncDoneValueControl cookie"){

            public void action(IAsn1Container container) throws DecoderException {
                SyncDoneValueControlContainer syncDoneValueContainer = (SyncDoneValueControlContainer)container;
                Value value = syncDoneValueContainer.getCurrentTLV().getValue();
                byte[] cookie = value.getData();
                if (IS_DEBUG) {
                    LOG.debug("cookie = {}", (Object)StringTools.dumpBytes(cookie));
                }
                syncDoneValueContainer.getSyncDoneValueControl().setCookie(cookie);
                syncDoneValueContainer.grammarEndAllowed(true);
            }
        });
        GrammarAction refreshDeletesTagAction = new GrammarAction("set SyncDoneValueControl refreshDeletes flag"){

            public void action(IAsn1Container container) throws DecoderException {
                SyncDoneValueControlContainer syncDoneValueContainer = (SyncDoneValueControlContainer)container;
                Value value = syncDoneValueContainer.getCurrentTLV().getValue();
                try {
                    boolean refreshDeletes = BooleanDecoder.parse(value);
                    if (IS_DEBUG) {
                        LOG.debug("refreshDeletes = {}", (Object)refreshDeletes);
                    }
                    syncDoneValueContainer.getSyncDoneValueControl().setRefreshDeletes(refreshDeletes);
                    syncDoneValueContainer.grammarEndAllowed(true);
                }
                catch (BooleanDecoderException be) {
                    String msg = I18n.err("ERR_04024", new Object[0]);
                    LOG.error(msg, (Throwable)be);
                    throw new DecoderException(msg);
                }
            }
        };
        this.transitions[2][1] = new GrammarTransition(2, 3, 1, refreshDeletesTagAction);
        this.transitions[1][1] = new GrammarTransition(1, 3, 1, refreshDeletesTagAction);
    }

    public static IGrammar getInstance() {
        return INSTANCE;
    }
}

