/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.codec.intermediate;

import java.nio.BufferOverflowException;
import java.nio.ByteBuffer;
import org.apache.directory.shared.asn1.ber.tlv.TLV;
import org.apache.directory.shared.asn1.codec.EncoderException;
import org.apache.directory.shared.asn1.primitives.OID;
import org.apache.directory.shared.i18n.I18n;
import org.apache.directory.shared.ldap.codec.LdapResponseCodec;
import org.apache.directory.shared.ldap.codec.MessageTypeEnum;
import org.apache.directory.shared.ldap.util.StringTools;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IntermediateResponseCodec
extends LdapResponseCodec {
    private static Logger LOGGER = LoggerFactory.getLogger(IntermediateResponseCodec.class);
    private static final boolean IS_DEBUG = LOGGER.isDebugEnabled();
    private OID responseName;
    private byte[] responseValue;
    private int intermediateResponseLength;
    private int responseNameLength;

    public MessageTypeEnum getMessageType() {
        return MessageTypeEnum.INTERMEDIATE_RESPONSE;
    }

    public String getMessageTypeName() {
        return "INTERMEDIATE_RESPONSE";
    }

    public String getResponseName() {
        return this.responseName == null ? "" : this.responseName.toString();
    }

    public void setResponseName(OID responseName) {
        this.responseName = responseName;
    }

    public byte[] getResponseValue() {
        return this.responseValue;
    }

    public void setResponseValue(byte[] responseValue) {
        this.responseValue = responseValue;
    }

    protected int computeLengthProtocolOp() {
        this.intermediateResponseLength = 0;
        if (this.responseName != null) {
            this.responseNameLength = this.responseName.toString().length();
            this.intermediateResponseLength += 1 + TLV.getNbBytes(this.responseNameLength) + this.responseNameLength;
        }
        if (this.responseValue != null) {
            this.intermediateResponseLength += 1 + TLV.getNbBytes(this.responseValue.length) + this.responseValue.length;
        }
        int length = 1 + TLV.getNbBytes(this.intermediateResponseLength) + this.intermediateResponseLength;
        if (IS_DEBUG) {
            LOGGER.debug("Intermediate response length : {}", (Object)length);
        }
        return length;
    }

    protected void encodeProtocolOp(ByteBuffer buffer) throws EncoderException {
        try {
            buffer.put((byte)121);
            buffer.put(TLV.getBytes(this.intermediateResponseLength));
            if (this.responseName != null) {
                buffer.put((byte)-128);
                buffer.put(TLV.getBytes(this.responseNameLength));
                if (this.responseName.getOIDLength() != 0) {
                    buffer.put(StringTools.getBytesUtf8(this.responseName.toString()));
                }
            }
            if (this.responseValue != null) {
                buffer.put((byte)-127);
                buffer.put(TLV.getBytes(this.responseValue.length));
                if (this.responseValue.length != 0) {
                    buffer.put(this.responseValue);
                }
            }
        }
        catch (BufferOverflowException boe) {
            String msg = I18n.err("ERR_04005", new Object[0]);
            LOGGER.error(msg);
            throw new EncoderException(msg);
        }
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("    Intermediate Response\n");
        sb.append(super.toString());
        if (this.responseName != null) {
            sb.append("        Response name :'").append(this.responseName).append("'\n");
        }
        if (this.responseValue != null) {
            sb.append("        ResponseValue :'");
            sb.append(StringTools.dumpBytes(this.responseValue));
            sb.append("'\n");
        }
        return sb.toString();
    }
}

