/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.util.tree;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.directory.shared.i18n.I18n;
import org.apache.directory.shared.ldap.exception.LdapException;
import org.apache.directory.shared.ldap.exception.LdapUnwillingToPerformException;
import org.apache.directory.shared.ldap.message.ResultCodeEnum;
import org.apache.directory.shared.ldap.name.DN;
import org.apache.directory.shared.ldap.name.RDN;
import org.apache.directory.shared.ldap.util.tree.DnLeafNode;
import org.apache.directory.shared.ldap.util.tree.DnNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DnBranchNode<N>
implements DnNode<N> {
    private static final Logger LOG = LoggerFactory.getLogger(DnBranchNode.class);
    private Map<String, DnNode<N>> children = new HashMap<String, DnNode<N>>(3);
    private int size = 0;

    @Override
    public boolean isLeaf() {
        return false;
    }

    private DnNode<N> recursivelyAddElement(DnBranchNode<N> current, DN dn, int index, N element) throws LdapException {
        DnNode<N> child;
        String rdnAtIndex = dn.getRdn(index).getNormName();
        if (index == dn.size() - 1) {
            if (!current.contains(rdnAtIndex)) {
                return current.addNode(rdnAtIndex, new DnLeafNode<N>(element));
            }
            return null;
        }
        DnNode<N> newNode = current.getChild(rdnAtIndex);
        if (newNode instanceof DnLeafNode) {
            String message = I18n.err("ERR_04334", new Object[0]);
            LOG.error(message);
            throw new LdapUnwillingToPerformException(ResultCodeEnum.UNWILLING_TO_PERFORM, message);
        }
        if (newNode == null) {
            newNode = new DnBranchNode<N>();
        }
        if ((child = this.recursivelyAddElement((DnBranchNode)newNode, dn, index + 1, element)) != null) {
            return current.addNode(rdnAtIndex, child);
        }
        return null;
    }

    public DnNode<N> addNode(String rdn, DnNode<N> child) {
        this.children.put(rdn, child);
        ++this.size;
        return this;
    }

    public boolean contains(String rdn) {
        return this.children.containsKey(rdn);
    }

    public DnNode<N> getChild(String rdn) {
        if (this.children.containsKey(rdn)) {
            return this.children.get(rdn);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public N getParentElement(DN dn) {
        List<RDN> rdns = dn.getRdns();
        DnBranchNode dnBranchNode = this;
        synchronized (dnBranchNode) {
            DnNode<N> currentNode = this;
            for (int i = rdns.size() - 1; i >= 0; --i) {
                String rdnStr = rdns.get(i).getNormName();
                if (currentNode == null) break;
                if (currentNode instanceof DnLeafNode) {
                    return ((DnLeafNode)currentNode).getElement();
                }
                DnBranchNode currentBranch = currentNode;
                if (!currentBranch.contains(rdnStr) || !((currentNode = currentBranch.getChild(rdnStr)) instanceof DnLeafNode)) continue;
                return ((DnLeafNode)currentNode).getElement();
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasParentElement(DN dn) {
        List<RDN> rdns = dn.getRdns();
        DnBranchNode dnBranchNode = this;
        synchronized (dnBranchNode) {
            DnNode<N> currentNode = this;
            for (int i = rdns.size() - 1; i >= 0; --i) {
                String rdnStr = rdns.get(i).getNormName();
                if (currentNode == null) {
                    return false;
                }
                if (currentNode instanceof DnLeafNode) {
                    return true;
                }
                DnBranchNode currentBranch = currentNode;
                if (!currentBranch.contains(rdnStr) || !((currentNode = currentBranch.getChild(rdnStr)) instanceof DnLeafNode)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean hasChildren() {
        return this.children.size() != 0;
    }

    private boolean recursivelyRemoveElement(DnBranchNode<N> currentNode, N element) {
        for (String key : currentNode.children.keySet()) {
            DnNode<N> child = currentNode.children.get(key);
            if (child instanceof DnLeafNode) {
                if (!((DnLeafNode)child).getElement().equals(element)) continue;
                currentNode.children.remove(key);
                --currentNode.size;
                return true;
            }
            if (!this.recursivelyRemoveElement((DnBranchNode)child, element)) continue;
            if (((DnBranchNode)child).children.size() == 0) {
                currentNode.children.remove(key);
                --currentNode.size;
            } else {
                --currentNode.size;
            }
            return true;
        }
        return false;
    }

    public void add(DN dn, N element) throws LdapException {
        this.recursivelyAddElement(this, dn, 0, element);
    }

    public void remove(N element) {
        DnBranchNode currentNode = this;
        if (currentNode.hasChildren()) {
            this.recursivelyRemoveElement(currentNode, element);
        }
    }

    @Override
    public int size() {
        return this.size;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        boolean isFirst = true;
        for (String key : this.children.keySet()) {
            if (isFirst) {
                isFirst = false;
            } else {
                sb.append(", ");
            }
            DnNode<N> child = this.children.get(key);
            if (child instanceof DnBranchNode) {
                sb.append("Branch[").append(key).append("]: ").append(child);
                continue;
            }
            sb.append("Leaf: ").append("'").append(child).append("'");
        }
        sb.append("}");
        return sb.toString();
    }
}

