/*
 * Decompiled with CFR 0.152.
 */
package org.jolokia.http;

import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.UnknownHostException;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import javax.management.RuntimeMBeanException;
import javax.security.auth.Subject;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.jolokia.backend.BackendManager;
import org.jolokia.config.ConfigExtractor;
import org.jolokia.config.ConfigKey;
import org.jolokia.config.Configuration;
import org.jolokia.discovery.AgentDetails;
import org.jolokia.discovery.DiscoveryMulticastResponder;
import org.jolokia.http.HttpRequestHandler;
import org.jolokia.restrictor.AllowAllRestrictor;
import org.jolokia.restrictor.DenyAllRestrictor;
import org.jolokia.restrictor.PolicyRestrictor;
import org.jolokia.restrictor.Restrictor;
import org.jolokia.restrictor.RestrictorFactory;
import org.jolokia.util.ClassUtil;
import org.jolokia.util.LogHandler;
import org.jolokia.util.NetworkUtil;
import org.json.simple.JSONAware;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AgentServlet
extends HttpServlet {
    private static final long serialVersionUID = 42L;
    private ServletRequestHandler httpGetHandler;
    private ServletRequestHandler httpPostHandler;
    private BackendManager backendManager;
    private LogHandler logHandler;
    private HttpRequestHandler requestHandler;
    private Restrictor restrictor;
    private String configMimeType;
    private DiscoveryMulticastResponder discoveryMulticastResponder;

    public AgentServlet() {
        this(null);
    }

    public AgentServlet(Restrictor pRestrictor) {
        this.restrictor = pRestrictor;
    }

    protected LogHandler getLogHandler() {
        return this.logHandler;
    }

    protected Restrictor createRestrictor(String pLocation) {
        LogHandler log = this.getLogHandler();
        try {
            PolicyRestrictor newRestrictor = RestrictorFactory.lookupPolicyRestrictor(pLocation);
            if (newRestrictor != null) {
                log.info("Using access restrictor " + pLocation);
                return newRestrictor;
            }
            log.info("No access restrictor found at " + pLocation + ", access to all MBeans is allowed");
            return new AllowAllRestrictor();
        }
        catch (IOException e) {
            log.error("Error while accessing access restrictor at " + pLocation + ". Denying all access to MBeans for security reasons. Exception: " + e, e);
            return new DenyAllRestrictor();
        }
    }

    public void init(ServletConfig pServletConfig) throws ServletException {
        super.init(pServletConfig);
        Configuration config = this.initConfig(pServletConfig);
        String logHandlerClass = config.get(ConfigKey.LOGHANDLER_CLASS);
        this.logHandler = logHandlerClass != null ? (LogHandler)ClassUtil.newInstance(logHandlerClass, new Object[0]) : this.createLogHandler(pServletConfig, Boolean.valueOf(config.get(ConfigKey.DEBUG)));
        this.httpGetHandler = this.newGetHttpRequestHandler();
        this.httpPostHandler = this.newPostHttpRequestHandler();
        if (this.restrictor == null) {
            this.restrictor = this.createRestrictor(NetworkUtil.replaceExpression(config.get(ConfigKey.POLICY_LOCATION)));
        } else {
            this.logHandler.info("Using custom access restriction provided by " + this.restrictor);
        }
        this.configMimeType = config.get(ConfigKey.MIME_TYPE);
        this.backendManager = new BackendManager(config, this.logHandler, this.restrictor);
        this.requestHandler = new HttpRequestHandler(config, this.backendManager, this.logHandler);
        this.initDiscoveryMulticast(config);
    }

    private void initDiscoveryMulticast(Configuration pConfig) {
        String url = this.findAgentUrl(pConfig);
        if (url != null || this.listenForDiscoveryMcRequests(pConfig)) {
            this.backendManager.getAgentDetails().setUrl(url);
            try {
                this.discoveryMulticastResponder = new DiscoveryMulticastResponder(this.backendManager, this.restrictor, this.logHandler);
                this.discoveryMulticastResponder.start();
            }
            catch (IOException e) {
                this.logHandler.error("Cannot start discovery multicast handler: " + e, e);
            }
        }
    }

    private String findAgentUrl(Configuration pConfig) {
        String url = System.getProperty("jolokia." + ConfigKey.DISCOVERY_AGENT_URL.getKeyValue());
        if (url == null && (url = System.getenv("JOLOKIA_DISCOVERY_AGENT_URL")) == null) {
            url = pConfig.get(ConfigKey.DISCOVERY_AGENT_URL);
        }
        return NetworkUtil.replaceExpression(url);
    }

    private boolean listenForDiscoveryMcRequests(Configuration pConfig) {
        boolean sysProp = System.getProperty("jolokia." + ConfigKey.DISCOVERY_ENABLED.getKeyValue()) != null;
        boolean env = System.getenv("JOLOKIA_DISCOVERY") != null;
        boolean config = pConfig.getAsBoolean(ConfigKey.DISCOVERY_ENABLED);
        return sysProp || env || config;
    }

    protected LogHandler createLogHandler(ServletConfig pServletConfig, final boolean pDebug) {
        return new LogHandler(){

            public void debug(String message) {
                if (pDebug) {
                    AgentServlet.this.log(message);
                }
            }

            public void info(String message) {
                AgentServlet.this.log(message);
            }

            public void error(String message, Throwable t) {
                AgentServlet.this.log(message, t);
            }
        };
    }

    public void destroy() {
        this.backendManager.destroy();
        if (this.discoveryMulticastResponder != null) {
            this.discoveryMulticastResponder.stop();
            this.discoveryMulticastResponder = null;
        }
        super.destroy();
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.handle(this.httpGetHandler, req, resp);
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.handle(this.httpPostHandler, req, resp);
    }

    protected void doOptions(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        Map<String, String> responseHeaders = this.requestHandler.handleCorsPreflightRequest(req.getHeader("Origin"), req.getHeader("Access-Control-Request-Headers"));
        for (Map.Entry<String, String> entry : responseHeaders.entrySet()) {
            resp.setHeader(entry.getKey(), entry.getValue());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handle(ServletRequestHandler pReqHandler, HttpServletRequest pReq, HttpServletResponse pResp) throws IOException {
        String answer;
        JSONAware json = null;
        try {
            this.requestHandler.checkAccess(pReq.getRemoteHost(), pReq.getRemoteAddr(), this.getOriginOrReferer(pReq));
            this.updateAgentDetailsIfNeeded(pReq);
            json = this.handleSecurely(pReqHandler, pReq, pResp);
            this.setCorsHeader(pReq, pResp);
        }
        catch (Throwable exp) {
            String answer2;
            try {
                json = this.requestHandler.handleThrowable(exp instanceof RuntimeMBeanException ? ((RuntimeMBeanException)exp).getTargetException() : exp);
                this.setCorsHeader(pReq, pResp);
            }
            catch (Throwable throwable) {
                String answer3;
                this.setCorsHeader(pReq, pResp);
                String callback = pReq.getParameter(ConfigKey.CALLBACK.getKeyValue());
                String string = answer3 = json != null ? json.toJSONString() : this.requestHandler.handleThrowable(new Exception("Internal error while handling an exception")).toJSONString();
                if (callback != null) {
                    this.sendResponse(pResp, "text/javascript", callback + "(" + answer3 + ");");
                } else {
                    this.sendResponse(pResp, this.getMimeType(pReq), answer3);
                }
                throw throwable;
            }
            String callback = pReq.getParameter(ConfigKey.CALLBACK.getKeyValue());
            String string = answer2 = json != null ? json.toJSONString() : this.requestHandler.handleThrowable(new Exception("Internal error while handling an exception")).toJSONString();
            if (callback != null) {
                this.sendResponse(pResp, "text/javascript", callback + "(" + answer2 + ");");
            } else {
                this.sendResponse(pResp, this.getMimeType(pReq), answer2);
            }
        }
        String callback = pReq.getParameter(ConfigKey.CALLBACK.getKeyValue());
        String string = answer = json != null ? json.toJSONString() : this.requestHandler.handleThrowable(new Exception("Internal error while handling an exception")).toJSONString();
        if (callback != null) {
            this.sendResponse(pResp, "text/javascript", callback + "(" + answer + ");");
        } else {
            this.sendResponse(pResp, this.getMimeType(pReq), answer);
        }
    }

    private JSONAware handleSecurely(final ServletRequestHandler pReqHandler, final HttpServletRequest pReq, final HttpServletResponse pResp) throws IOException, PrivilegedActionException {
        Subject subject = (Subject)pReq.getAttribute("org.jolokia.jaasSubject");
        if (subject != null) {
            return Subject.doAs(subject, new PrivilegedExceptionAction<JSONAware>(){

                @Override
                public JSONAware run() throws IOException {
                    return pReqHandler.handleRequest(pReq, pResp);
                }
            });
        }
        return pReqHandler.handleRequest(pReq, pResp);
    }

    private String getOriginOrReferer(HttpServletRequest pReq) {
        String origin = pReq.getHeader("Origin");
        if (origin == null) {
            origin = pReq.getHeader("Referer");
        }
        return origin != null ? origin.replaceAll("[\\n\\r]*", "") : null;
    }

    private void updateAgentDetailsIfNeeded(HttpServletRequest pReq) {
        AgentDetails details = this.backendManager.getAgentDetails();
        if (details.isInitRequired()) {
            if (details.isUrlMissing()) {
                String url = this.getBaseUrl(NetworkUtil.sanitizeLocalUrl(pReq.getRequestURL().toString()), this.extractServletPath(pReq));
                details.setUrl(url);
            }
            if (details.isSecuredMissing()) {
                details.setSecured(pReq.getAuthType() != null);
            }
            details.seal();
        }
    }

    private String extractServletPath(HttpServletRequest pReq) {
        return pReq.getRequestURI().substring(0, pReq.getContextPath().length());
    }

    private String getBaseUrl(String pUrl, String pServletPath) {
        String sUrl;
        try {
            URL url = new URL(pUrl);
            String host = this.getIpIfPossible(url.getHost());
            sUrl = new URL(url.getProtocol(), host, url.getPort(), pServletPath).toExternalForm();
        }
        catch (MalformedURLException exp) {
            sUrl = this.plainReplacement(pUrl, pServletPath);
        }
        return sUrl;
    }

    private String getIpIfPossible(String pHost) {
        try {
            InetAddress address = InetAddress.getByName(pHost);
            return address.getHostAddress();
        }
        catch (UnknownHostException e) {
            return pHost;
        }
    }

    private String plainReplacement(String pUrl, String pServletPath) {
        int idx = pUrl.lastIndexOf(pServletPath);
        String url = idx != -1 ? pUrl.substring(0, idx) + pServletPath : pUrl;
        return url;
    }

    private void setCorsHeader(HttpServletRequest pReq, HttpServletResponse pResp) {
        String origin = this.requestHandler.extractCorsOrigin(pReq.getHeader("Origin"));
        if (origin != null) {
            pResp.setHeader("Access-Control-Allow-Origin", origin);
            pResp.setHeader("Access-Control-Allow-Credentials", "true");
        }
    }

    private String getMimeType(HttpServletRequest pReq) {
        String requestMimeType = pReq.getParameter(ConfigKey.MIME_TYPE.getKeyValue());
        if (requestMimeType != null) {
            return requestMimeType;
        }
        return this.configMimeType;
    }

    private ServletRequestHandler newPostHttpRequestHandler() {
        return new ServletRequestHandler(){

            public JSONAware handleRequest(HttpServletRequest pReq, HttpServletResponse pResp) throws IOException {
                String encoding = pReq.getCharacterEncoding();
                ServletInputStream is = pReq.getInputStream();
                return AgentServlet.this.requestHandler.handlePostRequest(pReq.getRequestURI(), (InputStream)is, encoding, AgentServlet.this.getParameterMap(pReq));
            }
        };
    }

    private ServletRequestHandler newGetHttpRequestHandler() {
        return new ServletRequestHandler(){

            public JSONAware handleRequest(HttpServletRequest pReq, HttpServletResponse pResp) {
                return AgentServlet.this.requestHandler.handleGetRequest(pReq.getRequestURI(), pReq.getPathInfo(), AgentServlet.this.getParameterMap(pReq));
            }
        };
    }

    private Map<String, String[]> getParameterMap(HttpServletRequest pReq) {
        try {
            return pReq.getParameterMap();
        }
        catch (UnsupportedOperationException exp) {
            HashMap<String, String[]> ret = new HashMap<String, String[]>();
            Enumeration params = pReq.getParameterNames();
            while (params.hasMoreElements()) {
                String param = (String)params.nextElement();
                ret.put(param, pReq.getParameterValues(param));
            }
            return ret;
        }
    }

    Configuration initConfig(ServletConfig pConfig) {
        Configuration config = new Configuration(new Object[]{ConfigKey.AGENT_ID, NetworkUtil.getAgentId(((Object)((Object)this)).hashCode(), "servlet")});
        config.updateGlobalConfiguration(new ServletConfigFacade(pConfig));
        config.updateGlobalConfiguration(new ServletContextFacade(this.getServletContext()));
        config.updateGlobalConfiguration(Collections.singletonMap(ConfigKey.AGENT_TYPE.getKeyValue(), "servlet"));
        return config;
    }

    private void sendResponse(HttpServletResponse pResp, String pContentType, String pJsonTxt) throws IOException {
        this.setContentType(pResp, pContentType);
        pResp.setStatus(200);
        this.setNoCacheHeaders(pResp);
        PrintWriter writer = pResp.getWriter();
        writer.write(pJsonTxt);
    }

    private void setNoCacheHeaders(HttpServletResponse pResp) {
        pResp.setHeader("Cache-Control", "no-cache");
        pResp.setHeader("Pragma", "no-cache");
        long now = System.currentTimeMillis();
        pResp.setDateHeader("Date", now);
        pResp.setDateHeader("Expires", now - 3600000L);
    }

    private void setContentType(HttpServletResponse pResp, String pContentType) {
        boolean encodingDone = false;
        try {
            pResp.setCharacterEncoding("utf-8");
            pResp.setContentType(pContentType);
            encodingDone = true;
        }
        catch (NoSuchMethodError noSuchMethodError) {
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        if (!encodingDone) {
            pResp.setContentType(pContentType + "; charset=utf-8");
        }
    }

    private static final class ServletContextFacade
    implements ConfigExtractor {
        private final ServletContext servletContext;

        private ServletContextFacade(ServletContext pServletContext) {
            this.servletContext = pServletContext;
        }

        public Enumeration getNames() {
            return this.servletContext.getInitParameterNames();
        }

        public String getParameter(String pName) {
            return this.servletContext.getInitParameter(pName);
        }
    }

    private static final class ServletConfigFacade
    implements ConfigExtractor {
        private final ServletConfig config;

        private ServletConfigFacade(ServletConfig pConfig) {
            this.config = pConfig;
        }

        public Enumeration getNames() {
            return this.config.getInitParameterNames();
        }

        public String getParameter(String pName) {
            return this.config.getInitParameter(pName);
        }
    }

    private static interface ServletRequestHandler {
        public JSONAware handleRequest(HttpServletRequest var1, HttpServletResponse var2) throws IOException;
    }
}

