/*
 * Decompiled with CFR 0.152.
 */
package org.jolokia.jvmagent;

import com.sun.net.httpserver.Authenticator;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.jolokia.config.ConfigKey;
import org.jolokia.config.Configuration;
import org.jolokia.jvmagent.security.DelegatingAuthenticator;
import org.jolokia.jvmagent.security.JaasAuthenticator;
import org.jolokia.jvmagent.security.UserPasswordAuthenticator;
import org.jolokia.util.NetworkUtil;

public class JolokiaServerConfig {
    private Configuration jolokiaConfig;
    private String protocol;
    private int port;
    private int backlog;
    private InetAddress address;
    private String executor;
    private int threadNr;
    private String keystore;
    private String context;
    private boolean useSslClientAuthentication;
    private char[] keystorePassword;
    private Authenticator authenticator;
    private String secureSocketProtocol;
    private String keyManagerAlgorithm;
    private String trustManagerAlgorithm;
    private String keyStoreType;
    private String caCert;
    private String serverCert;
    private String serverKey;
    private String serverKeyAlgorithm;
    private List<String> clientPrincipals;
    private boolean extendedClientCheck;

    public JolokiaServerConfig(Map<String, String> pConfig) {
        this.init(pConfig);
    }

    protected void init(Map<String, String> pConfig) {
        Map<String, String> finalCfg = this.getDefaultConfig(pConfig);
        finalCfg.putAll(pConfig);
        this.prepareDetectorOptions(finalCfg);
        this.addJolokiaId(finalCfg);
        this.jolokiaConfig = new Configuration(new Object[0]);
        this.jolokiaConfig.updateGlobalConfiguration(finalCfg);
        this.initConfigAndValidate(finalCfg);
    }

    private void addJolokiaId(Map<String, String> pFinalCfg) {
        if (!pFinalCfg.containsKey(ConfigKey.AGENT_ID.getKeyValue())) {
            pFinalCfg.put(ConfigKey.AGENT_ID.getKeyValue(), NetworkUtil.getAgentId(this.hashCode(), "jvm"));
        }
        pFinalCfg.put(ConfigKey.AGENT_TYPE.getKeyValue(), "jvm");
    }

    protected Map<String, String> getDefaultConfig(Map<String, String> pConfig) {
        InputStream is = this.getClass().getResourceAsStream("/default-jolokia-agent.properties");
        return this.readPropertiesFromInputStream(is, "default-jolokia-agent.properties");
    }

    public Configuration getJolokiaConfig() {
        return this.jolokiaConfig;
    }

    public String getProtocol() {
        return this.protocol;
    }

    public InetAddress getAddress() {
        return this.address;
    }

    public int getPort() {
        return this.port;
    }

    public Authenticator getAuthenticator() {
        return this.authenticator;
    }

    public int getBacklog() {
        return this.backlog;
    }

    public String getContextPath() {
        return this.context;
    }

    public String getExecutor() {
        return this.executor;
    }

    public int getThreadNr() {
        return this.threadNr;
    }

    public boolean useSslClientAuthentication() {
        return this.useSslClientAuthentication;
    }

    public String getKeystore() {
        return this.keystore;
    }

    public char[] getKeystorePassword() {
        return this.keystorePassword;
    }

    public String getCaCert() {
        return this.caCert;
    }

    public String getServerCert() {
        return this.serverCert;
    }

    public String getServerKey() {
        return this.serverKey;
    }

    public String getServerKeyAlgorithm() {
        return this.serverKeyAlgorithm;
    }

    protected void initConfigAndValidate(Map<String, String> agentConfig) {
        this.initContext();
        this.initAuthenticator();
        this.initProtocol(agentConfig);
        this.initAddress(agentConfig);
        this.port = Integer.parseInt(agentConfig.get("port"));
        this.backlog = Integer.parseInt(agentConfig.get("backlog"));
        this.initExecutor(agentConfig);
        this.initThreadNr(agentConfig);
        this.initHttpsRelatedSettings(agentConfig);
    }

    private void initAuthenticator() {
        this.initCustomAuthenticator();
        if (this.authenticator == null) {
            this.initAuthenticatorFromAuthMode();
        }
    }

    private void initCustomAuthenticator() {
        String authenticatorClass = this.jolokiaConfig.get(ConfigKey.AUTH_CLASS);
        if (authenticatorClass != null) {
            try {
                Class<?> authClass = Class.forName(authenticatorClass);
                if (!Authenticator.class.isAssignableFrom(authClass)) {
                    throw new IllegalArgumentException("Provided authenticator class [" + authenticatorClass + "] is not a subclass of Authenticator");
                }
                this.lookupAuthenticator(authClass);
            }
            catch (ClassNotFoundException e) {
                throw new IllegalArgumentException("Cannot find authenticator class", e);
            }
        }
    }

    private void lookupAuthenticator(Class pAuthClass) {
        try {
            try {
                Constructor constructorThatTakesConfiguration = pAuthClass.getConstructor(Configuration.class);
                this.authenticator = (Authenticator)constructorThatTakesConfiguration.newInstance(this.jolokiaConfig);
            }
            catch (NoSuchMethodException ignore) {
                this.authenticator = this.lookupAuthenticatorWithDefaultConstructor(pAuthClass, ignore);
            }
            catch (InvocationTargetException e) {
                throw new IllegalArgumentException("Cannot create an instance of custom authenticator class with configuration", e);
            }
        }
        catch (InstantiationException e) {
            throw new IllegalArgumentException("Cannot create an instance of custom authenticator class", e);
        }
        catch (IllegalAccessException e) {
            throw new IllegalArgumentException("Cannot create an instance of custom authenticator class", e);
        }
    }

    private Authenticator lookupAuthenticatorWithDefaultConstructor(Class pAuthClass, NoSuchMethodException ignore) throws InstantiationException, IllegalAccessException {
        try {
            Constructor defaultConstructor = pAuthClass.getConstructor(new Class[0]);
            return (Authenticator)defaultConstructor.newInstance(new Object[0]);
        }
        catch (NoSuchMethodException e) {
            e.initCause(ignore);
            throw new IllegalArgumentException("Cannot create an instance of custom authenticator class, no default constructor to use", e);
        }
        catch (InvocationTargetException e) {
            e.initCause(ignore);
            throw new IllegalArgumentException("Cannot create an instance of custom authenticator using default constructor", e);
        }
    }

    private void initAuthenticatorFromAuthMode() {
        String user = this.jolokiaConfig.get(ConfigKey.USER);
        String password = this.jolokiaConfig.get(ConfigKey.PASSWORD);
        String authMode = this.jolokiaConfig.get(ConfigKey.AUTH_MODE);
        String realm = this.jolokiaConfig.get(ConfigKey.REALM);
        if ("basic".equalsIgnoreCase(authMode)) {
            if (user != null) {
                if (password == null) {
                    throw new IllegalArgumentException("'password' must be set if a 'user' (here: '" + user + "') is given");
                }
                this.authenticator = new UserPasswordAuthenticator(realm, user, password);
            } else {
                this.authenticator = null;
            }
        } else if ("jaas".equalsIgnoreCase(authMode)) {
            this.authenticator = new JaasAuthenticator(realm);
        } else if ("delegate".equalsIgnoreCase(authMode)) {
            this.authenticator = new DelegatingAuthenticator(realm, this.jolokiaConfig.get(ConfigKey.AUTH_URL), this.jolokiaConfig.get(ConfigKey.AUTH_PRINCIPAL_SPEC), this.jolokiaConfig.getAsBoolean(ConfigKey.AUTH_IGNORE_CERTS));
        } else {
            throw new IllegalArgumentException("No auth method '" + authMode + "' known. " + "Must be either 'basic' or 'jaas'");
        }
    }

    private void initProtocol(Map<String, String> agentConfig) {
        String string = this.protocol = agentConfig.containsKey("protocol") ? agentConfig.get("protocol") : "http";
        if (!this.protocol.equals("http") && !this.protocol.equals("https")) {
            throw new IllegalArgumentException("Invalid protocol '" + this.protocol + "'. Must be either 'http' or 'https'");
        }
    }

    private void initContext() {
        this.context = this.jolokiaConfig.get(ConfigKey.AGENT_CONTEXT);
        if (this.context == null) {
            this.context = ConfigKey.AGENT_CONTEXT.getDefaultValue();
        }
        if (!this.context.endsWith("/")) {
            this.context = this.context + "/";
        }
    }

    private void initHttpsRelatedSettings(Map<String, String> agentConfig) {
        this.keystore = agentConfig.get("keystore");
        this.caCert = agentConfig.get("caCert");
        this.serverCert = agentConfig.get("serverCert");
        this.serverKey = agentConfig.get("serverKey");
        this.secureSocketProtocol = agentConfig.get("secureSocketProtocol");
        this.keyStoreType = agentConfig.get("keyStoreType");
        this.keyManagerAlgorithm = agentConfig.get("keyManagerAlgorithm");
        this.trustManagerAlgorithm = agentConfig.get("trustManagerAlgorithm");
        String auth = agentConfig.get("useSslClientAuthentication");
        this.useSslClientAuthentication = auth != null && Boolean.valueOf(auth) != false;
        String password = agentConfig.get("keystorePassword");
        this.keystorePassword = password != null ? password.toCharArray() : new char[]{};
        this.serverKeyAlgorithm = agentConfig.get("serverKeyAlgorithm");
        this.clientPrincipals = this.extractList(agentConfig, "clientPrincipal");
        String xCheck = agentConfig.get("extendedClientCheck");
        this.extendedClientCheck = xCheck != null && Boolean.valueOf(xCheck) != false;
    }

    private List<String> extractList(Map<String, String> pAgentConfig, String pKey) {
        ArrayList<String> ret = new ArrayList<String>();
        if (pAgentConfig.containsKey(pKey)) {
            ret.add(pAgentConfig.get(pKey));
        }
        int idx = 1;
        String keyIdx = pKey + "." + idx;
        while (pAgentConfig.containsKey(keyIdx)) {
            ret.add(pAgentConfig.get(keyIdx));
            keyIdx = pKey + "." + ++idx;
        }
        return ret.size() > 0 ? ret : null;
    }

    private void initThreadNr(Map<String, String> pAgentConfig) {
        String threadNrS = pAgentConfig.get("threadNr");
        this.threadNr = threadNrS != null ? Integer.parseInt(threadNrS) : 5;
    }

    private void initExecutor(Map<String, String> agentConfig) {
        String string = this.executor = agentConfig.containsKey("executor") ? agentConfig.get("executor") : "single";
        if (!("single".equalsIgnoreCase(this.executor) || "fixed".equalsIgnoreCase(this.executor) || "cached".equalsIgnoreCase(this.executor))) {
            throw new IllegalArgumentException("Executor model can be '" + this.executor + "' but most be either 'single', 'fixed' or 'cached'");
        }
    }

    private void initAddress(Map<String, String> agentConfig) {
        String host = agentConfig.get("host");
        try {
            this.address = "*".equals(host) || "0.0.0.0".equals(host) ? null : (host != null ? InetAddress.getByName(host) : InetAddress.getByName(null));
        }
        catch (UnknownHostException e) {
            throw new IllegalArgumentException("Can not lookup " + (host != null ? host : "loopback interface") + ": " + e, e);
        }
    }

    protected Map<String, String> readPropertiesFromInputStream(InputStream pIs, String pLabel) {
        HashMap<String, String> ret = new HashMap<String, String>();
        if (pIs == null) {
            return ret;
        }
        Properties props = new Properties();
        try {
            props.load(pIs);
            ret.putAll(props);
        }
        catch (IOException e) {
            throw new IllegalArgumentException("jolokia: Cannot load properties " + pLabel + " : " + e, e);
        }
        return ret;
    }

    protected void prepareDetectorOptions(Map<String, String> pConfig) {
        StringBuffer detectorOpts = new StringBuffer("{");
        if (pConfig.containsKey("bootAmx") && Boolean.parseBoolean(pConfig.get("bootAmx"))) {
            detectorOpts.append("\"glassfish\" : { \"bootAmx\" : true }");
        }
        if (detectorOpts.length() > 1) {
            detectorOpts.append("}");
            pConfig.put(ConfigKey.DETECTOR_OPTIONS.getKeyValue(), detectorOpts.toString());
        }
    }

    public String getSecureSocketProtocol() {
        return this.secureSocketProtocol;
    }

    public String getKeyManagerAlgorithm() {
        return this.keyManagerAlgorithm;
    }

    public String getTrustManagerAlgorithm() {
        return this.trustManagerAlgorithm;
    }

    public String getKeyStoreType() {
        return this.keyStoreType;
    }

    public List<String> getClientPrincipals() {
        return this.clientPrincipals;
    }

    public boolean getExtendedClientCheck() {
        return this.extendedClientCheck;
    }
}

