/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.io.fabric8.workflow.build.trigger;

import io.fabric8.io.fabric8.workflow.build.BuildCorrelationKey;
import io.fabric8.io.fabric8.workflow.build.correlate.BuildProcessCorrelator;
import io.fabric8.io.fabric8.workflow.build.correlate.BuildProcessCorrelators;
import io.fabric8.io.fabric8.workflow.build.trigger.BuildTrigger;
import io.fabric8.io.fabric8.workflow.build.trigger.BuildTriggers;
import io.fabric8.io.fabric8.workflow.build.trigger.WorkItemHandlers;
import io.fabric8.utils.Strings;
import org.kie.api.runtime.process.WorkItem;
import org.kie.api.runtime.process.WorkItemHandler;
import org.kie.api.runtime.process.WorkItemManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BuildWorkItemHandler
implements WorkItemHandler {
    private static final transient Logger LOG = LoggerFactory.getLogger(BuildWorkItemHandler.class);
    private BuildProcessCorrelator buildProcessCorrelator = BuildProcessCorrelators.getSingleton();
    private BuildTrigger buildTrigger = BuildTriggers.getSingleton();

    public void executeWorkItem(WorkItem workItem, WorkItemManager manager) {
        long processInstanceId = workItem.getProcessInstanceId();
        long workItemId = workItem.getId();
        String namespace = WorkItemHandlers.getMandatoryParameter(workItem, manager, "namespace");
        String buildName = WorkItemHandlers.getMandatoryParameter(workItem, manager, "buildName");
        LOG.info("Executing build: " + namespace + "/" + buildName + " processInstanceId: " + processInstanceId + " workItemId: " + workItemId);
        String buildUuid = null;
        try {
            buildUuid = this.triggerBuild(processInstanceId, workItemId, namespace, buildName);
        }
        catch (Exception e) {
            WorkItemHandlers.fail(workItem, manager, "Could not trigger build for namespace: " + namespace + " build: " + buildName, e);
            return;
        }
        if (Strings.isNullOrBlank((String)buildUuid)) {
            WorkItemHandlers.fail(workItem, manager, "Could not trigger build for namespace: " + namespace + " build: " + buildName);
        }
    }

    public String triggerBuild(long processInstanceId, long workItemId, String namespace, String buildName) {
        String buildUuid = this.buildTrigger.trigger(namespace, buildName);
        LOG.info("Created " + buildUuid + " from build: " + namespace + "/" + buildName + " processInstanceId: " + processInstanceId + " workItemId: " + workItemId);
        if (Strings.isNotBlank((String)buildUuid)) {
            BuildCorrelationKey key = new BuildCorrelationKey(namespace, buildName, buildUuid);
            this.buildProcessCorrelator.putBuildWorkItemId(key, workItemId);
        }
        return buildUuid;
    }

    public void abortWorkItem(WorkItem workItem, WorkItemManager manager) {
        System.out.println("Aborting " + workItem.getParameter("BuildId"));
    }

    public BuildTrigger getBuildTrigger() {
        return this.buildTrigger;
    }

    public void setBuildTrigger(BuildTrigger buildTrigger) {
        this.buildTrigger = buildTrigger;
    }

    public BuildProcessCorrelator getBuildProcessCorrelator() {
        return this.buildProcessCorrelator;
    }

    public void setBuildProcessCorrelator(BuildProcessCorrelator buildProcessCorrelator) {
        this.buildProcessCorrelator = buildProcessCorrelator;
    }
}

