/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.maven.enricher.standard;

import io.fabric8.ianaservicehelper.Helper;
import io.fabric8.kubernetes.api.builder.TypedVisitor;
import io.fabric8.kubernetes.api.builder.Visitor;
import io.fabric8.kubernetes.api.model.ContainerPortBuilder;
import io.fabric8.kubernetes.api.model.KubernetesListBuilder;
import io.fabric8.maven.enricher.api.BaseEnricher;
import io.fabric8.maven.enricher.api.EnricherContext;
import java.io.IOException;
import java.util.Set;

public class IANAServicePortNameEnricher
extends BaseEnricher {
    public IANAServicePortNameEnricher(EnricherContext buildContext) {
        super(buildContext, "fmp-ianaservice");
    }

    public void addMissingResources(KubernetesListBuilder builder) {
        builder.accept((Visitor)new TypedVisitor<ContainerPortBuilder>(){

            public void visit(ContainerPortBuilder builder) {
                if (builder.getContainerPort() != null && (builder.getName() == null || builder.getName().isEmpty())) {
                    String protocol = builder.getProtocol();
                    if (protocol == null || protocol.isEmpty()) {
                        protocol = "tcp";
                    }
                    try {
                        Set sn = Helper.serviceNames((int)builder.getContainerPort(), (String)protocol.toLowerCase());
                        if (sn != null && !sn.isEmpty()) {
                            String serviceName = (String)sn.iterator().next();
                            IANAServicePortNameEnricher.this.log.info("Adding port name %s", new Object[]{serviceName});
                            builder.withName(serviceName);
                        }
                    }
                    catch (IOException e) {
                        IANAServicePortNameEnricher.this.log.warn("Failed to find service names for port %d/%s : %s", new Object[]{builder.getContainerPort(), protocol.toLowerCase(), e.getMessage()});
                    }
                }
            }
        });
    }
}

