/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.maven.enricher.standard;

import io.fabric8.kubernetes.api.builder.TypedVisitor;
import io.fabric8.kubernetes.api.builder.Visitor;
import io.fabric8.kubernetes.api.model.ContainerPortBuilder;
import io.fabric8.kubernetes.api.model.KubernetesListBuilder;
import io.fabric8.maven.enricher.api.BaseEnricher;
import io.fabric8.maven.enricher.api.EnricherContext;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class PortNameEnricher
extends BaseEnricher {
    public static final Map<Integer, String> DEFAULT_PORT_MAPPING;

    public PortNameEnricher(EnricherContext buildContext) {
        super(buildContext, "fmp-portname");
    }

    public void addMissingResources(KubernetesListBuilder builder) {
        builder.accept((Visitor)new TypedVisitor<ContainerPortBuilder>(){

            public void visit(ContainerPortBuilder builder) {
                String serviceName;
                if (builder.getContainerPort() != null && (builder.getName() == null || builder.getName().isEmpty()) && (serviceName = DEFAULT_PORT_MAPPING.get(builder.getContainerPort())) != null && !serviceName.isEmpty()) {
                    PortNameEnricher.this.log.info("Adding port name " + serviceName, new Object[0]);
                    builder.withName(serviceName);
                }
            }
        });
    }

    static {
        HashMap<Integer, String> temp = new HashMap<Integer, String>();
        temp.put(8080, "http");
        temp.put(8443, "https");
        temp.put(8778, "jolokia");
        temp.put(9779, "prometheus");
        DEFAULT_PORT_MAPPING = Collections.unmodifiableMap(temp);
    }
}

