/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.maven.enricher.standard;

import io.fabric8.kubernetes.api.builder.TypedVisitor;
import io.fabric8.kubernetes.api.builder.Visitor;
import io.fabric8.kubernetes.api.model.KubernetesListBuilder;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;
import io.fabric8.maven.core.util.KubernetesResourceUtil;
import io.fabric8.maven.core.util.MapUtil;
import io.fabric8.maven.enricher.api.BaseEnricher;
import io.fabric8.maven.enricher.api.EnricherContext;
import io.fabric8.maven.enricher.api.Kind;
import java.util.HashMap;
import java.util.Map;
import org.apache.maven.project.MavenProject;

public class ProjectEnricher
extends BaseEnricher {
    public ProjectEnricher(EnricherContext buildContext) {
        super(buildContext, "fmp-project");
    }

    public Map<String, String> getSelector(Kind kind) {
        Map<String, String> ret = this.createLabels();
        if (kind == Kind.SERVICE || kind == Kind.DEPLOYMENT || kind == Kind.DEPLOYMENT_CONFIG) {
            return KubernetesResourceUtil.removeVersionSelector(ret);
        }
        return ret;
    }

    public void adapt(KubernetesListBuilder builder) {
        builder.accept((Visitor)new TypedVisitor<ObjectMetaBuilder>(){

            public void visit(ObjectMetaBuilder element) {
                Map labels = element.getLabels();
                MavenProject project = ProjectEnricher.this.getProject();
                MapUtil.mergeIfAbsent((Map)labels, ProjectEnricher.this.createLabels());
            }
        });
    }

    Map<String, String> createLabels() {
        MavenProject project = this.getProject();
        HashMap<String, String> ret = new HashMap<String, String>();
        ret.put("version", project.getVersion());
        ret.put("project", project.getArtifactId());
        ret.put("group", project.getGroupId());
        ret.put("provider", "fabric8");
        return ret;
    }
}

