/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.maven.enricher.standard;

import io.fabric8.kubernetes.api.builder.TypedVisitor;
import io.fabric8.kubernetes.api.builder.Visitor;
import io.fabric8.kubernetes.api.model.KubernetesListBuilder;
import io.fabric8.kubernetes.api.model.PodSpec;
import io.fabric8.kubernetes.api.model.PodSpecBuilder;
import io.fabric8.kubernetes.api.model.PodTemplateSpec;
import io.fabric8.kubernetes.api.model.ReplicationController;
import io.fabric8.kubernetes.api.model.extensions.Deployment;
import io.fabric8.kubernetes.api.model.extensions.DeploymentBuilder;
import io.fabric8.kubernetes.api.model.extensions.DeploymentFluent;
import io.fabric8.kubernetes.api.model.extensions.DeploymentSpec;
import io.fabric8.kubernetes.api.model.extensions.DeploymentSpecFluent;
import io.fabric8.kubernetes.api.model.extensions.ReplicaSet;
import io.fabric8.maven.core.config.ResourceConfig;
import io.fabric8.maven.core.handler.DeploymentHandler;
import io.fabric8.maven.core.handler.HandlerHub;
import io.fabric8.maven.core.handler.ReplicaSetHandler;
import io.fabric8.maven.core.handler.ReplicationControllerHandler;
import io.fabric8.maven.core.util.Configs;
import io.fabric8.maven.core.util.KubernetesResourceUtil;
import io.fabric8.maven.core.util.MavenUtil;
import io.fabric8.maven.enricher.api.BaseEnricher;
import io.fabric8.maven.enricher.api.EnricherContext;
import io.fabric8.utils.Lists;
import java.util.List;
import org.apache.maven.project.MavenProject;

public class DefaultControllerEnricher
extends BaseEnricher {
    protected static final String[] POD_CONTROLLER_KINDS = new String[]{"ReplicationController", "ReplicaSet", "Deployment", "DeploymentConfig"};
    private final DeploymentHandler deployHandler;
    private final ReplicationControllerHandler rcHandler;
    private final ReplicaSetHandler rsHandler;

    public DefaultControllerEnricher(EnricherContext buildContext) {
        super(buildContext, "fmp-controller");
        HandlerHub handlers = new HandlerHub(buildContext.getProject());
        this.rcHandler = handlers.getReplicationControllerHandler();
        this.rsHandler = handlers.getReplicaSetHandler();
        this.deployHandler = handlers.getDeploymentHandler();
    }

    public void addMissingResources(KubernetesListBuilder builder) {
        final String name = this.getConfig(Config.name, MavenUtil.createDefaultResourceName((MavenProject)this.getProject(), (String[])new String[0]));
        ResourceConfig config = new ResourceConfig.Builder().replicaSetName(name).imagePullPolicy(this.getConfig(Config.pullPolicy)).build();
        List images = this.getImages();
        Deployment defaultDeployment = this.deployHandler.getDeployment(config, images);
        if (!KubernetesResourceUtil.checkForKind((KubernetesListBuilder)builder, (String[])POD_CONTROLLER_KINDS)) {
            if (!Lists.isNullOrEmpty((List)images)) {
                String type = this.getConfig(Config.type);
                if (type.equalsIgnoreCase("deployment")) {
                    this.log.info("Adding a default Deployment", new Object[0]);
                    builder.addToDeploymentItems(new Deployment[]{defaultDeployment});
                } else if (type.equalsIgnoreCase("replicaSet")) {
                    this.log.info("Adding a default ReplicaSet", new Object[0]);
                    builder.addToReplicaSetItems(new ReplicaSet[]{this.rsHandler.getReplicaSet(config, images)});
                } else if (type.equalsIgnoreCase("replicationController")) {
                    this.log.info("Adding a default ReplicationController", new Object[0]);
                    builder.addToReplicationControllerItems(new ReplicationController[]{this.rcHandler.getReplicationController(config, images)});
                }
            }
        } else {
            PodSpec podSpec;
            PodTemplateSpec template;
            final DeploymentSpec spec = defaultDeployment.getSpec();
            if (spec != null && (template = spec.getTemplate()) != null && (podSpec = template.getSpec()) != null) {
                builder.accept((Visitor)new TypedVisitor<PodSpecBuilder>(){

                    public void visit(PodSpecBuilder builder) {
                        KubernetesResourceUtil.mergePodSpec((PodSpecBuilder)builder, (PodSpec)podSpec, (String)name);
                    }
                });
                builder.accept((Visitor)new TypedVisitor<DeploymentBuilder>(){

                    public void visit(DeploymentBuilder builder) {
                        DeploymentSpec deploymentSpec = builder.getSpec();
                        if (deploymentSpec == null) {
                            builder.withNewSpec().endSpec();
                            deploymentSpec = builder.getSpec();
                        }
                        DefaultControllerEnricher.this.mergeDeploymentSpec(builder, spec);
                        PodTemplateSpec template = deploymentSpec.getTemplate();
                        DeploymentFluent.SpecNested specBuilder = builder.editSpec();
                        if (template == null) {
                            ((DeploymentFluent.SpecNested)((DeploymentSpecFluent.TemplateNested)specBuilder.withNewTemplate().withNewSpecLike(podSpec).endSpec()).endTemplate()).endSpec();
                        } else {
                            PodSpec builderSpec = template.getSpec();
                            if (builderSpec == null) {
                                ((DeploymentFluent.SpecNested)((DeploymentSpecFluent.TemplateNested)specBuilder.editTemplate().withNewSpecLike(podSpec).endSpec()).endTemplate()).endSpec();
                            } else {
                                PodSpecBuilder podSpecBuilder = new PodSpecBuilder(builderSpec);
                                KubernetesResourceUtil.mergePodSpec((PodSpecBuilder)podSpecBuilder, (PodSpec)podSpec, (String)name);
                            }
                        }
                    }
                });
            }
        }
    }

    private void mergeDeploymentSpec(DeploymentBuilder builder, DeploymentSpec spec) {
        DeploymentFluent.SpecNested specBuilder = builder.editSpec();
        KubernetesResourceUtil.mergeSimpleFields((Object)specBuilder, (Object)spec);
        specBuilder.endSpec();
    }

    static {
        KubernetesResourceUtil.SIMPLE_FIELD_TYPES.add(String.class);
        KubernetesResourceUtil.SIMPLE_FIELD_TYPES.add(Double.class);
        KubernetesResourceUtil.SIMPLE_FIELD_TYPES.add(Float.class);
        KubernetesResourceUtil.SIMPLE_FIELD_TYPES.add(Long.class);
        KubernetesResourceUtil.SIMPLE_FIELD_TYPES.add(Integer.class);
        KubernetesResourceUtil.SIMPLE_FIELD_TYPES.add(Short.class);
        KubernetesResourceUtil.SIMPLE_FIELD_TYPES.add(Character.class);
        KubernetesResourceUtil.SIMPLE_FIELD_TYPES.add(Byte.class);
        KubernetesResourceUtil.SIMPLE_FIELD_TYPES.add(Double.TYPE);
        KubernetesResourceUtil.SIMPLE_FIELD_TYPES.add(Float.TYPE);
        KubernetesResourceUtil.SIMPLE_FIELD_TYPES.add(Long.TYPE);
        KubernetesResourceUtil.SIMPLE_FIELD_TYPES.add(Integer.TYPE);
        KubernetesResourceUtil.SIMPLE_FIELD_TYPES.add(Short.TYPE);
        KubernetesResourceUtil.SIMPLE_FIELD_TYPES.add(Character.TYPE);
        KubernetesResourceUtil.SIMPLE_FIELD_TYPES.add(Byte.TYPE);
    }

    private static enum Config implements Configs.Key
    {
        name,
        pullPolicy{
            {
                this.d = "IfNotPresent";
            }
        }
        ,
        type{
            {
                this.d = "deployment";
            }
        };

        protected String d;

        public String def() {
            return this.d;
        }
    }
}

