/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.maven.enricher.standard;

import io.fabric8.kubernetes.api.KubernetesHelper;
import io.fabric8.kubernetes.api.model.Container;
import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.KubernetesListBuilder;
import io.fabric8.kubernetes.api.model.PodSpec;
import io.fabric8.kubernetes.api.model.PodSpecBuilder;
import io.fabric8.kubernetes.api.model.PodTemplateSpec;
import io.fabric8.kubernetes.api.model.extensions.Deployment;
import io.fabric8.kubernetes.api.model.extensions.DeploymentSpec;
import io.fabric8.maven.core.util.Configs;
import io.fabric8.maven.core.util.KubernetesResourceUtil;
import io.fabric8.maven.enricher.api.BaseEnricher;
import io.fabric8.maven.enricher.api.EnricherContext;
import io.fabric8.utils.Lists;
import io.fabric8.utils.Strings;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.maven.plugin.MojoExecutionException;

public class MergeEnricher
extends BaseEnricher {
    public MergeEnricher(EnricherContext buildContext) {
        super(buildContext, "fmp-merge");
    }

    public void adapt(KubernetesListBuilder builder) {
        List items = Lists.notNullList((List)builder.getItems());
        HashMap kindMaps = new HashMap();
        ArrayList<HasMetadata> removeList = new ArrayList<HasMetadata>();
        for (HasMetadata item : items) {
            HasMetadata old;
            String kind = KubernetesHelper.getKind((HasMetadata)item);
            String name = KubernetesHelper.getName((HasMetadata)item);
            HashMap<String, HasMetadata> map = (HashMap<String, HasMetadata>)kindMaps.get(kind);
            if (map == null) {
                map = new HashMap<String, HasMetadata>();
                kindMaps.put(kind, map);
            }
            if ((old = (HasMetadata)map.get(name)) != null) {
                HasMetadata removeItem = this.mergeEntities(old, item);
                if (removeItem == null) continue;
                removeList.add(removeItem);
                continue;
            }
            map.put(name, item);
        }
        items.removeAll(removeList);
        builder.withItems(items);
    }

    private HasMetadata mergeEntities(HasMetadata item1, HasMetadata item2) {
        if (this.isMergeEnabled() && item1 instanceof Deployment && item2 instanceof Deployment) {
            HasMetadata answer = item1;
            Deployment resource1 = (Deployment)item1;
            Deployment resource2 = (Deployment)item2;
            DeploymentSpec spec1 = resource1.getSpec();
            DeploymentSpec spec2 = resource2.getSpec();
            if (spec1 == null) {
                resource1.setSpec(spec2);
            } else {
                PodTemplateSpec template1 = spec1.getTemplate();
                PodTemplateSpec template2 = spec2.getTemplate();
                if (template1 == null) {
                    spec1.setTemplate(template2);
                } else {
                    PodSpec podSpec1 = template1.getSpec();
                    PodSpec podSpec2 = template2.getSpec();
                    if (podSpec1 == null) {
                        template1.setSpec(podSpec2);
                    } else {
                        String defaultName = null;
                        PodTemplateSpec updateTemplate = template1;
                        if (this.isLocalCustomisation(podSpec1)) {
                            updateTemplate = template2;
                            PodSpec tmp = podSpec1;
                            podSpec1 = podSpec2;
                            podSpec2 = tmp;
                        } else {
                            answer = item2;
                        }
                        PodSpecBuilder podSpecBuilder = new PodSpecBuilder(podSpec1);
                        KubernetesResourceUtil.mergePodSpec((PodSpecBuilder)podSpecBuilder, (PodSpec)podSpec2, defaultName);
                        updateTemplate.setSpec(podSpecBuilder.build());
                        return answer;
                    }
                }
            }
            this.log.info("Merging 2 resources for " + KubernetesHelper.getKind((HasMetadata)item1) + " " + KubernetesHelper.getName((HasMetadata)item1) + " from " + KubernetesResourceUtil.getSourceUrlAnnotation((HasMetadata)item1) + " and " + KubernetesResourceUtil.getSourceUrlAnnotation((HasMetadata)item2) + " and removing " + KubernetesResourceUtil.getSourceUrlAnnotation((HasMetadata)answer), new Object[0]);
            return answer;
        }
        try {
            if (!this.getContext().runningWithGoal(new String[]{"fabric8:app-catalog"})) {
                this.log.warn("Duplicate resources for %s %s from %s and %s", new Object[]{KubernetesHelper.getKind((HasMetadata)item1), KubernetesHelper.getName((HasMetadata)item1), KubernetesResourceUtil.getSourceUrlAnnotation((HasMetadata)item1), KubernetesResourceUtil.getSourceUrlAnnotation((HasMetadata)item2)});
            }
        }
        catch (MojoExecutionException e) {
            this.log.warn("Failed to check if generated an app-catalog: %s", new Object[]{e});
        }
        return null;
    }

    protected boolean isMergeEnabled() {
        return Configs.asBoolean((String)this.getConfig(Config.enabled));
    }

    private boolean isLocalCustomisation(PodSpec podSpec) {
        List containers = Lists.notNullList((List)podSpec.getContainers());
        for (Container container : containers) {
            if (!Strings.isNotBlank((String)container.getImage())) continue;
            return false;
        }
        return true;
    }

    private static enum Config implements Configs.Key
    {
        enabled;

        protected String d;

        public String def() {
            return this.d;
        }
    }
}

