/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.maven.enricher.standard;

import io.fabric8.kubernetes.api.KubernetesHelper;
import io.fabric8.kubernetes.api.model.Container;
import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.KubernetesListBuilder;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.PersistentVolumeClaim;
import io.fabric8.kubernetes.api.model.PersistentVolumeClaimVolumeSource;
import io.fabric8.kubernetes.api.model.PodSpec;
import io.fabric8.kubernetes.api.model.PodTemplateSpec;
import io.fabric8.kubernetes.api.model.Volume;
import io.fabric8.kubernetes.api.model.VolumeMount;
import io.fabric8.maven.core.util.Configs;
import io.fabric8.maven.enricher.api.BaseEnricher;
import io.fabric8.maven.enricher.api.EnricherContext;
import io.fabric8.utils.Lists;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.json.JSONArray;
import org.json.JSONObject;

public class VolumePermissionEnricher
extends BaseEnricher {
    public static final String VOLUME_STORAGE_CLASS_ANNOTATION = "volume.beta.kubernetes.io/storage-class";
    public static final String INIT_CONTAINER_ANNOTATION = "pod.alpha.kubernetes.io/init-containers";
    static Set<String> POD_TEMPLATE_SPEC_HOLDER = new HashSet<String>(Arrays.asList("Deployment", "ReplicaSet", "ReplicationController", "DeploymentConfig"));

    public VolumePermissionEnricher(EnricherContext buildContext) {
        super(buildContext, "fmp-volume-permission");
    }

    public void adapt(KubernetesListBuilder builder) {
        for (HasMetadata item : Lists.notNullList((List)builder.getItems())) {
            if (POD_TEMPLATE_SPEC_HOLDER.contains(item.getKind())) {
                this.addPersistentVolumeInitContainerChmod(item, this.getPodTemplateSpec(item));
                continue;
            }
            if (!"PersistentVolumeClaim".equals(item.getKind())) continue;
            this.ensureVolumeStorageClass((PersistentVolumeClaim)item);
        }
        super.adapt(builder);
    }

    private void ensureVolumeStorageClass(PersistentVolumeClaim pvc) {
        Map annotations = KubernetesHelper.getOrCreateAnnotations((HasMetadata)pvc);
        if (!annotations.containsKey(VOLUME_STORAGE_CLASS_ANNOTATION)) {
            annotations.put(VOLUME_STORAGE_CLASS_ANNOTATION, "standard");
        }
    }

    private void addPersistentVolumeInitContainerChmod(HasMetadata entity, PodTemplateSpec template) {
        if (template == null) {
            return;
        }
        PodSpec podSpec = template.getSpec();
        if (podSpec == null) {
            return;
        }
        if (!this.checkForPvc(podSpec)) {
            return;
        }
        List containers = podSpec.getContainers();
        if (containers == null) {
            return;
        }
        String pvAnnotation = this.createPvAnnotation(containers);
        this.log.verbose("Adding annotation %s for changing persistent volumes access mode to %s", new Object[]{INIT_CONTAINER_ANNOTATION, this.getConfig(Config.permission)});
        ObjectMeta metadata = this.ensureMetadata(template);
        Map<String, String> annotations = this.ensureAnnotations(metadata);
        annotations.put(INIT_CONTAINER_ANNOTATION, pvAnnotation);
    }

    private Map<String, String> ensureAnnotations(ObjectMeta metadata) {
        HashMap annotations = metadata.getAnnotations();
        if (annotations == null) {
            annotations = new HashMap();
            metadata.setAnnotations(annotations);
        }
        return annotations;
    }

    private ObjectMeta ensureMetadata(PodTemplateSpec template) {
        ObjectMeta metadata = template.getMetadata();
        if (metadata == null) {
            metadata = new ObjectMeta();
            template.setMetadata(metadata);
        }
        return metadata;
    }

    private String createPvAnnotation(List<Container> containers) {
        Map<String, String> mountPoints = this.extractMountPoints(containers);
        JSONArray anno = new JSONArray();
        JSONObject entry = new JSONObject();
        entry.put("name", (Object)"init");
        entry.put("image", (Object)"busybox");
        entry.put("imagePullPolicy", (Object)"IfNotPresent");
        entry.put("command", (Object)this.createChmodCommandArray(mountPoints));
        entry.put("volumeMounts", (Object)this.createMounts(mountPoints));
        anno.put((Object)entry);
        return anno.toString();
    }

    private JSONArray createChmodCommandArray(Map<String, String> mountPoints) {
        JSONArray ret = new JSONArray();
        ret.put((Object)"chmod");
        ret.put((Object)this.getConfig(Config.permission));
        HashSet<String> uniqueNames = new HashSet<String>(mountPoints.values());
        for (String name : uniqueNames) {
            ret.put((Object)name);
        }
        return ret;
    }

    private JSONArray createMounts(Map<String, String> mountPoints) {
        JSONArray ret = new JSONArray();
        for (Map.Entry<String, String> entry : mountPoints.entrySet()) {
            JSONObject mount = new JSONObject();
            mount.put("name", (Object)entry.getKey());
            mount.put("mountPath", (Object)entry.getValue());
            ret.put((Object)mount);
        }
        return ret;
    }

    private Map<String, String> extractMountPoints(List<Container> containers) {
        TreeMap<String, String> nameToMount = new TreeMap<String, String>();
        for (Container container : containers) {
            List volumeMounts = container.getVolumeMounts();
            if (volumeMounts == null) continue;
            for (VolumeMount volumeMount : volumeMounts) {
                String name = volumeMount.getName();
                if (nameToMount.containsKey(name)) continue;
                nameToMount.put(name, volumeMount.getMountPath());
            }
        }
        return nameToMount;
    }

    private boolean checkForPvc(PodSpec podSpec) {
        List volumes = podSpec.getVolumes();
        if (volumes != null) {
            for (Volume volume : volumes) {
                PersistentVolumeClaimVolumeSource persistentVolumeClaim = volume.getPersistentVolumeClaim();
                if (persistentVolumeClaim == null) continue;
                return true;
            }
        }
        return false;
    }

    private PodTemplateSpec getPodTemplateSpec(HasMetadata item) {
        try {
            Method specGet = item.getClass().getMethod("getSpec", new Class[0]);
            Object spec = specGet.invoke((Object)item, new Object[0]);
            if (spec != null) {
                Method templateGet = spec.getClass().getMethod("getTemplate", new Class[0]);
                return (PodTemplateSpec)templateGet.invoke(spec, new Object[0]);
            }
            return null;
        }
        catch (ReflectiveOperationException e) {
            throw new IllegalArgumentException("Cannot extract pod template from " + item + ": " + e, e);
        }
    }

    private static enum Config implements Configs.Key
    {
        permission{
            {
                this.d = "777";
            }
        };

        protected String d;

        public String def() {
            return this.d;
        }
    }
}

