/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.maven.generator.api.support;

import io.fabric8.maven.core.config.PlatformMode;
import io.fabric8.maven.core.util.Configs;
import io.fabric8.maven.core.util.PrefixedLogger;
import io.fabric8.maven.docker.config.BuildImageConfiguration;
import io.fabric8.maven.docker.config.ImageConfiguration;
import io.fabric8.maven.generator.api.FromSelector;
import io.fabric8.maven.generator.api.Generator;
import io.fabric8.maven.generator.api.GeneratorConfig;
import io.fabric8.maven.generator.api.MavenGeneratorContext;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import org.apache.maven.project.MavenProject;

public abstract class BaseGenerator
implements Generator {
    private final MavenGeneratorContext context;
    private final String name;
    private final GeneratorConfig config;
    protected final PrefixedLogger log;
    private final FromSelector fromSelector;

    public BaseGenerator(MavenGeneratorContext context, String name) {
        this(context, name, null);
    }

    public BaseGenerator(MavenGeneratorContext context, String name, FromSelector fromSelector) {
        this.context = context;
        this.name = name;
        this.fromSelector = fromSelector;
        this.config = new GeneratorConfig(context.getProject().getProperties(), this.getName(), context.getConfig());
        this.log = new PrefixedLogger(name, context.getLog());
    }

    protected MavenProject getProject() {
        return this.context.getProject();
    }

    public String getName() {
        return this.name;
    }

    public MavenGeneratorContext getContext() {
        return this.context;
    }

    public GeneratorConfig getConfig() {
        return this.config;
    }

    protected String getConfig(Configs.Key key) {
        return this.config.get(key);
    }

    protected String getConfig(Configs.Key key, String defaultVal) {
        return this.config.get(key, defaultVal);
    }

    protected String getFrom() {
        String from = this.getConfigWithSystemFallbackAndDefault(Config.from, "fabric8.generator.from", null);
        if (from != null) {
            return from;
        }
        return this.fromSelector != null ? this.fromSelector.getFrom() : null;
    }

    protected String getImageName() {
        return this.getConfigWithSystemFallbackAndDefault(Config.name, "fabric8.generator.name", this.getDefaultImageUserExpression() + "%a:" + this.getDefaultImageLabelExpression());
    }

    private String getDefaultImageUserExpression() {
        if (PlatformMode.isOpenShiftMode((Properties)this.getProject().getProperties())) {
            return "";
        }
        return "%g/";
    }

    private String getDefaultImageLabelExpression() {
        if (PlatformMode.isOpenShiftMode((Properties)this.getProject().getProperties())) {
            return "%l";
        }
        return "%t";
    }

    protected String getAlias() {
        return this.getConfigWithSystemFallbackAndDefault(Config.alias, "fabric8.generator.alias", this.getName());
    }

    protected boolean shouldAddDefaultImage(List<ImageConfiguration> configs) {
        return !this.containsBuildConfiguration(configs);
    }

    private String getConfigWithSystemFallbackAndDefault(Config name, String key, String defaultVal) {
        String value = this.getConfig(name);
        if (value == null) {
            value = Configs.getPropertyWithSystemAsFallback((Properties)this.getProject().getProperties(), (String)key);
        }
        return value != null ? value : defaultVal;
    }

    protected void addLatestTagIfSnapshot(BuildImageConfiguration.Builder buildBuilder) {
        MavenProject project = this.getProject();
        if (project.getVersion().endsWith("-SNAPSHOT")) {
            buildBuilder.tags(Collections.singletonList("latest"));
        }
    }

    private boolean containsBuildConfiguration(List<ImageConfiguration> configs) {
        for (ImageConfiguration config : configs) {
            if (config.getBuildConfiguration() == null) continue;
            return true;
        }
        return false;
    }

    private static enum Config implements Configs.Key
    {
        merge,
        name,
        alias,
        from;

        protected String d;

        public String def() {
            return this.d;
        }
    }
}

