/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.gateway.fabric.http;

import io.fabric8.api.Container;
import io.fabric8.api.FabricService;
import io.fabric8.api.Version;
import io.fabric8.api.scr.AbstractComponent;
import io.fabric8.api.scr.Configurer;
import io.fabric8.api.scr.ValidatingReference;
import io.fabric8.gateway.fabric.detecting.FabricDetectingGatewayService;
import io.fabric8.gateway.fabric.support.vertx.VertxService;
import io.fabric8.gateway.handlers.detecting.DetectingGatewayWebSocketHandler;
import io.fabric8.gateway.handlers.http.HttpGateway;
import io.fabric8.gateway.handlers.http.HttpGatewayHandler;
import io.fabric8.gateway.handlers.http.HttpGatewayServer;
import io.fabric8.gateway.handlers.http.HttpMappingRule;
import io.fabric8.gateway.handlers.http.MappedServices;
import java.net.InetSocketAddress;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import org.apache.curator.framework.CuratorFramework;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.ConfigurationPolicy;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Modified;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.apache.felix.scr.annotations.ReferencePolicy;
import org.apache.felix.scr.annotations.Service;
import org.vertx.java.core.Handler;
import org.vertx.java.core.Vertx;

@Component(name="io.fabric8.gateway.http", immediate=true, metatype=true, policy=ConfigurationPolicy.REQUIRE, label="Fabric8 HTTP Gateway", description="Provides a discovery and load balancing HTTP gateway (or reverse proxy) between HTTP clients and HTTP servers such as web applications, REST APIs and web applications")
@Service(value={FabricHTTPGateway.class})
public final class FabricHTTPGateway
extends AbstractComponent
implements HttpGateway {
    @Property(name="host", label="Host name", description="The host name used when listening for HTTP traffic")
    private String host;
    @Property(name="port", intValue={8080}, label="Port", description="Port number to listen on for HTTP requests")
    private int port = 8080;
    @Property(name="enableIndex", boolValue={true}, label="Enable index page", description="If enabled then performing a HTTP GET on the path '/' will return a JSON representation of the gateway mappings")
    private boolean enableIndex = true;
    @Property(name="enableWebSocketGateway", boolValue={true}, label="Enable the Web Socket Gateway", description="If enabled then Web Socket connections will be handled by protocol detecting gateway")
    private boolean enableWebSocketGateway = true;
    @Property(name="websocketGatewayPrefix", label="Web Socket Path Prefix", description="The prefix a websocket requests must have")
    private String websocketGatewayPrefix = "";
    @Reference
    private Configurer configurer;
    @Reference(referenceInterface=VertxService.class)
    private final ValidatingReference<VertxService> vertxService = new ValidatingReference();
    @Reference(referenceInterface=FabricService.class)
    private final ValidatingReference<FabricService> fabricService = new ValidatingReference();
    @Reference(referenceInterface=CuratorFramework.class)
    private final ValidatingReference<CuratorFramework> curator = new ValidatingReference();
    @Reference(referenceInterface=FabricDetectingGatewayService.class, cardinality=ReferenceCardinality.OPTIONAL_UNARY, policy=ReferencePolicy.DYNAMIC)
    private final ValidatingReference<FabricDetectingGatewayService> fabricDetectingGatewayService = new ValidatingReference();
    private HttpGatewayServer server;
    private HttpGatewayHandler handler;
    private DetectingGatewayWebSocketHandler websocketHandler = new DetectingGatewayWebSocketHandler();
    private Set<HttpMappingRule> mappingRuleConfigurations = new CopyOnWriteArraySet<HttpMappingRule>();

    @Activate
    void activate(Map<String, ?> configuration) throws Exception {
        this.updateConfiguration(configuration);
        this.activateComponent();
    }

    @Modified
    void modified(Map<String, ?> configuration) throws Exception {
        this.deactivateInternal();
        this.updateConfiguration(configuration);
    }

    @Deactivate
    void deactivate() {
        this.deactivateInternal();
        this.deactivateComponent();
    }

    private void updateConfiguration(Map<String, ?> configuration) throws Exception {
        this.configurer.configure(configuration, (Object)this);
        Vertx vertx = this.getVertx();
        this.handler = new HttpGatewayHandler(vertx, (HttpGateway)this);
        this.websocketHandler.setPathPrefix(this.websocketGatewayPrefix);
        this.server = new HttpGatewayServer(vertx, this.handler, (Handler)(this.enableWebSocketGateway ? this.websocketHandler : null), this.port);
        this.server.init();
    }

    private void deactivateInternal() {
        if (this.server != null) {
            this.server.destroy();
        }
    }

    public void addMappingRuleConfiguration(HttpMappingRule mappingRuleConfiguration) {
        this.assertValid();
        this.mappingRuleConfigurations.add(mappingRuleConfiguration);
    }

    public void removeMappingRuleConfiguration(HttpMappingRule mappingRuleConfiguration) {
        this.assertValid();
        this.mappingRuleConfigurations.remove(mappingRuleConfiguration);
    }

    public Map<String, MappedServices> getMappedServices() {
        this.assertValid();
        HashMap<String, MappedServices> answer = new HashMap<String, MappedServices>();
        for (HttpMappingRule mappingRuleConfiguration : this.mappingRuleConfigurations) {
            mappingRuleConfiguration.appendMappedServices(answer);
        }
        return answer;
    }

    public boolean isEnableIndex() {
        return this.enableIndex;
    }

    public InetSocketAddress getLocalAddress() {
        return new InetSocketAddress(this.host == null ? "0.0.0.0" : this.host, this.port);
    }

    private Vertx getVertx() {
        return ((VertxService)this.vertxService.get()).getVertx();
    }

    String getGatewayVersion() {
        Version version;
        this.assertValid();
        Container currentContainer = ((FabricService)this.fabricService.get()).getCurrentContainer();
        if (currentContainer != null && (version = currentContainer.getVersion()) != null) {
            return version.getId();
        }
        return null;
    }

    int getPort() {
        return this.port;
    }

    void bindVertxService(VertxService vertxService) {
        this.vertxService.bind((Object)vertxService);
    }

    void unbindVertxService(VertxService vertxService) {
        this.vertxService.unbind((Object)vertxService);
    }

    void bindCurator(CuratorFramework curator) {
        this.curator.bind((Object)curator);
    }

    void unbindCurator(CuratorFramework curator) {
        this.curator.unbind((Object)curator);
    }

    void bindFabricService(FabricService fabricService) {
        this.fabricService.bind((Object)fabricService);
    }

    void unbindFabricService(FabricService fabricService) {
        this.fabricService.unbind((Object)fabricService);
    }

    void bindFabricDetectingGatewayService(FabricDetectingGatewayService fabricDetectingGatewayService) {
        this.fabricDetectingGatewayService.bind((Object)fabricDetectingGatewayService);
        this.websocketHandler.setHandler(fabricDetectingGatewayService.getDetectingGatewayProtocolHandler());
    }

    void unbindFabricDetectingGatewayService(FabricDetectingGatewayService fabricDetectingGatewayService) {
        this.fabricDetectingGatewayService.unbind((Object)fabricDetectingGatewayService);
        this.websocketHandler.setHandler(null);
    }

    protected void bindConfigurer(Configurer configurer) {
        this.configurer = configurer;
    }

    protected void unbindConfigurer(Configurer configurer) {
        if (this.configurer == configurer) {
            this.configurer = null;
        }
    }
}

