/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.gateway.fabric.http;

import io.fabric8.gateway.fabric.http.FabricGatewayInfoMBean;
import io.fabric8.gateway.fabric.http.FabricHTTPGateway;
import io.fabric8.utils.ShutdownTracker;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.StandardMBean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FabricHTTPGatewayInfo
implements FabricGatewayInfoMBean {
    private static final transient Logger LOG = LoggerFactory.getLogger(FabricHTTPGatewayInfo.class);
    private final FabricHTTPGateway fabricHTTPGateway;
    private ObjectName objectName;
    private long numberOfInvocations = 0L;
    private long averageCallTimeNanos = 0L;
    private String lastError;
    private String lastCallDate;

    public FabricHTTPGatewayInfo(FabricHTTPGateway fabricHTTPGateway) {
        this.fabricHTTPGateway = fabricHTTPGateway;
    }

    protected FabricHTTPGateway getFabricHTTPGateway() {
        return this.fabricHTTPGateway;
    }

    @Override
    public int getPort() {
        return this.getFabricHTTPGateway().getPort();
    }

    @Override
    public String getHost() {
        return this.getFabricHTTPGateway().getHost();
    }

    @Override
    public String getGatewayVersion() {
        return this.getFabricHTTPGateway().getGatewayVersion();
    }

    @Override
    public String getLocalAddress() {
        return this.getFabricHTTPGateway().getLocalAddress().toString();
    }

    @Override
    public boolean isEnableIndex() {
        return this.getFabricHTTPGateway().isEnableIndex();
    }

    @Override
    public String getMappedServices() {
        String mappedServices = "";
        if (this.getFabricHTTPGateway().getMappedServices() != null) {
            for (String mappedServiceKey : this.getFabricHTTPGateway().getMappedServices().keySet()) {
                mappedServices = mappedServices + mappedServiceKey + ":" + this.getFabricHTTPGateway().getMappedServices().get(mappedServiceKey) + "<BR>";
            }
        }
        return mappedServices;
    }

    @Override
    public long getNumberOfInvocations() {
        return this.numberOfInvocations;
    }

    public void registerCall(long callTimeNanos) {
        this.averageCallTimeNanos = (this.averageCallTimeNanos * this.numberOfInvocations + callTimeNanos) / ++this.numberOfInvocations;
    }

    public void setLastError(String error) {
        this.lastError = error;
    }

    @Override
    public String getLastError() {
        return this.lastError;
    }

    public void setLastCallDate(String callDate) {
        this.lastCallDate = callDate;
    }

    @Override
    public String getLastCallDate() {
        if (this.lastCallDate != null) {
            return this.lastCallDate.toString();
        }
        return null;
    }

    @Override
    public long getAvarageCallTimeNanos() {
        return this.averageCallTimeNanos;
    }

    @Override
    public void resetStatistics() {
        this.averageCallTimeNanos = 0L;
        this.numberOfInvocations = 0L;
        this.lastCallDate = null;
        this.lastError = null;
    }

    public ObjectName getObjectName() throws MalformedObjectNameException {
        if (this.objectName == null) {
            this.objectName = new ObjectName("io.fabric8.gateway-fabric:service=FabricHTTPGatewayInfo");
        }
        return this.objectName;
    }

    public void setObjectName(ObjectName objectName) {
        this.objectName = objectName;
    }

    public void registerMBeanServer(ShutdownTracker shutdownTracker, MBeanServer mbeanServer) {
        try {
            ObjectName name = this.getObjectName();
            if (!mbeanServer.isRegistered(name)) {
                StandardMBean mbean = new StandardMBean(this, FabricGatewayInfoMBean.class);
                mbeanServer.registerMBean(mbean, name);
            }
        }
        catch (Exception e) {
            LOG.warn("An error occurred during mbean server registration: " + e, (Throwable)e);
        }
    }

    public void unregisterMBeanServer(MBeanServer mbeanServer) {
        if (mbeanServer != null) {
            try {
                ObjectName name = this.getObjectName();
                if (mbeanServer.isRegistered(name)) {
                    mbeanServer.unregisterMBean(name);
                }
            }
            catch (Exception e) {
                LOG.warn("An error occurred during mbean server registration: " + e, (Throwable)e);
            }
        }
    }
}

