/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.gateway.support;

import io.fabric8.gateway.model.HttpProxyRule;
import io.fabric8.gateway.support.MappingResult;
import io.fabric8.gateway.support.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class UriTemplate {
    private static final Pattern PATTERN = Pattern.compile("\\{([^/]+?)\\}");
    private final String[] paths;
    private List<String> parameters = new ArrayList<String>();
    private String path;

    public UriTemplate(String path) {
        this.path = path;
        this.paths = Paths.splitPaths(path);
        Matcher matcher = PATTERN.matcher(path);
        while (matcher.find()) {
            this.parameters.add(matcher.group(1));
        }
    }

    public MappingResult matches(String[] requestUriPaths, HttpProxyRule proxyRule) {
        int processedPaths;
        int actualLength = requestUriPaths.length;
        boolean joinedPath = false;
        HashMap<String, String> parameterNameValues = new HashMap<String, String>();
        int lastIndex = this.paths.length - 1;
        for (processedPaths = 0; processedPaths <= lastIndex; ++processedPaths) {
            String actualSegment = null;
            if (processedPaths < actualLength) {
                actualSegment = requestUriPaths[processedPaths];
            }
            if (actualSegment == null) {
                return null;
            }
            String parameterName = this.getWildcardParameterName(processedPaths);
            if (parameterName != null) {
                if (processedPaths == lastIndex) {
                    actualSegment = this.joinPath(processedPaths, requestUriPaths);
                    joinedPath = true;
                }
                parameterNameValues.put(parameterName, actualSegment);
                continue;
            }
            String pathSegment = this.paths[processedPaths];
            if (pathSegment != null && actualSegment.equals(pathSegment)) continue;
            return null;
        }
        if (!joinedPath && processedPaths < actualLength) {
            return null;
        }
        return new MappingResult(parameterNameValues, requestUriPaths, proxyRule);
    }

    public List<String> getParameterNames() {
        return Collections.unmodifiableList(this.parameters);
    }

    public String bindByPosition(String ... params) {
        if (params.length != this.parameters.size()) {
            throw new IllegalArgumentException("Parameters mismatch. Path template contains " + this.parameters.size() + " parameters, " + params.length + " was given");
        }
        HashMap<String, String> paramsMap = new HashMap<String, String>();
        int j = params.length;
        for (int i = 0; i < j; ++i) {
            String param = params[i];
            if (param != null) {
                param = param.trim();
            }
            paramsMap.put(this.parameters.get(i), param);
        }
        return this.bindByName(paramsMap);
    }

    public String bindByName(String ... params) {
        HashMap<String, String> paramsMap = new HashMap<String, String>();
        int j = params.length;
        for (int i = 0; i < j; i += 2) {
            paramsMap.put(params[i], i + 1 < j ? params[i + 1] : "");
        }
        return this.bindByName(paramsMap);
    }

    public String bindByName(Map<String, String> params) {
        if (params.size() != this.parameters.size()) {
            throw new IllegalArgumentException("Parameters mismatch. Path template contains " + this.parameters.size() + " parameters, " + params.size() + " was given");
        }
        String localPath = this.path;
        for (Map.Entry<String, String> entry : params.entrySet()) {
            String key = entry.getKey();
            String value = entry.getValue();
            if (!this.parameters.contains(key)) {
                throw new IllegalArgumentException("Unknown parameter " + key);
            }
            localPath = this.replace(localPath, key, value);
        }
        return localPath;
    }

    public String bindByNameNonStrict(Map<String, String> params) {
        String localPath = this.path;
        for (String key : this.parameters) {
            String value = params.get(key);
            if (value == null) continue;
            localPath = this.replace(localPath, key, value);
        }
        return localPath;
    }

    protected String getWildcardParameterName(int pathIndex) {
        String pathSegment;
        String parameterName = null;
        if (pathIndex >= 0 && pathIndex < this.paths.length && (pathSegment = this.paths[pathIndex]) != null && pathSegment.startsWith("{") && pathSegment.endsWith("}")) {
            parameterName = pathSegment.substring(1, pathSegment.length() - 1);
        }
        return parameterName;
    }

    protected String joinPath(int index, String[] paths) {
        int lastIndex = paths.length - 1;
        if (index == lastIndex) {
            return paths[index];
        }
        StringBuilder builder = new StringBuilder();
        for (int i = index; i <= lastIndex; ++i) {
            String path = paths[i];
            if (path == null) {
                path = "";
            }
            if (builder.length() > 0) {
                builder.append("/");
            }
            builder.append(path);
        }
        return builder.toString();
    }

    protected String replace(String text, String key, String value) {
        if (value == null) {
            throw new IllegalStateException("Parameter " + key + " is null.");
        }
        return text.replace("{" + key + "}", value);
    }
}

