/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.repo.gitlab;

import io.fabric8.kubernetes.api.KubernetesHelper;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.repo.gitlab.GitlabClient;
import io.fabric8.utils.Strings;
import io.fabric8.utils.Systems;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GitlabKubernetes {
    private static final transient Logger LOG = LoggerFactory.getLogger(GitlabKubernetes.class);
    public static final String JENKINS_GOGS_USER = "JENKINS_GOGS_USER";
    public static final String JENKINS_GOGS_PASSWORD = "JENKINS_GOGS_PASSWORD";

    public static GitlabClient createGitRepoClient(KubernetesClient kubernetes) {
        return GitlabKubernetes.createGitRepoClient(kubernetes, null, null);
    }

    public static GitlabClient createGitRepoClient(KubernetesClient kubernetes, String userName, String password) {
        String address;
        if (Strings.isNullOrBlank((String)userName)) {
            userName = Systems.getEnvVarOrSystemProperty((String)JENKINS_GOGS_USER, (String)"gogsadmin");
        }
        if (Strings.isNullOrBlank((String)password)) {
            password = Systems.getEnvVarOrSystemProperty((String)JENKINS_GOGS_PASSWORD, (String)"RedHat$1");
        }
        String namespace = KubernetesHelper.defaultNamespace();
        try {
            address = KubernetesHelper.getServiceURL((KubernetesClient)kubernetes, (String)"gitlab", (String)namespace, (String)"http", (boolean)true);
            if (Strings.isNullOrBlank((String)address)) {
                LOG.warn("No Gitlab service could be found in kubernetes " + namespace + " on address: " + kubernetes.getMasterUrl());
                return null;
            }
        }
        catch (IllegalArgumentException e) {
            LOG.warn("No Gitlab service could be found in kubernetes " + namespace + " on address: " + kubernetes.getMasterUrl());
            return null;
        }
        LOG.info("Logging into Gitlab at " + address + " as user " + userName);
        return new GitlabClient(address, userName, password);
    }
}

