package io.fabric8.istio.api.networking.v1alpha3;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Boolean;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.istio.api.meta.v1alpha1.IstioStatusFluentImpl;
import io.fabric8.istio.api.meta.v1alpha1.IstioStatusBuilder;
import io.fabric8.kubernetes.api.model.ObjectMetaFluentImpl;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;
import io.fabric8.istio.api.meta.v1alpha1.IstioStatus;
import java.lang.Object;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class EnvoyFilterFluentImpl<A extends EnvoyFilterFluent<A>> extends BaseFluent<A> implements EnvoyFilterFluent<A>{
  public EnvoyFilterFluentImpl() {
  }
  public EnvoyFilterFluentImpl(EnvoyFilter instance) {
    this.withApiVersion(instance.getApiVersion()); 
    this.withKind(instance.getKind()); 
    this.withMetadata(instance.getMetadata()); 
    this.withSpec(instance.getSpec()); 
    this.withStatus(instance.getStatus()); 
  }
  private String apiVersion;
  private String kind;
  private ObjectMetaBuilder metadata;
  private EnvoyFilterSpecBuilder spec;
  private IstioStatusBuilder status;
  public String getApiVersion() {
    return this.apiVersion;
  }
  public A withApiVersion(String apiVersion) {
    this.apiVersion=apiVersion; return (A) this;
  }
  public Boolean hasApiVersion() {
    return this.apiVersion != null;
  }
  public String getKind() {
    return this.kind;
  }
  public A withKind(String kind) {
    this.kind=kind; return (A) this;
  }
  public Boolean hasKind() {
    return this.kind != null;
  }
  
  /**
   * This method has been deprecated, please use method buildMetadata instead.
   * @return The buildable object.
   */
  @Deprecated
  public ObjectMeta getMetadata() {
    return this.metadata!=null ?this.metadata.build():null;
  }
  public ObjectMeta buildMetadata() {
    return this.metadata!=null ?this.metadata.build():null;
  }
  public A withMetadata(ObjectMeta metadata) {
    _visitables.get("metadata").remove(this.metadata);
    if (metadata!=null){ this.metadata= new ObjectMetaBuilder(metadata); _visitables.get("metadata").add(this.metadata);} else { this.metadata = null; _visitables.get("metadata").remove(this.metadata); } return (A) this;
  }
  public Boolean hasMetadata() {
    return this.metadata != null;
  }
  public EnvoyFilterFluent.MetadataNested<A> withNewMetadata() {
    return new EnvoyFilterFluentImpl.MetadataNestedImpl();
  }
  public EnvoyFilterFluent.MetadataNested<A> withNewMetadataLike(ObjectMeta item) {
    return new EnvoyFilterFluentImpl.MetadataNestedImpl(item);
  }
  public EnvoyFilterFluent.MetadataNested<A> editMetadata() {
    return withNewMetadataLike(getMetadata());
  }
  public EnvoyFilterFluent.MetadataNested<A> editOrNewMetadata() {
    return withNewMetadataLike(getMetadata() != null ? getMetadata(): new ObjectMetaBuilder().build());
  }
  public EnvoyFilterFluent.MetadataNested<A> editOrNewMetadataLike(ObjectMeta item) {
    return withNewMetadataLike(getMetadata() != null ? getMetadata(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildSpec instead.
   * @return The buildable object.
   */
  @Deprecated
  public EnvoyFilterSpec getSpec() {
    return this.spec!=null ?this.spec.build():null;
  }
  public EnvoyFilterSpec buildSpec() {
    return this.spec!=null ?this.spec.build():null;
  }
  public A withSpec(EnvoyFilterSpec spec) {
    _visitables.get("spec").remove(this.spec);
    if (spec!=null){ this.spec= new EnvoyFilterSpecBuilder(spec); _visitables.get("spec").add(this.spec);} else { this.spec = null; _visitables.get("spec").remove(this.spec); } return (A) this;
  }
  public Boolean hasSpec() {
    return this.spec != null;
  }
  public EnvoyFilterFluent.SpecNested<A> withNewSpec() {
    return new EnvoyFilterFluentImpl.SpecNestedImpl();
  }
  public EnvoyFilterFluent.SpecNested<A> withNewSpecLike(EnvoyFilterSpec item) {
    return new EnvoyFilterFluentImpl.SpecNestedImpl(item);
  }
  public EnvoyFilterFluent.SpecNested<A> editSpec() {
    return withNewSpecLike(getSpec());
  }
  public EnvoyFilterFluent.SpecNested<A> editOrNewSpec() {
    return withNewSpecLike(getSpec() != null ? getSpec(): new EnvoyFilterSpecBuilder().build());
  }
  public EnvoyFilterFluent.SpecNested<A> editOrNewSpecLike(EnvoyFilterSpec item) {
    return withNewSpecLike(getSpec() != null ? getSpec(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildStatus instead.
   * @return The buildable object.
   */
  @Deprecated
  public IstioStatus getStatus() {
    return this.status!=null ?this.status.build():null;
  }
  public IstioStatus buildStatus() {
    return this.status!=null ?this.status.build():null;
  }
  public A withStatus(IstioStatus status) {
    _visitables.get("status").remove(this.status);
    if (status!=null){ this.status= new IstioStatusBuilder(status); _visitables.get("status").add(this.status);} else { this.status = null; _visitables.get("status").remove(this.status); } return (A) this;
  }
  public Boolean hasStatus() {
    return this.status != null;
  }
  public EnvoyFilterFluent.StatusNested<A> withNewStatus() {
    return new EnvoyFilterFluentImpl.StatusNestedImpl();
  }
  public EnvoyFilterFluent.StatusNested<A> withNewStatusLike(IstioStatus item) {
    return new EnvoyFilterFluentImpl.StatusNestedImpl(item);
  }
  public EnvoyFilterFluent.StatusNested<A> editStatus() {
    return withNewStatusLike(getStatus());
  }
  public EnvoyFilterFluent.StatusNested<A> editOrNewStatus() {
    return withNewStatusLike(getStatus() != null ? getStatus(): new IstioStatusBuilder().build());
  }
  public EnvoyFilterFluent.StatusNested<A> editOrNewStatusLike(IstioStatus item) {
    return withNewStatusLike(getStatus() != null ? getStatus(): item);
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    EnvoyFilterFluentImpl that = (EnvoyFilterFluentImpl) o;
    if (apiVersion != null ? !apiVersion.equals(that.apiVersion) :that.apiVersion != null) return false;
    if (kind != null ? !kind.equals(that.kind) :that.kind != null) return false;
    if (metadata != null ? !metadata.equals(that.metadata) :that.metadata != null) return false;
    if (spec != null ? !spec.equals(that.spec) :that.spec != null) return false;
    if (status != null ? !status.equals(that.status) :that.status != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(apiVersion,  kind,  metadata,  spec,  status,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (apiVersion != null) { sb.append("apiVersion:"); sb.append(apiVersion + ","); }
    if (kind != null) { sb.append("kind:"); sb.append(kind + ","); }
    if (metadata != null) { sb.append("metadata:"); sb.append(metadata + ","); }
    if (spec != null) { sb.append("spec:"); sb.append(spec + ","); }
    if (status != null) { sb.append("status:"); sb.append(status); }
    sb.append("}");
    return sb.toString();
  }
  class MetadataNestedImpl<N> extends ObjectMetaFluentImpl<EnvoyFilterFluent.MetadataNested<N>> implements EnvoyFilterFluent.MetadataNested<N>,Nested<N>{
    MetadataNestedImpl(ObjectMeta item) {
      this.builder = new ObjectMetaBuilder(this, item);
    }
    MetadataNestedImpl() {
      this.builder = new ObjectMetaBuilder(this);
    }
    ObjectMetaBuilder builder;
    public N and() {
      return (N) EnvoyFilterFluentImpl.this.withMetadata(builder.build());
    }
    public N endMetadata() {
      return and();
    }
    
  }
  class SpecNestedImpl<N> extends EnvoyFilterSpecFluentImpl<EnvoyFilterFluent.SpecNested<N>> implements EnvoyFilterFluent.SpecNested<N>,Nested<N>{
    SpecNestedImpl(EnvoyFilterSpec item) {
      this.builder = new EnvoyFilterSpecBuilder(this, item);
    }
    SpecNestedImpl() {
      this.builder = new EnvoyFilterSpecBuilder(this);
    }
    EnvoyFilterSpecBuilder builder;
    public N and() {
      return (N) EnvoyFilterFluentImpl.this.withSpec(builder.build());
    }
    public N endSpec() {
      return and();
    }
    
  }
  class StatusNestedImpl<N> extends IstioStatusFluentImpl<EnvoyFilterFluent.StatusNested<N>> implements EnvoyFilterFluent.StatusNested<N>,Nested<N>{
    StatusNestedImpl(IstioStatus item) {
      this.builder = new IstioStatusBuilder(this, item);
    }
    StatusNestedImpl() {
      this.builder = new IstioStatusBuilder(this);
    }
    IstioStatusBuilder builder;
    public N and() {
      return (N) EnvoyFilterFluentImpl.this.withStatus(builder.build());
    }
    public N endStatus() {
      return and();
    }
    
  }
  
}