package io.fabric8.istio.api.networking.v1alpha3;

import java.lang.SuppressWarnings;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import java.lang.Integer;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;
import java.util.Map;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class L4MatchAttributesFluentImpl<A extends L4MatchAttributesFluent<A>> extends BaseFluent<A> implements L4MatchAttributesFluent<A>{
  public L4MatchAttributesFluentImpl() {
  }
  public L4MatchAttributesFluentImpl(L4MatchAttributes instance) {
    this.withDestinationSubnets(instance.getDestinationSubnets()); 
    this.withGateways(instance.getGateways()); 
    this.withPort(instance.getPort()); 
    this.withSourceLabels(instance.getSourceLabels()); 
    this.withSourceNamespace(instance.getSourceNamespace()); 
    this.withSourceSubnet(instance.getSourceSubnet()); 
  }
  private List<String> destinationSubnets = new ArrayList<String>();
  private List<String> gateways = new ArrayList<String>();
  private Integer port;
  private Map<String,String> sourceLabels;
  private String sourceNamespace;
  private String sourceSubnet;
  public A addToDestinationSubnets(Integer index,String item) {
    if (this.destinationSubnets == null) {this.destinationSubnets = new ArrayList<String>();}
    this.destinationSubnets.add(index, item);
    return (A)this;
  }
  public A setToDestinationSubnets(Integer index,String item) {
    if (this.destinationSubnets == null) {this.destinationSubnets = new ArrayList<String>();}
    this.destinationSubnets.set(index, item); return (A)this;
  }
  public A addToDestinationSubnets(java.lang.String... items) {
    if (this.destinationSubnets == null) {this.destinationSubnets = new ArrayList<String>();}
    for (String item : items) {this.destinationSubnets.add(item);} return (A)this;
  }
  public A addAllToDestinationSubnets(Collection<String> items) {
    if (this.destinationSubnets == null) {this.destinationSubnets = new ArrayList<String>();}
    for (String item : items) {this.destinationSubnets.add(item);} return (A)this;
  }
  public A removeFromDestinationSubnets(java.lang.String... items) {
    for (String item : items) {if (this.destinationSubnets!= null){ this.destinationSubnets.remove(item);}} return (A)this;
  }
  public A removeAllFromDestinationSubnets(Collection<String> items) {
    for (String item : items) {if (this.destinationSubnets!= null){ this.destinationSubnets.remove(item);}} return (A)this;
  }
  public List<String> getDestinationSubnets() {
    return this.destinationSubnets;
  }
  public String getDestinationSubnet(Integer index) {
    return this.destinationSubnets.get(index);
  }
  public String getFirstDestinationSubnet() {
    return this.destinationSubnets.get(0);
  }
  public String getLastDestinationSubnet() {
    return this.destinationSubnets.get(destinationSubnets.size() - 1);
  }
  public String getMatchingDestinationSubnet(Predicate<String> predicate) {
    for (String item: destinationSubnets) { if(predicate.test(item)){ return item;} } return null;
  }
  public Boolean hasMatchingDestinationSubnet(Predicate<String> predicate) {
    for (String item: destinationSubnets) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withDestinationSubnets(List<String> destinationSubnets) {
    if (destinationSubnets != null) {this.destinationSubnets = new ArrayList(); for (String item : destinationSubnets){this.addToDestinationSubnets(item);}} else { this.destinationSubnets = null;} return (A) this;
  }
  public A withDestinationSubnets(java.lang.String... destinationSubnets) {
    if (this.destinationSubnets != null) {this.destinationSubnets.clear();}
    if (destinationSubnets != null) {for (String item :destinationSubnets){ this.addToDestinationSubnets(item);}} return (A) this;
  }
  public Boolean hasDestinationSubnets() {
    return destinationSubnets != null && !destinationSubnets.isEmpty();
  }
  public A addToGateways(Integer index,String item) {
    if (this.gateways == null) {this.gateways = new ArrayList<String>();}
    this.gateways.add(index, item);
    return (A)this;
  }
  public A setToGateways(Integer index,String item) {
    if (this.gateways == null) {this.gateways = new ArrayList<String>();}
    this.gateways.set(index, item); return (A)this;
  }
  public A addToGateways(java.lang.String... items) {
    if (this.gateways == null) {this.gateways = new ArrayList<String>();}
    for (String item : items) {this.gateways.add(item);} return (A)this;
  }
  public A addAllToGateways(Collection<String> items) {
    if (this.gateways == null) {this.gateways = new ArrayList<String>();}
    for (String item : items) {this.gateways.add(item);} return (A)this;
  }
  public A removeFromGateways(java.lang.String... items) {
    for (String item : items) {if (this.gateways!= null){ this.gateways.remove(item);}} return (A)this;
  }
  public A removeAllFromGateways(Collection<String> items) {
    for (String item : items) {if (this.gateways!= null){ this.gateways.remove(item);}} return (A)this;
  }
  public List<String> getGateways() {
    return this.gateways;
  }
  public String getGateway(Integer index) {
    return this.gateways.get(index);
  }
  public String getFirstGateway() {
    return this.gateways.get(0);
  }
  public String getLastGateway() {
    return this.gateways.get(gateways.size() - 1);
  }
  public String getMatchingGateway(Predicate<String> predicate) {
    for (String item: gateways) { if(predicate.test(item)){ return item;} } return null;
  }
  public Boolean hasMatchingGateway(Predicate<String> predicate) {
    for (String item: gateways) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withGateways(List<String> gateways) {
    if (gateways != null) {this.gateways = new ArrayList(); for (String item : gateways){this.addToGateways(item);}} else { this.gateways = null;} return (A) this;
  }
  public A withGateways(java.lang.String... gateways) {
    if (this.gateways != null) {this.gateways.clear();}
    if (gateways != null) {for (String item :gateways){ this.addToGateways(item);}} return (A) this;
  }
  public Boolean hasGateways() {
    return gateways != null && !gateways.isEmpty();
  }
  public Integer getPort() {
    return this.port;
  }
  public A withPort(Integer port) {
    this.port=port; return (A) this;
  }
  public Boolean hasPort() {
    return this.port != null;
  }
  public A addToSourceLabels(String key,String value) {
    if(this.sourceLabels == null && key != null && value != null) { this.sourceLabels = new LinkedHashMap(); }
    if(key != null && value != null) {this.sourceLabels.put(key, value);} return (A)this;
  }
  public A addToSourceLabels(Map<String,String> map) {
    if(this.sourceLabels == null && map != null) { this.sourceLabels = new LinkedHashMap(); }
    if(map != null) { this.sourceLabels.putAll(map);} return (A)this;
  }
  public A removeFromSourceLabels(String key) {
    if(this.sourceLabels == null) { return (A) this; }
    if(key != null && this.sourceLabels != null) {this.sourceLabels.remove(key);} return (A)this;
  }
  public A removeFromSourceLabels(Map<String,String> map) {
    if(this.sourceLabels == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.sourceLabels != null){this.sourceLabels.remove(key);}}} return (A)this;
  }
  public Map<String,String> getSourceLabels() {
    return this.sourceLabels;
  }
  public <K,V>A withSourceLabels(Map<String,String> sourceLabels) {
    if (sourceLabels == null) { this.sourceLabels =  null;} else {this.sourceLabels = new LinkedHashMap(sourceLabels);} return (A) this;
  }
  public Boolean hasSourceLabels() {
    return this.sourceLabels != null;
  }
  public String getSourceNamespace() {
    return this.sourceNamespace;
  }
  public A withSourceNamespace(String sourceNamespace) {
    this.sourceNamespace=sourceNamespace; return (A) this;
  }
  public Boolean hasSourceNamespace() {
    return this.sourceNamespace != null;
  }
  public String getSourceSubnet() {
    return this.sourceSubnet;
  }
  public A withSourceSubnet(String sourceSubnet) {
    this.sourceSubnet=sourceSubnet; return (A) this;
  }
  public Boolean hasSourceSubnet() {
    return this.sourceSubnet != null;
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    L4MatchAttributesFluentImpl that = (L4MatchAttributesFluentImpl) o;
    if (destinationSubnets != null ? !destinationSubnets.equals(that.destinationSubnets) :that.destinationSubnets != null) return false;
    if (gateways != null ? !gateways.equals(that.gateways) :that.gateways != null) return false;
    if (port != null ? !port.equals(that.port) :that.port != null) return false;
    if (sourceLabels != null ? !sourceLabels.equals(that.sourceLabels) :that.sourceLabels != null) return false;
    if (sourceNamespace != null ? !sourceNamespace.equals(that.sourceNamespace) :that.sourceNamespace != null) return false;
    if (sourceSubnet != null ? !sourceSubnet.equals(that.sourceSubnet) :that.sourceSubnet != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(destinationSubnets,  gateways,  port,  sourceLabels,  sourceNamespace,  sourceSubnet,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (destinationSubnets != null && !destinationSubnets.isEmpty()) { sb.append("destinationSubnets:"); sb.append(destinationSubnets + ","); }
    if (gateways != null && !gateways.isEmpty()) { sb.append("gateways:"); sb.append(gateways + ","); }
    if (port != null) { sb.append("port:"); sb.append(port + ","); }
    if (sourceLabels != null && !sourceLabels.isEmpty()) { sb.append("sourceLabels:"); sb.append(sourceLabels + ","); }
    if (sourceNamespace != null) { sb.append("sourceNamespace:"); sb.append(sourceNamespace + ","); }
    if (sourceSubnet != null) { sb.append("sourceSubnet:"); sb.append(sourceSubnet); }
    sb.append("}");
    return sb.toString();
  }
  
}