package io.fabric8.istio.api.networking.v1alpha3;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class StringMatchRegexBuilder extends StringMatchRegexFluentImpl<StringMatchRegexBuilder> implements VisitableBuilder<StringMatchRegex,StringMatchRegexBuilder>{
  public StringMatchRegexBuilder() {
    this(false);
  }
  public StringMatchRegexBuilder(Boolean validationEnabled) {
    this(new StringMatchRegex(), validationEnabled);
  }
  public StringMatchRegexBuilder(StringMatchRegexFluent<?> fluent) {
    this(fluent, false);
  }
  public StringMatchRegexBuilder(StringMatchRegexFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new StringMatchRegex(), validationEnabled);
  }
  public StringMatchRegexBuilder(StringMatchRegexFluent<?> fluent,StringMatchRegex instance) {
    this(fluent, instance, false);
  }
  public StringMatchRegexBuilder(StringMatchRegexFluent<?> fluent,StringMatchRegex instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withRegex(instance.getRegex()); 
    this.validationEnabled = validationEnabled; 
  }
  public StringMatchRegexBuilder(StringMatchRegex instance) {
    this(instance,false);
  }
  public StringMatchRegexBuilder(StringMatchRegex instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withRegex(instance.getRegex()); 
    this.validationEnabled = validationEnabled; 
  }
  StringMatchRegexFluent<?> fluent;
  Boolean validationEnabled;
  public StringMatchRegex build() {
    StringMatchRegex buildable = new StringMatchRegex(fluent.getRegex());
    return buildable;
  }
  
}