package io.fabric8.istio.api.networking.v1alpha3;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Boolean;
import java.lang.Integer;
import java.lang.Object;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class TrafficPolicyPortTrafficPolicyFluentImpl<A extends TrafficPolicyPortTrafficPolicyFluent<A>> extends BaseFluent<A> implements TrafficPolicyPortTrafficPolicyFluent<A>{
  public TrafficPolicyPortTrafficPolicyFluentImpl() {
  }
  public TrafficPolicyPortTrafficPolicyFluentImpl(TrafficPolicyPortTrafficPolicy instance) {
    this.withConnectionPool(instance.getConnectionPool()); 
    this.withLoadBalancer(instance.getLoadBalancer()); 
    this.withOutlierDetection(instance.getOutlierDetection()); 
    this.withPort(instance.getPort()); 
    this.withTls(instance.getTls()); 
  }
  private ConnectionPoolSettingsBuilder connectionPool;
  private LoadBalancerSettingsBuilder loadBalancer;
  private OutlierDetectionBuilder outlierDetection;
  private PortSelectorBuilder port;
  private ClientTLSSettingsBuilder tls;
  
  /**
   * This method has been deprecated, please use method buildConnectionPool instead.
   * @return The buildable object.
   */
  @Deprecated
  public ConnectionPoolSettings getConnectionPool() {
    return this.connectionPool!=null ?this.connectionPool.build():null;
  }
  public ConnectionPoolSettings buildConnectionPool() {
    return this.connectionPool!=null ?this.connectionPool.build():null;
  }
  public A withConnectionPool(ConnectionPoolSettings connectionPool) {
    _visitables.get("connectionPool").remove(this.connectionPool);
    if (connectionPool!=null){ this.connectionPool= new ConnectionPoolSettingsBuilder(connectionPool); _visitables.get("connectionPool").add(this.connectionPool);} else { this.connectionPool = null; _visitables.get("connectionPool").remove(this.connectionPool); } return (A) this;
  }
  public Boolean hasConnectionPool() {
    return this.connectionPool != null;
  }
  public TrafficPolicyPortTrafficPolicyFluent.ConnectionPoolNested<A> withNewConnectionPool() {
    return new TrafficPolicyPortTrafficPolicyFluentImpl.ConnectionPoolNestedImpl();
  }
  public TrafficPolicyPortTrafficPolicyFluent.ConnectionPoolNested<A> withNewConnectionPoolLike(ConnectionPoolSettings item) {
    return new TrafficPolicyPortTrafficPolicyFluentImpl.ConnectionPoolNestedImpl(item);
  }
  public TrafficPolicyPortTrafficPolicyFluent.ConnectionPoolNested<A> editConnectionPool() {
    return withNewConnectionPoolLike(getConnectionPool());
  }
  public TrafficPolicyPortTrafficPolicyFluent.ConnectionPoolNested<A> editOrNewConnectionPool() {
    return withNewConnectionPoolLike(getConnectionPool() != null ? getConnectionPool(): new ConnectionPoolSettingsBuilder().build());
  }
  public TrafficPolicyPortTrafficPolicyFluent.ConnectionPoolNested<A> editOrNewConnectionPoolLike(ConnectionPoolSettings item) {
    return withNewConnectionPoolLike(getConnectionPool() != null ? getConnectionPool(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildLoadBalancer instead.
   * @return The buildable object.
   */
  @Deprecated
  public LoadBalancerSettings getLoadBalancer() {
    return this.loadBalancer!=null ?this.loadBalancer.build():null;
  }
  public LoadBalancerSettings buildLoadBalancer() {
    return this.loadBalancer!=null ?this.loadBalancer.build():null;
  }
  public A withLoadBalancer(LoadBalancerSettings loadBalancer) {
    _visitables.get("loadBalancer").remove(this.loadBalancer);
    if (loadBalancer!=null){ this.loadBalancer= new LoadBalancerSettingsBuilder(loadBalancer); _visitables.get("loadBalancer").add(this.loadBalancer);} else { this.loadBalancer = null; _visitables.get("loadBalancer").remove(this.loadBalancer); } return (A) this;
  }
  public Boolean hasLoadBalancer() {
    return this.loadBalancer != null;
  }
  public TrafficPolicyPortTrafficPolicyFluent.LoadBalancerNested<A> withNewLoadBalancer() {
    return new TrafficPolicyPortTrafficPolicyFluentImpl.LoadBalancerNestedImpl();
  }
  public TrafficPolicyPortTrafficPolicyFluent.LoadBalancerNested<A> withNewLoadBalancerLike(LoadBalancerSettings item) {
    return new TrafficPolicyPortTrafficPolicyFluentImpl.LoadBalancerNestedImpl(item);
  }
  public TrafficPolicyPortTrafficPolicyFluent.LoadBalancerNested<A> editLoadBalancer() {
    return withNewLoadBalancerLike(getLoadBalancer());
  }
  public TrafficPolicyPortTrafficPolicyFluent.LoadBalancerNested<A> editOrNewLoadBalancer() {
    return withNewLoadBalancerLike(getLoadBalancer() != null ? getLoadBalancer(): new LoadBalancerSettingsBuilder().build());
  }
  public TrafficPolicyPortTrafficPolicyFluent.LoadBalancerNested<A> editOrNewLoadBalancerLike(LoadBalancerSettings item) {
    return withNewLoadBalancerLike(getLoadBalancer() != null ? getLoadBalancer(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildOutlierDetection instead.
   * @return The buildable object.
   */
  @Deprecated
  public OutlierDetection getOutlierDetection() {
    return this.outlierDetection!=null ?this.outlierDetection.build():null;
  }
  public OutlierDetection buildOutlierDetection() {
    return this.outlierDetection!=null ?this.outlierDetection.build():null;
  }
  public A withOutlierDetection(OutlierDetection outlierDetection) {
    _visitables.get("outlierDetection").remove(this.outlierDetection);
    if (outlierDetection!=null){ this.outlierDetection= new OutlierDetectionBuilder(outlierDetection); _visitables.get("outlierDetection").add(this.outlierDetection);} else { this.outlierDetection = null; _visitables.get("outlierDetection").remove(this.outlierDetection); } return (A) this;
  }
  public Boolean hasOutlierDetection() {
    return this.outlierDetection != null;
  }
  public TrafficPolicyPortTrafficPolicyFluent.OutlierDetectionNested<A> withNewOutlierDetection() {
    return new TrafficPolicyPortTrafficPolicyFluentImpl.OutlierDetectionNestedImpl();
  }
  public TrafficPolicyPortTrafficPolicyFluent.OutlierDetectionNested<A> withNewOutlierDetectionLike(OutlierDetection item) {
    return new TrafficPolicyPortTrafficPolicyFluentImpl.OutlierDetectionNestedImpl(item);
  }
  public TrafficPolicyPortTrafficPolicyFluent.OutlierDetectionNested<A> editOutlierDetection() {
    return withNewOutlierDetectionLike(getOutlierDetection());
  }
  public TrafficPolicyPortTrafficPolicyFluent.OutlierDetectionNested<A> editOrNewOutlierDetection() {
    return withNewOutlierDetectionLike(getOutlierDetection() != null ? getOutlierDetection(): new OutlierDetectionBuilder().build());
  }
  public TrafficPolicyPortTrafficPolicyFluent.OutlierDetectionNested<A> editOrNewOutlierDetectionLike(OutlierDetection item) {
    return withNewOutlierDetectionLike(getOutlierDetection() != null ? getOutlierDetection(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildPort instead.
   * @return The buildable object.
   */
  @Deprecated
  public PortSelector getPort() {
    return this.port!=null ?this.port.build():null;
  }
  public PortSelector buildPort() {
    return this.port!=null ?this.port.build():null;
  }
  public A withPort(PortSelector port) {
    _visitables.get("port").remove(this.port);
    if (port!=null){ this.port= new PortSelectorBuilder(port); _visitables.get("port").add(this.port);} else { this.port = null; _visitables.get("port").remove(this.port); } return (A) this;
  }
  public Boolean hasPort() {
    return this.port != null;
  }
  public A withNewPort(Integer number) {
    return (A)withPort(new PortSelector(number));
  }
  public TrafficPolicyPortTrafficPolicyFluent.PortNested<A> withNewPort() {
    return new TrafficPolicyPortTrafficPolicyFluentImpl.PortNestedImpl();
  }
  public TrafficPolicyPortTrafficPolicyFluent.PortNested<A> withNewPortLike(PortSelector item) {
    return new TrafficPolicyPortTrafficPolicyFluentImpl.PortNestedImpl(item);
  }
  public TrafficPolicyPortTrafficPolicyFluent.PortNested<A> editPort() {
    return withNewPortLike(getPort());
  }
  public TrafficPolicyPortTrafficPolicyFluent.PortNested<A> editOrNewPort() {
    return withNewPortLike(getPort() != null ? getPort(): new PortSelectorBuilder().build());
  }
  public TrafficPolicyPortTrafficPolicyFluent.PortNested<A> editOrNewPortLike(PortSelector item) {
    return withNewPortLike(getPort() != null ? getPort(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildTls instead.
   * @return The buildable object.
   */
  @Deprecated
  public ClientTLSSettings getTls() {
    return this.tls!=null ?this.tls.build():null;
  }
  public ClientTLSSettings buildTls() {
    return this.tls!=null ?this.tls.build():null;
  }
  public A withTls(ClientTLSSettings tls) {
    _visitables.get("tls").remove(this.tls);
    if (tls!=null){ this.tls= new ClientTLSSettingsBuilder(tls); _visitables.get("tls").add(this.tls);} else { this.tls = null; _visitables.get("tls").remove(this.tls); } return (A) this;
  }
  public Boolean hasTls() {
    return this.tls != null;
  }
  public TrafficPolicyPortTrafficPolicyFluent.TlsNested<A> withNewTls() {
    return new TrafficPolicyPortTrafficPolicyFluentImpl.TlsNestedImpl();
  }
  public TrafficPolicyPortTrafficPolicyFluent.TlsNested<A> withNewTlsLike(ClientTLSSettings item) {
    return new TrafficPolicyPortTrafficPolicyFluentImpl.TlsNestedImpl(item);
  }
  public TrafficPolicyPortTrafficPolicyFluent.TlsNested<A> editTls() {
    return withNewTlsLike(getTls());
  }
  public TrafficPolicyPortTrafficPolicyFluent.TlsNested<A> editOrNewTls() {
    return withNewTlsLike(getTls() != null ? getTls(): new ClientTLSSettingsBuilder().build());
  }
  public TrafficPolicyPortTrafficPolicyFluent.TlsNested<A> editOrNewTlsLike(ClientTLSSettings item) {
    return withNewTlsLike(getTls() != null ? getTls(): item);
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    TrafficPolicyPortTrafficPolicyFluentImpl that = (TrafficPolicyPortTrafficPolicyFluentImpl) o;
    if (connectionPool != null ? !connectionPool.equals(that.connectionPool) :that.connectionPool != null) return false;
    if (loadBalancer != null ? !loadBalancer.equals(that.loadBalancer) :that.loadBalancer != null) return false;
    if (outlierDetection != null ? !outlierDetection.equals(that.outlierDetection) :that.outlierDetection != null) return false;
    if (port != null ? !port.equals(that.port) :that.port != null) return false;
    if (tls != null ? !tls.equals(that.tls) :that.tls != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(connectionPool,  loadBalancer,  outlierDetection,  port,  tls,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (connectionPool != null) { sb.append("connectionPool:"); sb.append(connectionPool + ","); }
    if (loadBalancer != null) { sb.append("loadBalancer:"); sb.append(loadBalancer + ","); }
    if (outlierDetection != null) { sb.append("outlierDetection:"); sb.append(outlierDetection + ","); }
    if (port != null) { sb.append("port:"); sb.append(port + ","); }
    if (tls != null) { sb.append("tls:"); sb.append(tls); }
    sb.append("}");
    return sb.toString();
  }
  class ConnectionPoolNestedImpl<N> extends ConnectionPoolSettingsFluentImpl<TrafficPolicyPortTrafficPolicyFluent.ConnectionPoolNested<N>> implements TrafficPolicyPortTrafficPolicyFluent.ConnectionPoolNested<N>,Nested<N>{
    ConnectionPoolNestedImpl(ConnectionPoolSettings item) {
      this.builder = new ConnectionPoolSettingsBuilder(this, item);
    }
    ConnectionPoolNestedImpl() {
      this.builder = new ConnectionPoolSettingsBuilder(this);
    }
    ConnectionPoolSettingsBuilder builder;
    public N and() {
      return (N) TrafficPolicyPortTrafficPolicyFluentImpl.this.withConnectionPool(builder.build());
    }
    public N endConnectionPool() {
      return and();
    }
    
  }
  class LoadBalancerNestedImpl<N> extends LoadBalancerSettingsFluentImpl<TrafficPolicyPortTrafficPolicyFluent.LoadBalancerNested<N>> implements TrafficPolicyPortTrafficPolicyFluent.LoadBalancerNested<N>,Nested<N>{
    LoadBalancerNestedImpl(LoadBalancerSettings item) {
      this.builder = new LoadBalancerSettingsBuilder(this, item);
    }
    LoadBalancerNestedImpl() {
      this.builder = new LoadBalancerSettingsBuilder(this);
    }
    LoadBalancerSettingsBuilder builder;
    public N and() {
      return (N) TrafficPolicyPortTrafficPolicyFluentImpl.this.withLoadBalancer(builder.build());
    }
    public N endLoadBalancer() {
      return and();
    }
    
  }
  class OutlierDetectionNestedImpl<N> extends OutlierDetectionFluentImpl<TrafficPolicyPortTrafficPolicyFluent.OutlierDetectionNested<N>> implements TrafficPolicyPortTrafficPolicyFluent.OutlierDetectionNested<N>,Nested<N>{
    OutlierDetectionNestedImpl(OutlierDetection item) {
      this.builder = new OutlierDetectionBuilder(this, item);
    }
    OutlierDetectionNestedImpl() {
      this.builder = new OutlierDetectionBuilder(this);
    }
    OutlierDetectionBuilder builder;
    public N and() {
      return (N) TrafficPolicyPortTrafficPolicyFluentImpl.this.withOutlierDetection(builder.build());
    }
    public N endOutlierDetection() {
      return and();
    }
    
  }
  class PortNestedImpl<N> extends PortSelectorFluentImpl<TrafficPolicyPortTrafficPolicyFluent.PortNested<N>> implements TrafficPolicyPortTrafficPolicyFluent.PortNested<N>,Nested<N>{
    PortNestedImpl(PortSelector item) {
      this.builder = new PortSelectorBuilder(this, item);
    }
    PortNestedImpl() {
      this.builder = new PortSelectorBuilder(this);
    }
    PortSelectorBuilder builder;
    public N and() {
      return (N) TrafficPolicyPortTrafficPolicyFluentImpl.this.withPort(builder.build());
    }
    public N endPort() {
      return and();
    }
    
  }
  class TlsNestedImpl<N> extends ClientTLSSettingsFluentImpl<TrafficPolicyPortTrafficPolicyFluent.TlsNested<N>> implements TrafficPolicyPortTrafficPolicyFluent.TlsNested<N>,Nested<N>{
    TlsNestedImpl(ClientTLSSettings item) {
      this.builder = new ClientTLSSettingsBuilder(this, item);
    }
    TlsNestedImpl() {
      this.builder = new ClientTLSSettingsBuilder(this);
    }
    ClientTLSSettingsBuilder builder;
    public N and() {
      return (N) TrafficPolicyPortTrafficPolicyFluentImpl.this.withTls(builder.build());
    }
    public N endTls() {
      return and();
    }
    
  }
  
}