package io.fabric8.istio.api.networking.v1alpha3;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class WorkloadGroupObjectMetaBuilder extends WorkloadGroupObjectMetaFluentImpl<WorkloadGroupObjectMetaBuilder> implements VisitableBuilder<WorkloadGroupObjectMeta,WorkloadGroupObjectMetaBuilder>{
  public WorkloadGroupObjectMetaBuilder() {
    this(false);
  }
  public WorkloadGroupObjectMetaBuilder(Boolean validationEnabled) {
    this(new WorkloadGroupObjectMeta(), validationEnabled);
  }
  public WorkloadGroupObjectMetaBuilder(WorkloadGroupObjectMetaFluent<?> fluent) {
    this(fluent, false);
  }
  public WorkloadGroupObjectMetaBuilder(WorkloadGroupObjectMetaFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new WorkloadGroupObjectMeta(), validationEnabled);
  }
  public WorkloadGroupObjectMetaBuilder(WorkloadGroupObjectMetaFluent<?> fluent,WorkloadGroupObjectMeta instance) {
    this(fluent, instance, false);
  }
  public WorkloadGroupObjectMetaBuilder(WorkloadGroupObjectMetaFluent<?> fluent,WorkloadGroupObjectMeta instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withAnnotations(instance.getAnnotations()); 
    fluent.withLabels(instance.getLabels()); 
    this.validationEnabled = validationEnabled; 
  }
  public WorkloadGroupObjectMetaBuilder(WorkloadGroupObjectMeta instance) {
    this(instance,false);
  }
  public WorkloadGroupObjectMetaBuilder(WorkloadGroupObjectMeta instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withAnnotations(instance.getAnnotations()); 
    this.withLabels(instance.getLabels()); 
    this.validationEnabled = validationEnabled; 
  }
  WorkloadGroupObjectMetaFluent<?> fluent;
  Boolean validationEnabled;
  public WorkloadGroupObjectMeta build() {
    WorkloadGroupObjectMeta buildable = new WorkloadGroupObjectMeta(fluent.getAnnotations(),fluent.getLabels());
    return buildable;
  }
  
}