package io.fabric8.istio.api.security.v1beta1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class RequestAuthenticationListBuilder extends RequestAuthenticationListFluentImpl<RequestAuthenticationListBuilder> implements VisitableBuilder<RequestAuthenticationList,RequestAuthenticationListBuilder>{
  public RequestAuthenticationListBuilder() {
    this(false);
  }
  public RequestAuthenticationListBuilder(Boolean validationEnabled) {
    this(new RequestAuthenticationList(), validationEnabled);
  }
  public RequestAuthenticationListBuilder(RequestAuthenticationListFluent<?> fluent) {
    this(fluent, false);
  }
  public RequestAuthenticationListBuilder(RequestAuthenticationListFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new RequestAuthenticationList(), validationEnabled);
  }
  public RequestAuthenticationListBuilder(RequestAuthenticationListFluent<?> fluent,RequestAuthenticationList instance) {
    this(fluent, instance, false);
  }
  public RequestAuthenticationListBuilder(RequestAuthenticationListFluent<?> fluent,RequestAuthenticationList instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withApiVersion(instance.getApiVersion());
      fluent.withItems(instance.getItems());
      fluent.withKind(instance.getKind());
      fluent.withMetadata(instance.getMetadata());
    }
    this.validationEnabled = validationEnabled; 
  }
  public RequestAuthenticationListBuilder(RequestAuthenticationList instance) {
    this(instance,false);
  }
  public RequestAuthenticationListBuilder(RequestAuthenticationList instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withApiVersion(instance.getApiVersion());
      this.withItems(instance.getItems());
      this.withKind(instance.getKind());
      this.withMetadata(instance.getMetadata());
    }
    this.validationEnabled = validationEnabled; 
  }
  RequestAuthenticationListFluent<?> fluent;
  Boolean validationEnabled;
  public RequestAuthenticationList build() {
    RequestAuthenticationList buildable = new RequestAuthenticationList(fluent.getApiVersion(),fluent.getItems(),fluent.getKind(),fluent.getMetadata());
    return buildable;
  }
  
}