package io.fabric8.istio.api.security.v1beta1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.function.Predicate;
import io.fabric8.istio.api.type.v1beta1.WorkloadSelector;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.List;
import java.lang.Boolean;
import io.fabric8.istio.api.type.v1beta1.WorkloadSelectorBuilder;
import io.fabric8.istio.api.type.v1beta1.WorkloadSelectorFluentImpl;
import java.util.Collection;
import java.lang.Object;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class RequestAuthenticationSpecFluentImpl<A extends RequestAuthenticationSpecFluent<A>> extends BaseFluent<A> implements RequestAuthenticationSpecFluent<A>{
  public RequestAuthenticationSpecFluentImpl() {
  }
  public RequestAuthenticationSpecFluentImpl(RequestAuthenticationSpec instance) {
    if (instance != null) {
      this.withJwtRules(instance.getJwtRules());
      this.withSelector(instance.getSelector());
    }
  }
  private ArrayList<JWTRuleBuilder> jwtRules = new ArrayList<JWTRuleBuilder>();
  private WorkloadSelectorBuilder selector;
  public A addToJwtRules(int index,JWTRule item) {
    if (this.jwtRules == null) {this.jwtRules = new ArrayList<JWTRuleBuilder>();}
    JWTRuleBuilder builder = new JWTRuleBuilder(item);
    if (index < 0 || index >= jwtRules.size()) { _visitables.get("jwtRules").add(builder); jwtRules.add(builder); } else { _visitables.get("jwtRules").add(index, builder); jwtRules.add(index, builder);}
    return (A)this;
  }
  public A setToJwtRules(int index,JWTRule item) {
    if (this.jwtRules == null) {this.jwtRules = new ArrayList<JWTRuleBuilder>();}
    JWTRuleBuilder builder = new JWTRuleBuilder(item);
    if (index < 0 || index >= jwtRules.size()) { _visitables.get("jwtRules").add(builder); jwtRules.add(builder); } else { _visitables.get("jwtRules").set(index, builder); jwtRules.set(index, builder);}
    return (A)this;
  }
  public A addToJwtRules(io.fabric8.istio.api.security.v1beta1.JWTRule... items) {
    if (this.jwtRules == null) {this.jwtRules = new ArrayList<JWTRuleBuilder>();}
    for (JWTRule item : items) {JWTRuleBuilder builder = new JWTRuleBuilder(item);_visitables.get("jwtRules").add(builder);this.jwtRules.add(builder);} return (A)this;
  }
  public A addAllToJwtRules(Collection<JWTRule> items) {
    if (this.jwtRules == null) {this.jwtRules = new ArrayList<JWTRuleBuilder>();}
    for (JWTRule item : items) {JWTRuleBuilder builder = new JWTRuleBuilder(item);_visitables.get("jwtRules").add(builder);this.jwtRules.add(builder);} return (A)this;
  }
  public A removeFromJwtRules(io.fabric8.istio.api.security.v1beta1.JWTRule... items) {
    for (JWTRule item : items) {JWTRuleBuilder builder = new JWTRuleBuilder(item);_visitables.get("jwtRules").remove(builder);if (this.jwtRules != null) {this.jwtRules.remove(builder);}} return (A)this;
  }
  public A removeAllFromJwtRules(Collection<JWTRule> items) {
    for (JWTRule item : items) {JWTRuleBuilder builder = new JWTRuleBuilder(item);_visitables.get("jwtRules").remove(builder);if (this.jwtRules != null) {this.jwtRules.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromJwtRules(Predicate<JWTRuleBuilder> predicate) {
    if (jwtRules == null) return (A) this;
    final Iterator<JWTRuleBuilder> each = jwtRules.iterator();
    final List visitables = _visitables.get("jwtRules");
    while (each.hasNext()) {
      JWTRuleBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  /**
   * This method has been deprecated, please use method buildJwtRules instead.
   * @return The buildable object.
   */
  @Deprecated
  public List<JWTRule> getJwtRules() {
    return jwtRules != null ? build(jwtRules) : null;
  }
  public List<JWTRule> buildJwtRules() {
    return jwtRules != null ? build(jwtRules) : null;
  }
  public JWTRule buildJwtRule(int index) {
    return this.jwtRules.get(index).build();
  }
  public JWTRule buildFirstJwtRule() {
    return this.jwtRules.get(0).build();
  }
  public JWTRule buildLastJwtRule() {
    return this.jwtRules.get(jwtRules.size() - 1).build();
  }
  public JWTRule buildMatchingJwtRule(Predicate<JWTRuleBuilder> predicate) {
    for (JWTRuleBuilder item: jwtRules) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public Boolean hasMatchingJwtRule(Predicate<JWTRuleBuilder> predicate) {
    for (JWTRuleBuilder item: jwtRules) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withJwtRules(List<JWTRule> jwtRules) {
    if (this.jwtRules != null) { _visitables.get("jwtRules").clear();}
    if (jwtRules != null) {this.jwtRules = new ArrayList(); for (JWTRule item : jwtRules){this.addToJwtRules(item);}} else { this.jwtRules = null;} return (A) this;
  }
  public A withJwtRules(io.fabric8.istio.api.security.v1beta1.JWTRule... jwtRules) {
    if (this.jwtRules != null) {this.jwtRules.clear(); _visitables.remove("jwtRules"); }
    if (jwtRules != null) {for (JWTRule item :jwtRules){ this.addToJwtRules(item);}} return (A) this;
  }
  public Boolean hasJwtRules() {
    return jwtRules != null && !jwtRules.isEmpty();
  }
  public RequestAuthenticationSpecFluentImpl.JwtRulesNested<A> addNewJwtRule() {
    return new RequestAuthenticationSpecFluentImpl.JwtRulesNestedImpl();
  }
  public RequestAuthenticationSpecFluentImpl.JwtRulesNested<A> addNewJwtRuleLike(JWTRule item) {
    return new RequestAuthenticationSpecFluentImpl.JwtRulesNestedImpl(-1, item);
  }
  public RequestAuthenticationSpecFluentImpl.JwtRulesNested<A> setNewJwtRuleLike(int index,JWTRule item) {
    return new RequestAuthenticationSpecFluentImpl.JwtRulesNestedImpl(index, item);
  }
  public RequestAuthenticationSpecFluentImpl.JwtRulesNested<A> editJwtRule(int index) {
    if (jwtRules.size() <= index) throw new RuntimeException("Can't edit jwtRules. Index exceeds size.");
    return setNewJwtRuleLike(index, buildJwtRule(index));
  }
  public RequestAuthenticationSpecFluentImpl.JwtRulesNested<A> editFirstJwtRule() {
    if (jwtRules.size() == 0) throw new RuntimeException("Can't edit first jwtRules. The list is empty.");
    return setNewJwtRuleLike(0, buildJwtRule(0));
  }
  public RequestAuthenticationSpecFluentImpl.JwtRulesNested<A> editLastJwtRule() {
    int index = jwtRules.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last jwtRules. The list is empty.");
    return setNewJwtRuleLike(index, buildJwtRule(index));
  }
  public RequestAuthenticationSpecFluentImpl.JwtRulesNested<A> editMatchingJwtRule(Predicate<JWTRuleBuilder> predicate) {
    int index = -1;
    for (int i=0;i<jwtRules.size();i++) { 
    if (predicate.test(jwtRules.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching jwtRules. No match found.");
    return setNewJwtRuleLike(index, buildJwtRule(index));
  }
  
  /**
   * This method has been deprecated, please use method buildSelector instead.
   * @return The buildable object.
   */
  @Deprecated
  public WorkloadSelector getSelector() {
    return this.selector!=null ?this.selector.build():null;
  }
  public WorkloadSelector buildSelector() {
    return this.selector!=null ?this.selector.build():null;
  }
  public A withSelector(WorkloadSelector selector) {
    _visitables.get("selector").remove(this.selector);
    if (selector!=null){ this.selector= new WorkloadSelectorBuilder(selector); _visitables.get("selector").add(this.selector);} else { this.selector = null; _visitables.get("selector").remove(this.selector); } return (A) this;
  }
  public Boolean hasSelector() {
    return this.selector != null;
  }
  public RequestAuthenticationSpecFluentImpl.TypeSelectorNested<A> withNewTypeSelector() {
    return new RequestAuthenticationSpecFluentImpl.TypeSelectorNestedImpl();
  }
  public RequestAuthenticationSpecFluentImpl.TypeSelectorNested<A> withNewSelectorLike(WorkloadSelector item) {
    return new RequestAuthenticationSpecFluentImpl.TypeSelectorNestedImpl(item);
  }
  public RequestAuthenticationSpecFluentImpl.TypeSelectorNested<A> editTypeSelector() {
    return withNewSelectorLike(getSelector());
  }
  public RequestAuthenticationSpecFluentImpl.TypeSelectorNested<A> editOrNewSelector() {
    return withNewSelectorLike(getSelector() != null ? getSelector(): new WorkloadSelectorBuilder().build());
  }
  public RequestAuthenticationSpecFluentImpl.TypeSelectorNested<A> editOrNewSelectorLike(WorkloadSelector item) {
    return withNewSelectorLike(getSelector() != null ? getSelector(): item);
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    RequestAuthenticationSpecFluentImpl that = (RequestAuthenticationSpecFluentImpl) o;
    if (!java.util.Objects.equals(jwtRules, that.jwtRules)) return false;

    if (!java.util.Objects.equals(selector, that.selector)) return false;

    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(jwtRules,  selector,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (jwtRules != null) { sb.append("jwtRules:"); sb.append(jwtRules + ","); }
    if (selector != null) { sb.append("selector:"); sb.append(selector); }
    sb.append("}");
    return sb.toString();
  }
  class JwtRulesNestedImpl<N> extends JWTRuleFluentImpl<RequestAuthenticationSpecFluentImpl.JwtRulesNested<N>> implements RequestAuthenticationSpecFluentImpl.JwtRulesNested<N>,Nested<N>{
    JwtRulesNestedImpl(int index,JWTRule item) {
      this.index = index;
      this.builder = new JWTRuleBuilder(this, item);
    }
    JwtRulesNestedImpl() {
      this.index = -1;
      this.builder = new JWTRuleBuilder(this);
    }
    JWTRuleBuilder builder;
    int index;
    public N and() {
      return (N) RequestAuthenticationSpecFluentImpl.this.setToJwtRules(index,builder.build());
    }
    public N endJwtRule() {
      return and();
    }
    
  }
  class TypeSelectorNestedImpl<N> extends WorkloadSelectorFluentImpl<RequestAuthenticationSpecFluentImpl.TypeSelectorNested<N>> implements RequestAuthenticationSpecFluentImpl.TypeSelectorNested<N>,Nested<N>{
    TypeSelectorNestedImpl(WorkloadSelector item) {
      this.builder = new WorkloadSelectorBuilder(this, item);
    }
    TypeSelectorNestedImpl() {
      this.builder = new WorkloadSelectorBuilder(this);
    }
    WorkloadSelectorBuilder builder;
    public N and() {
      return (N) RequestAuthenticationSpecFluentImpl.this.withSelector(builder.build());
    }
    public N endTypeSelector() {
      return and();
    }
    
  }
  
}